"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebappConfig = void 0;
const path_1 = require("path");
const temp_file_1 = require("../temp-file");
class WebappConfig {
    constructor(props) {
        this.props = props;
        this.file = new temp_file_1.TempFile('config.json', JSON.stringify(this.frontendConfig));
    }
    get frontendConfig() {
        var _a;
        return {
            packageLinks: this.packageLinks,
            packageTags: this.packageTags,
            packageTagGroups: this.packageTagGroups,
            featuredPackages: this.featuredPackages,
            packageStats: (_a = this.props.showPackageStats) !== null && _a !== void 0 ? _a : true,
            featureFlags: this.props.featureFlags,
            categories: this.props.categories,
            debugInfo: this.debugInfo,
        };
    }
    get packageLinks() {
        var _a;
        const packageLinks = (_a = this.props.packageLinks) !== null && _a !== void 0 ? _a : [];
        // remove allowed domains from frontend config
        return packageLinks.map(({ allowedDomains, ...rest }) => rest);
    }
    get packageTags() {
        var _a;
        const packageTags = (_a = this.props.packageTags) !== null && _a !== void 0 ? _a : [];
        // remove conditional logic from frontend config
        return packageTags.map(({ condition, searchFilter, ...rest }) => {
            var _a;
            if (!searchFilter)
                return rest;
            const { group, groupBy } = searchFilter;
            if (!group && !groupBy) {
                throw new Error(`Expected a searchFilter.group or searchFilter.groupBy to be defined for ${rest.id}`);
            }
            return {
                ...rest,
                searchFilter: {
                    display: searchFilter.display,
                    groupBy: ((_a = group === null || group === void 0 ? void 0 : group.id) !== null && _a !== void 0 ? _a : groupBy),
                },
            };
        });
    }
    get packageTagGroups() {
        var _a, _b;
        return (_b = (_a = this.props.packageTagGroups) === null || _a === void 0 ? void 0 : _a.map((group) => group.bind())) !== null && _b !== void 0 ? _b : [];
    }
    get featuredPackages() {
        var _a;
        const config = (_a = this.props.featuredPackages) !== null && _a !== void 0 ? _a : {
            sections: [
                {
                    name: 'Recently updated',
                    showLastUpdated: 10,
                },
            ],
        };
        for (const section of config.sections) {
            if ((section.showPackages !== undefined && section.showLastUpdated !== undefined) ||
                (section.showPackages === undefined && section.showLastUpdated === undefined)) {
                throw new Error('Exactly one of \'showPackages\' and \'showPackages\' should be provided.');
            }
        }
        return config;
    }
    get debugInfo() {
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const packageJson = require(path_1.join('..', '..', 'package.json'));
        return {
            constructHubVersion: packageJson.version,
            constructHubWebappVersion: packageJson.devDependencies['construct-hub-webapp'],
        };
    }
}
exports.WebappConfig = WebappConfig;
//# sourceMappingURL=data:application/json;base64,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