import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface AlbFargateServicesProps {
    /**
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly tasks: FargateTaskProps[];
    /**
     * @stability stable
     */
    readonly route53Ops?: Route53Options;
    /**
     * create a FARGATE_SPOT only cluster.
     *
     * @default false
     * @stability stable
     */
    readonly spot?: boolean;
    /**
     * Whether to enable ECS Exec support.
     *
     * @default false
     * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html
     * @stability stable
     */
    readonly enableExecuteCommand?: boolean;
    /**
     * The subnets to associate with the service.
     *
     * @default -
     * {
     * subnetType: ec2.SubnetType.PRIVATE,
     * }
     * @stability stable
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
}
/**
 * The load balancer accessibility.
 *
 * @stability stable
 */
export declare enum LoadBalancerAccessibility {
    /**
     * register to external load balancer only.
     *
     * @stability stable
     */
    EXTERNAL_ONLY = "EXTERNAL_ONLY",
    /**
     * register to internal load balancer only.
     *
     * @stability stable
     */
    INTERNAL_ONLY = "INTERNAL_ONLY"
}
/**
 * @stability stable
 */
export interface FargateTaskProps {
    /**
     * @stability stable
     */
    readonly task: ecs.FargateTaskDefinition;
    /**
     * @stability stable
     */
    readonly listenerPort: number;
    /**
     * desired number of tasks for the service.
     *
     * @default 1
     * @stability stable
     */
    readonly desiredCount?: number;
    /**
     * service autoscaling policy.
     *
     * @default - { maxCapacity: 10, targetCpuUtilization: 50, requestsPerTarget: 1000 }
     * @stability stable
     */
    readonly scalingPolicy?: ServiceScalingPolicy;
    /**
     * @stability stable
     */
    readonly capacityProviderStrategy?: ecs.CapacityProviderStrategy[];
    /**
     * Register the service to internal ALB, external ALB or both.
     *
     * @default both
     * @stability stable
     */
    readonly accessibility?: LoadBalancerAccessibility;
}
/**
 * @stability stable
 */
export interface ServiceScalingPolicy {
    /**
     * max capacity for the service autoscaling.
     *
     * @default 10
     * @stability stable
     */
    readonly maxCapacity?: number;
    /**
     * target cpu utilization.
     *
     * @default 50
     * @stability stable
     */
    readonly targetCpuUtilization?: number;
    /**
     * request per target.
     *
     * @default 1000
     * @stability stable
     */
    readonly requestPerTarget?: number;
}
/**
 * @stability stable
 */
export interface Route53Options {
    /**
     * private zone name.
     *
     * @default svc.local
     * @stability stable
     */
    readonly zoneName?: string;
    /**
     * the external ALB record name.
     *
     * @default external
     * @stability stable
     */
    readonly externalAlbRecordName?: string;
    /**
     * the internal ALB record name.
     *
     * @default internal
     * @stability stable
     */
    readonly internalAlbRecordName?: string;
}
/**
 * @stability stable
 */
export declare class AlbFargateServices extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly externalAlb?: elbv2.ApplicationLoadBalancer;
    /**
     * @stability stable
     */
    readonly internalAlb?: elbv2.ApplicationLoadBalancer;
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * The service(s) created from the task(s).
     *
     * @stability stable
     */
    readonly service: ecs.FargateService[];
    private hasExternalLoadBalancer;
    private hasInternalLoadBalancer;
    private vpcSubnets;
    /**
     * determine if vpcSubnets are all public ones
     */
    private isPublicSubnets;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: AlbFargateServicesProps);
    private validateSubnets;
}
