"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbFargateServices = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdknag = require("./cdknag");
const main_1 = require("./main");
class AlbFargateServices extends main_1.BaseFargateServices {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id, props);
        // create the access log bucket
        const accessLogBucket = new cdknag.AccessLogDeliveryBucket(this, 'AccessLogBucket').bucket;
        if (this.hasExternalLoadBalancer) {
            this.externalAlb = new aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationLoadBalancer(this, 'ExternalAlb', {
                vpc: this.vpc,
                internetFacing: true,
            });
            this.externalAlb.logAccessLogs(accessLogBucket, `${id}-extalblog`);
        }
        if (this.hasInternalLoadBalancer) {
            this.internalAlb = new aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationLoadBalancer(this, 'InternalAlb', {
                vpc: this.vpc,
                internetFacing: false,
            });
            this.internalAlb.logAccessLogs(accessLogBucket, `${id}-intalblog`);
        }
        props.tasks.forEach((t, index) => {
            var _b, _c, _d, _e, _f, _g, _h, _j, _k;
            const defaultContainerName = (_b = t.task.defaultContainer) === null || _b === void 0 ? void 0 : _b.containerName;
            // default scaling policy
            const scaling = this.service[index].autoScaleTaskCount({ maxCapacity: (_d = (_c = t.scalingPolicy) === null || _c === void 0 ? void 0 : _c.maxCapacity) !== null && _d !== void 0 ? _d : 10 });
            scaling.scaleOnCpuUtilization('CpuScaling', {
                targetUtilizationPercent: (_f = (_e = t.scalingPolicy) === null || _e === void 0 ? void 0 : _e.targetCpuUtilization) !== null && _f !== void 0 ? _f : 50,
            });
            if (t.accessibility != main_1.LoadBalancerAccessibility.INTERNAL_ONLY) {
                const exttg = new aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationTargetGroup(this, `${defaultContainerName}ExtTG`, {
                    protocol: aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationProtocol.HTTP,
                    vpc: this.vpc,
                });
                // listener for the external ALB
                new aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationListener(this, `ExtAlbListener${t.listenerPort}`, {
                    loadBalancer: this.externalAlb,
                    open: true,
                    port: t.listenerPort,
                    protocol: aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationProtocol.HTTP,
                    defaultTargetGroups: [exttg],
                });
                scaling.scaleOnRequestCount('RequestScaling', {
                    requestsPerTarget: (_h = (_g = t.scalingPolicy) === null || _g === void 0 ? void 0 : _g.requestPerTarget) !== null && _h !== void 0 ? _h : 1000,
                    targetGroup: exttg,
                });
                exttg.addTarget(this.service[index]);
            }
            if (t.accessibility != main_1.LoadBalancerAccessibility.EXTERNAL_ONLY) {
                const inttg = new aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationTargetGroup(this, `${defaultContainerName}IntTG`, {
                    protocol: aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationProtocol.HTTP,
                    vpc: this.vpc,
                });
                // listener for the internal ALB
                new aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationListener(this, `IntAlbListener${t.listenerPort}`, {
                    loadBalancer: this.internalAlb,
                    open: true,
                    port: t.listenerPort,
                    protocol: aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationProtocol.HTTP,
                    defaultTargetGroups: [inttg],
                });
                // extra scaling policy
                scaling.scaleOnRequestCount('RequestScaling2', {
                    requestsPerTarget: (_k = (_j = t.scalingPolicy) === null || _j === void 0 ? void 0 : _j.requestPerTarget) !== null && _k !== void 0 ? _k : 1000,
                    targetGroup: inttg,
                });
                inttg.addTarget(this.service[index]);
            }
        });
        // Route53
        const externalAlbRecordName = (_c = (_b = props.route53Ops) === null || _b === void 0 ? void 0 : _b.externalElbRecordName) !== null && _c !== void 0 ? _c : 'external';
        const internalAlbRecordName = (_e = (_d = props.route53Ops) === null || _d === void 0 ? void 0 : _d.internalElbRecordName) !== null && _e !== void 0 ? _e : 'internal';
        const zone = new aws_cdk_lib_1.aws_route53.PrivateHostedZone(this, 'HostedZone', {
            zoneName: this.zoneName,
            vpc: this.vpc,
        });
        if (this.hasInternalLoadBalancer) {
            new aws_cdk_lib_1.aws_route53.ARecord(this, 'InternalAlbAlias', {
                zone,
                recordName: internalAlbRecordName,
                target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.LoadBalancerTarget(this.internalAlb)),
            });
        }
        if (this.hasExternalLoadBalancer) {
            new aws_cdk_lib_1.aws_route53.ARecord(this, 'ExternalAlbAlias', {
                zone,
                recordName: externalAlbRecordName,
                target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.LoadBalancerTarget(this.externalAlb)),
            });
        }
        if (this.hasExternalLoadBalancer) {
            new aws_cdk_lib_1.CfnOutput(this, 'ExternalEndpoint', { value: `http://${this.externalAlb.loadBalancerDnsName}` });
            new aws_cdk_lib_1.CfnOutput(this, 'ExternalEndpointPrivate', { value: `http://${externalAlbRecordName}.${this.zoneName}` });
        }
        if (this.hasInternalLoadBalancer) {
            new aws_cdk_lib_1.CfnOutput(this, 'InternalEndpoint', { value: `http://${this.internalAlb.loadBalancerDnsName}` });
            new aws_cdk_lib_1.CfnOutput(this, 'InternalEndpointPrivate', { value: `http://${internalAlbRecordName}.${this.zoneName}` });
        }
        // ensure the dependency
        const cp = this.node.tryFindChild('Cluster');
        this.service.forEach(s => {
            s.node.addDependency(cp);
        });
        // add solution ID for the stack
        if (!aws_cdk_lib_1.Stack.of(this).templateOptions.description) {
            aws_cdk_lib_1.Stack.of(this).templateOptions.description = '(SO8030) - AWS CDK stack with serverless-container-constructs';
        }
        /**
         * suppress the cdk-nag rules
         */
        if (this.externalAlb) {
            let sg;
            sg = this.externalAlb.node.tryFindChild('SecurityGroup');
            cdknag.Suppress.securityGroup(sg, [
                {
                    id: 'AwsSolutions-EC23',
                    reason: 'public ALB requires 0.0.0.0/0 inbound access',
                },
            ]);
        }
        if (this.internalAlb) {
            let sg;
            sg = this.internalAlb.node.tryFindChild('SecurityGroup');
            cdknag.Suppress.securityGroup(sg, [
                {
                    id: 'AwsSolutions-EC23',
                    reason: 'internal ALB requires 0.0.0.0/0 inbound access',
                },
            ]);
        }
        props.tasks.forEach(t => {
            var _b, _c;
            let cfnPolicy = (_b = t.task.executionRole) === null || _b === void 0 ? void 0 : _b.node.tryFindChild('DefaultPolicy');
            cdknag.Suppress.iamPolicy(cfnPolicy, [
                {
                    id: 'AwsSolutions-IAM5',
                    reason: 'ecr:GetAuthorizationToken requires wildcard resource',
                },
            ]);
            cfnPolicy = (_c = t.task.taskRole) === null || _c === void 0 ? void 0 : _c.node.tryFindChild('DefaultPolicy');
            cdknag.Suppress.iamPolicy(cfnPolicy, [
                {
                    id: 'AwsSolutions-IAM5',
                    reason: 'task role with ECS exec support requires wildcard resource for ssmmessages. see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html',
                },
            ]);
        });
    }
}
exports.AlbFargateServices = AlbFargateServices;
_a = JSII_RTTI_SYMBOL_1;
AlbFargateServices[_a] = { fqn: "serverless-container-constructs.AlbFargateServices", version: "0.1.21" };
//# sourceMappingURL=data:application/json;base64,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