import { aws_s3 as s3 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
interface ruleToSuppress {
    readonly id: string;
    readonly reason: string;
}
export declare class Suppress {
    static bucket(construct: Construct, rulesToSuppress: ruleToSuppress[]): void;
    static securityGroup(construct: Construct, rulesToSuppress: ruleToSuppress[]): void;
    static iamPolicy(construct: Construct, rulesToSuppress: ruleToSuppress[]): void;
}
export interface BucketProps {
    readonly serverAccessLogsPrefix?: string;
}
/**
 * The generic access log and log delivery bucket.
 */
export declare class AccessLogDeliveryBucket extends Construct {
    readonly bucket: s3.Bucket;
    constructor(scope: Construct, id: string, props?: BucketProps);
}
export {};
