"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageVersionsTableWidget = void 0;
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const core_1 = require("@aws-cdk/core");
const _lambda_architecture_1 = require("../_lambda-architecture");
const package_versions_table_widget_function_1 = require("./package-versions-table-widget-function");
class PackageVersionsTableWidget extends aws_cloudwatch_1.ConcreteWidget {
    constructor(scope, id, props) {
        var _a, _b;
        super((_a = props.width) !== null && _a !== void 0 ? _a : 6, (_b = props.height) !== null && _b !== void 0 ? _b : 6);
        this.handler = new package_versions_table_widget_function_1.PackageVersionsTableWidgetFunction(scope, id, {
            architecture: _lambda_architecture_1.gravitonLambdaIfAvailable(scope),
            description: '[ConstructHub/MissingDocumentationWidget] Is a custom CloudWatch widget handler',
            environment: { BUCKET_NAME: props.bucket.bucketName, OBJECT_KEY: props.key },
            memorySize: 1024,
            timeout: core_1.Duration.seconds(15),
        });
        // The handler is a SingletonFunction, so the actual Function resource is
        // not in the construct's scope, instead it's in the Stack scope. We must
        // hence refer to the REAL function via a private property (UGLY!).
        core_1.Tags.of(this.handler.lambdaFunction).add('function-purpose', 'cloudwatch-custom-widget');
        props.bucket.grantRead(this.handler, props.key);
        this.key = props.key;
        this.description = props.description;
        this.title = props.title;
    }
    toJson() {
        var _a;
        return [{
                type: 'custom',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    endpoint: this.handler.functionArn,
                    params: {
                        key: this.key,
                        description: `${(_a = this.description) !== null && _a !== void 0 ? _a : ''}\n`,
                    },
                    title: this.title,
                    updateOn: {
                        refresh: true,
                        resize: false,
                        timeRange: false,
                    },
                },
            }];
    }
}
exports.PackageVersionsTableWidget = PackageVersionsTableWidget;
//# sourceMappingURL=data:application/json;base64,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