import type { TransliteratorInput } from '../payload-schema';
/**
 * This function receives an S3 event, and for each record, proceeds to download
 * the `.jsii` assembly the event refers to, transliterates it to the language,
 * configured in `TARGET_LANGUAGE`, and uploads the resulting `.jsii.<lang>`
 * object to S3.
 *
 * @param event   an S3 event payload
 * @param context a Lambda execution context
 *
 * @returns nothing
 */
export declare function handler(event: TransliteratorInput): Promise<{
    created: string[];
    deleted: string[];
}>;
