"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3StorageFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) Create s3 storage resources.
 *
 * @experimental
 */
class S3StorageFactory extends core_1.Construct {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        this.failoverActive = (_b = props.failover) !== null && _b !== void 0 ? _b : false;
    }
    /**
     * (experimental) Retrieve or create the storage factory for the current scope.
     *
     * This is stack singleton.
     *
     * @experimental
     */
    static getOrCreate(scope, props = {}) {
        const stack = core_1.Stack.of(scope);
        const factory = stack.node.tryFindChild(S3StorageFactory.UID);
        if (!factory) {
            return new S3StorageFactory(stack, S3StorageFactory.UID, props);
        }
        return stack.node.findChild(S3StorageFactory.UID);
    }
    ;
    /**
     * (experimental) Create a new bucket in a storage config aware manner.
     *
     * @returns s3.Bucket
     * @experimental
     */
    newBucket(scope, id, props) {
        function failoverFor(bucket) {
            const _failover = new s3.Bucket(scope, `Failover${id}`, props);
            core_1.Tags.of(_failover).add('failover', 'true');
            new core_1.CfnOutput(scope, 'SnapshotCommand', {
                description: `Snapshot ${bucket.node.path}`,
                value: `aws s3 sync s3://${bucket.bucketName} s3://${_failover.bucketName}`,
            });
            return _failover;
        }
        const primary = new s3.Bucket(scope, id, props);
        // note that we create the failover bucket even if we don't currently use it.
        // this is because conditioning bucket creation will eventually fail since buckets
        // are normally retained.
        const failover = failoverFor(primary);
        return this.failoverActive ? failover : primary;
    }
}
exports.S3StorageFactory = S3StorageFactory;
_a = JSII_RTTI_SYMBOL_1;
S3StorageFactory[_a] = { fqn: "construct-hub.S3StorageFactory", version: "0.3.216" };
S3StorageFactory.UID = 'S3StorageFactory';
//# sourceMappingURL=data:application/json;base64,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