from utils import floor_dec,ceiling_dec
import numpy as np
import pandas as pd
import sys
import plotly.graph_objects as go
import seaborn as sns
import matplotlib.pyplot as plt
def fmri_3dvisual(pval,mask,p_threshold,method,color_pal="YlORd",multi_pranges=True,title=None):
        """
        Title
        -----
        visualization of the 2D brain (axial, sagittal 
        and coronal) with the activated areas

        Description
        -----------
        a visualization method, using ggplot2 to draw the brain 
        from axial, sagittal and coronal view with activated area identified by p-values

        Parameters
        ----------
        pval:a 3D array of p-values used to plot activated area of the brain
        
        mask:np.ndarray; a 3D nifti or 3D array of data to show the shell of the brain
        The default is False.
        
        p_threshold:float; None or a numeric value that can be selected randomly below 0.05 to 
        drop all p-values above the threshold. If 'low5_percent' method is used, 
        make 'p_threshold' as None. The default is 0.05.
                
        method:string; a string that represents method for the plot. There are 3 options: 'min_max', 'scale_p' and 'low5_percent'. The default is 'scale_p'.
        'min_max' is to draw plot based on the color scale of the minimum and maximum of the p value; 
        'scale_p' is to draw the plot with fixed color scale for fixed range of p value; 
        'low5_percent' is to draw the plot for the smallest 5 percent of p value when all the p values are not significant.

        color_pal:string; the name of the color palettes provided by brew.pal. The default is "YlOrRd".

        multi_pranges:bool; an option under 'scale_p' method to decide whether there are at most 9 colors 
        in the legend for the ranges of p value, or at most 4 colors. 
        The default is True, choosing the larger number of colors for the plot.

        title:string; title of the plot
        
        details
        -------

        The function fmri_3dvisual is used to visualize the 3D plot of the brain 
        with its activated parts based on provided p values. The p values are generated by
        applying statistical test on fMRI data. When providing input of a 3D p-values data, 
        a 3D interactive plot will be generated with surface for the brain shell 
        and scatter points in different colors and size representing different stimulated levels.
    
                
        return
        ------

         list of two elements

            item plot - the 3d plot of the fMRI data drawn by plotly
            item pval_df - data.frame with the p value for each voxel and the specified color for it


        examples
        --------
        $ pip install sympy

        import sympy
        t, x = sympy.symbols('t, x')
        func=sympy.sin(t)
        xs=np.linspace(0,10,num=10)
        ys=np.linspace(0,10,num=10)
        print(kimesurface_transform(func,xs,ys))       
        """
        fig=go.Figure()
        def boundary_pt_func(z,struc_3d):
            dim_maskz=struc_3d[:,:,z-1].shape
            contour_pt=[]
            x=[k for k in range(1,dim_maskz[0]+1)]
            y=[k for k in range(1,dim_maskz[1]+1)]
            cs = plt.contour(x,y,struc_3d[:,:,z], [0.30])
            if(len(cs.collections)>0 ):
                contour_pt=cs.collections[0]
                # if(len(contour_pt.get_paths())>0):

                contour_pt=contour_pt.get_paths()[0]
                v = contour_pt.vertices
                x = v[:,0]
                y = v[:,1]
            if(len(contour_pt)!=0):
                return pd.DataFrame({"x":x,"y":y,"z":[z]*len(x)})
        if(not isinstance(pval,list) and not isinstance(pval,np.ndarray) or len(pval.shape)!=3):
            print("Pval should be an 3d array")
            sys.exit()
        elif(not isinstance(mask,list) and not isinstance(mask,np.ndarray) or len(mask.shape)!=3):
            print("mask should be a 3d array")
            sys.exit()
        elif(p_threshold is not None):
            if(not isinstance(p_threshold,int) and not isinstance(p_threshold,float) and p_threshold>0.05 and p_threshold<=0):
                print("p treshold should be a numeric value in the range (0,0.05)")
                sys.exit()
        elif(method not in ["scale_p", "low5_percent"]):
            print("'method' should only choose from 'scale_p' or 'low5_percent'.")
            sys.exit()
        z=[boundary_pt_func(k,mask) for k in range(mask.shape[2])]
        output=pd.concat(z)

        if(title is not None):
            plt.title(title)
        one_minus_p_3d=1-pval
        dim_pval=one_minus_p_3d.shape
        pval_df=pd.DataFrame({"x":np.repeat(np.linspace(1,dim_pval[0],num=dim_pval[0]),dim_pval[1]*dim_pval[2]),"y":(np.repeat(np.repeat(np.linspace(1,dim_pval[1],num=dim_pval[1]),dim_pval[0]),dim_pval[2])),"z":np.repeat(np.linspace(1,dim_pval[2],num=dim_pval[2]),dim_pval[1]*dim_pval[0])})
        pval_df["one_minus_p_3d"]=(one_minus_p_3d.flatten())
        pval_df["p_val"]=1-pval_df["one_minus_p_3d"]

        if(method=="scale_p"):
                        pval_df=pval_df[pval_df["p_val"]<=p_threshold]
                        pval_df["cut_invs"]=pd.cut(pval_df["p_val"],[0,1e-8,1e-7,1e-6,1e-5,1e-4,1e-3,1e-2,5e-2])
                        pval_df["colorgrp"]=pd.cut(pval_df["p_val"],[0,1e-8,1e-7,1e-6,1e-5,1e-4,1e-3,1e-2,5e-2],labels=False)
                        if(len(set(pval_df["cut_invs"]))<=4):
                            print("The number of p ranges is originally less than 4, it is recommended to turn multi pranges as False")

                        if(multi_pranges==False):
                            
                            pval_df["cut_invs"]=pd.cut(pval_df["p_val"],[1e-7,1e-5,1e-3,5e-2])
                            pval_df["colorgrp"]=pd.cut(pval_df["p_val"],[0,1e-8,1e-7,1e-6,1e-5,1e-4,1e-3,1e-2,5e-2],labels=False)

                        label_p=list(set(pval_df["cut_invs"]) )        
        elif(method=="low5_percent"):
                        quantile5_pt=pval_df["p_val"].quantile(0.05)
                        pval_df=pval_df[pval_df["p_val"]<quantile5_pt]
                        p_val_max_minus_min=max(pval_df["p_val"])-min(pval_df["p_val"])
                        if(p_val_max_minus_min!=0):
                            cut_pts=min(pval_df["p_val"])+np.linspace(0,9,retstep=1)*(p_val_max_minus_min/9)
                            cut_pts[len(cut_pts)-1]=ceiling_dec(cut_pts[len(cut_pts)-1],2)
                            cut_pts[0]=floor_dec(cut_pts[0],2)
                            pval_df["cut_invs"]=pd.cut(pval_df["p_val"],cut_pts)
                            pval_df["colorgrp"]=pd.cut(pval_df["p_val"],[0,1e-8,1e-7,1e-6,1e-5,1e-4,1e-3,1e-2,5e-2],labels=False)

                            label_p=set(pval_df["cut_invs"])
                        else:
                            pval_df["cut_invs"]=np.around(min(pval_df["p_val"]),3)
                            label_p=list(set(pval_df["cut_invs"]))
                            pval_df["colorgrp"]=1
                        label_p=list(set(pval_df["cut_invs"]) )
        if(multi_pranges==False):
            color_choice=list(sns.color_palette(color_pal,9))[::2]
            color_choice.reverse()
        else:
            color_choice=list(sns.color_palette(color_pal,9))
            color_choice.reverse()
        color_choice=np.array(color_choice)
        print(color_choice)
        pval_df["colorgrp"].values[np.isnan(pval_df["colorgrp"].values)] = 0
        print(pval_df["colorgrp"].values)
        pval_df["corresp_color"]=color_choice[(pval_df["colorgrp"].values)]
        x=list(set(pval_df["colorgrp"]))
        x.sort()
        for i in x:
            pts_grp=pval_df[pval_df["colorgrp"]==i]
            fig.add_trace(go.Scatter(x=pts_grp["x"],y=pts_grp["y"],z=pts_grp["z"],mode="markers"),name="pvalue in :"+label_p[i],marker=dict(opacity=0.6,symbol="circle",size=[a for a in range(len(pts_grp["color_choice"]),1,-1)][i],color=pts_grp["corresp_color"],line=dict(color=pts_grp["corresp_color"],width=0.3)))
        

        #some plot function
