"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const constants_1 = require("./backend/shared/constants");
const repository_1 = require("./codeartifact/repository");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(scope, id);
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = new s3.Bucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                {
                    noncurrentVersionTransitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: core_1.Duration.days(31),
                        },
                    ],
                },
                // Permanently delete non-current object versions after 3 months
                {
                    noncurrentVersionExpiration: core_1.Duration.days(90),
                    expiredObjectDeleteMarker: true,
                },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const codeArtifact = new repository_1.Repository(this, 'CodeArtifact', {
            description: 'Proxy to npmjs.com for ConstructHub',
            domainName: (_b = props.codeArtifactDomain) === null || _b === void 0 ? void 0 : _b.name,
            domainExists: props.codeArtifactDomain != null,
            upstreams: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.upstreams,
        });
        const { vpc, vpcEndpoints, vpcSubnets } = this.createVpc(props, codeArtifact);
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_d = props.denyList) !== null && _d !== void 0 ? _d : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            logRetention: props.logRetention,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets,
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder);
        const packageTagsSerialized = (_f = (_e = props.packageTags) === null || _e === void 0 ? void 0 : _e.map((config) => {
            return {
                ...config,
                condition: config.condition.bind(),
            };
        })) !== null && _f !== void 0 ? _f : [];
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', {
            bucket: packageData,
            orchestration,
            logRetention: props.logRetention,
            monitoring,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
        });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_g = props.allowedLicenses) !== null && _g !== void 0 ? _g : [
                ...spdx_license_1.SpdxLicense.apache(),
                ...spdx_license_1.SpdxLicense.bsd(),
                ...spdx_license_1.SpdxLicense.mit(),
            ],
        });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_h = props.packageSources) !== null && _h !== void 0 ? _h : [new package_sources_1.NpmJs()]).map((source) => source.bind(sources, {
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, logRetention: props.logRetention, monitoring });
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
        });
        new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
        });
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
    createVpc(props, codeArtifact) {
        if (props.isolateSensitiveTasks === false) {
            return { vpc: undefined, vpcEndpoints: undefined, vpcSubnets: undefined };
        }
        const vpc = new ec2.Vpc(this, 'Lambda-VPC', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 0,
            // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
            // a whole new VPC if we ever need to introduce subnets of these types.
            subnetConfiguration: [
                // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                { name: 'Public', subnetType: ec2.SubnetType.PUBLIC, reserved: true },
                { name: 'Private', subnetType: ec2.SubnetType.PRIVATE, reserved: true },
                { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED },
            ],
        });
        const vpcSubnets = { subnetType: ec2.SubnetType.ISOLATED };
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: vpcSubnets,
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: vpcSubnets,
            }),
            // This is needed so that ECS workloads can use the awslogs driver
            cloudWatchLogs: vpc.addInterfaceEndpoint('CloudWatch.Logs', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
                subnets: vpcSubnets,
            }),
            // These are needed for ECS workloads to be able to pull images
            ecrApi: vpc.addInterfaceEndpoint('ECR.API', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR,
                subnets: vpcSubnets,
            }),
            ecr: vpc.addInterfaceEndpoint('ECR.Docker', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
                subnets: vpcSubnets,
            }),
            // This is needed (among others) for CodeArtifact registry usage
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [vpcSubnets],
            }),
            // This is useful for getting results from ECS tasks within workflows
            stepFunctions: vpc.addInterfaceEndpoint('StepFunctions', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.STEP_FUNCTIONS,
                subnets: vpcSubnets,
            }),
        };
        // The S3 access is necessary for the CodeArtifact Repository and ECR Docker
        // endpoints to be used (they serve objects from S3).
        vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [
                // The in-region CodeArtifact S3 Bucket
                `${codeArtifact.s3BucketArn}/*`,
                // The in-region ECR layer bucket
                `arn:aws:s3:::prod-${core_1.Stack.of(this).region}-starport-layer-bucket/*`,
            ],
            // It doesn't seem we can constrain principals for these grants (unclear
            // which principal those calls are made from, or if that is something we
            // could name here).
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-and-ECR',
        }));
        return { vpc, vpcEndpoints, vpcSubnets };
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.2.7" };
//# sourceMappingURL=data:application/json;base64,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