"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fillMetric = void 0;
const crypto_1 = require("crypto");
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
/**
 * Creates a MathExpression on the current metric, applying the `FILL` function
 * to it. This is useful to turn a sparse metric into a continuous one.
 */
function fillMetric(metric, value = 0) {
    // We assume namespace + name is enough to uniquely identify a metric here.
    // This is true locally at this time, but in case this ever changes, consider
    // also processing dimensions and period.
    const h = crypto_1.createHash('sha256')
        .update(metric.namespace)
        .update('\0')
        .update(metric.metricName)
        .digest('hex');
    const metricName = `m${h}`;
    return new aws_cloudwatch_1.MathExpression({
        expression: `FILL(${metricName}, ${value})`,
        label: metric.label,
        usingMetrics: { [metricName]: metric },
    });
}
exports.fillMetric = fillMetric;
//# sourceMappingURL=data:application/json;base64,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