# Generated by Django 3.2.15 on 2023-03-29 16:25

from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="OutgoingRequestsLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        blank=True,
                        default="",
                        help_text="The url of the outgoing request.",
                        max_length=1000,
                        verbose_name="URL",
                    ),
                ),
                (
                    "hostname",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The hostname part of the url.",
                        max_length=255,
                        verbose_name="Hostname",
                    ),
                ),
                (
                    "params",
                    models.TextField(
                        blank=True,
                        help_text="The parameters (if they exist).",
                        verbose_name="Parameters",
                    ),
                ),
                (
                    "status_code",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="The status code of the response.",
                        null=True,
                        verbose_name="Status code",
                    ),
                ),
                (
                    "method",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The type of request method.",
                        max_length=10,
                        verbose_name="Method",
                    ),
                ),
                (
                    "req_content_type",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The content type of the request.",
                        max_length=50,
                        verbose_name="Request content type",
                    ),
                ),
                (
                    "res_content_type",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The content type of the response.",
                        max_length=50,
                        verbose_name="Response content type",
                    ),
                ),
                (
                    "req_headers",
                    models.TextField(
                        blank=True,
                        help_text="The request headers.",
                        null=True,
                        verbose_name="Request headers",
                    ),
                ),
                (
                    "res_headers",
                    models.TextField(
                        blank=True,
                        help_text="The response headers.",
                        null=True,
                        verbose_name="Response headers",
                    ),
                ),
                (
                    "response_ms",
                    models.PositiveIntegerField(
                        blank=True,
                        default=0,
                        help_text="This is the response time in ms.",
                        verbose_name="Response in ms",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        help_text="This is the date and time the API call was made.",
                        verbose_name="Timestamp",
                    ),
                ),
                (
                    "trace",
                    models.TextField(
                        blank=True,
                        help_text="Text providing information in case of request failure.",
                        null=True,
                        verbose_name="Trace",
                    ),
                ),
            ],
            options={
                "verbose_name": "Outgoing Requests Log",
                "verbose_name_plural": "Outgoing Requests Logs",
            },
        ),
    ]
