"use strict";
const cdk = require("@aws-cdk/core");
const artifact_1 = require("../lib/artifact");
const pipeline_1 = require("../lib/pipeline");
const validation_1 = require("../lib/validation");
const fake_source_action_1 = require("./fake-source-action");
function stageForTesting() {
    const stack = new cdk.Stack();
    const pipeline = new pipeline_1.Pipeline(stack, 'Pipeline');
    return pipeline.addStage({ stageName: 'stage' });
}
module.exports = {
    'name validation'(test) {
        const cases = [
            { name: 'BlahBleep123.@-_', shouldPassValidation: true, explanation: 'should be valid' },
            { name: '', shouldPassValidation: false, explanation: 'the empty string should be invalid' },
            { name: ' BlahBleep', shouldPassValidation: false, explanation: 'spaces should be invalid' },
            { name: '!BlahBleep', shouldPassValidation: false, explanation: '\'!\' should be invalid' }
        ];
        cases.forEach(testCase => {
            const name = testCase.name;
            const validationBlock = () => { validation_1.validateName('test thing', name); };
            if (testCase.shouldPassValidation) {
                test.doesNotThrow(validationBlock, Error, `${name} failed validation but ${testCase.explanation}`);
            }
            else {
                test.throws(validationBlock, Error, `${name} passed validation but ${testCase.explanation}`);
            }
        });
        test.done();
    },
    'Stage validation': {
        'should fail if Stage has no Actions'(test) {
            const stage = stageForTesting();
            test.deepEqual(stage.validate().length, 1);
            test.done();
        }
    },
    'Pipeline validation': {
        'should fail if Pipeline has no Stages'(test) {
            const stack = new cdk.Stack();
            const pipeline = new pipeline_1.Pipeline(stack, 'Pipeline');
            test.deepEqual(cdk.ConstructNode.validate(pipeline.node).length, 1);
            test.done();
        },
        'should fail if Pipeline has a Source Action in a non-first Stage'(test) {
            const stack = new cdk.Stack();
            const pipeline = new pipeline_1.Pipeline(stack, 'Pipeline');
            pipeline.addStage({
                stageName: 'FirstStage',
                actions: [
                    new fake_source_action_1.FakeSourceAction({
                        actionName: 'FakeSource',
                        output: new artifact_1.Artifact(),
                    }),
                ],
            });
            test.deepEqual(cdk.ConstructNode.validate(pipeline.node).length, 1);
            test.done();
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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