from dataclasses import dataclass, field
from typing import Optional
from sdk.models import shared


@dataclass
class DownloadSchemaPathParams:
    api_id: str = field(metadata={'path_param': { 'field_name': 'apiID', 'style': 'simple', 'explode': False }})
    version_id: str = field(metadata={'path_param': { 'field_name': 'versionID', 'style': 'simple', 'explode': False }})
    

@dataclass
class DownloadSchemaRequest:
    path_params: DownloadSchemaPathParams = field()
    

@dataclass
class DownloadSchemaResponse:
    content_type: str = field()
    status_code: int = field()
    error: Optional[shared.Error] = field(default=None)
    schema: Optional[bytes] = field(default=None)
    
