"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNoneAuthorizer = exports.isIamAuthorizer = exports.isCognitoAuthorizer = exports.isCustomAuthorizer = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
/**
 * Predicate for narrowing an authorizer to CustomAuthorizer
 */
exports.isCustomAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.CUSTOM;
/**
 * Predicate for narrowing an authorizer to CognitoAuthorizer
 */
exports.isCognitoAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.COGNITO;
/**
 * Predicate for narrowing an authorizer to IamAuthorizer
 */
exports.isIamAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.IAM;
/**
 * Predicate for narrowing an authorizer to NoneAuthorizer
 */
exports.isNoneAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.NONE;
//# sourceMappingURL=data:application/json;base64,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