/*
 * The internal definitions
 *
 * Copyright (C) 2011-2022, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( LIBFWEVT_INTERNAL_DEFINITIONS_H )
#define LIBFWEVT_INTERNAL_DEFINITIONS_H

#include <common.h>
#include <types.h>

/* Define HAVE_LOCAL_LIBFWEVT for local use of libfwevt
 */
#if !defined( HAVE_LOCAL_LIBFWEVT )
#include <libfwevt/definitions.h>

/* The definitions in <libfwevt/definitions.h> are copied here
 * for local use of libfwevt
 */
#else
#include <byte_stream.h>

#define LIBFWEVT_VERSION						20220723

/* The version string
 */
#define LIBFWEVT_VERSION_STRING						"20220723"

/* The byte order definitions
 */
#define LIBFWEVT_ENDIAN_BIG						_BYTE_STREAM_ENDIAN_BIG
#define LIBFWEVT_ENDIAN_LITTLE						_BYTE_STREAM_ENDIAN_LITTLE

/* The binary XML document read flags
 */
enum LIBFWEVT_XML_DOCUMENT_READ_FLAGS
{
	LIBFWEVT_XML_DOCUMENT_READ_FLAG_HAS_DATA_OFFSETS		= 0x01,
	LIBFWEVT_XML_DOCUMENT_READ_FLAG_HAS_DEPENDENCY_IDENTIFIERS	= 0x02
};

/* The binary XML token definitions
 */
enum LIBFWEVT_XML_TOKENS
{
	LIBFWEVT_XML_TOKEN_END_OF_FILE					= 0x00,
	LIBFWEVT_XML_TOKEN_OPEN_START_ELEMENT_TAG			= 0x01,
	LIBFWEVT_XML_TOKEN_CLOSE_START_ELEMENT_TAG			= 0x02,
	LIBFWEVT_XML_TOKEN_CLOSE_EMPTY_ELEMENT_TAG			= 0x03,
	LIBFWEVT_XML_TOKEN_END_ELEMENT_TAG				= 0x04,
	LIBFWEVT_XML_TOKEN_VALUE					= 0x05,
	LIBFWEVT_XML_TOKEN_ATTRIBUTE					= 0x06,
	LIBFWEVT_XML_TOKEN_CDATA_SECTION				= 0x07,
	LIBFWEVT_XML_TOKEN_CHARACTER_REFERENCE				= 0x08,
	LIBFWEVT_XML_TOKEN_ENTITY_REFERENCE				= 0x09,
	LIBFWEVT_XML_TOKEN_PI_TARGET					= 0x0a,
	LIBFWEVT_XML_TOKEN_PI_DATA					= 0x0b,
	LIBFWEVT_XML_TOKEN_TEMPLATE_INSTANCE				= 0x0c,
	LIBFWEVT_XML_TOKEN_NORMAL_SUBSTITUTION				= 0x0d,
	LIBFWEVT_XML_TOKEN_OPTIONAL_SUBSTITUTION			= 0x0e,
	LIBFWEVT_XML_TOKEN_FRAGMENT_HEADER				= 0x0f
};

#define LIBFWEVT_XML_TOKEN_FLAG_HAS_MORE_DATA				0x40

/* The value type definitions
 */
enum LIBFWEVT_VALUE_TYPES
{
	LIBFWEVT_VALUE_TYPE_NULL					= 0x00,
	LIBFWEVT_VALUE_TYPE_STRING_UTF16				= 0x01,
	LIBFWEVT_VALUE_TYPE_STRING_BYTE_STREAM				= 0x02,
	LIBFWEVT_VALUE_TYPE_INTEGER_8BIT				= 0x03,
	LIBFWEVT_VALUE_TYPE_UNSIGNED_INTEGER_8BIT			= 0x04,
	LIBFWEVT_VALUE_TYPE_INTEGER_16BIT				= 0x05,
	LIBFWEVT_VALUE_TYPE_UNSIGNED_INTEGER_16BIT			= 0x06,
	LIBFWEVT_VALUE_TYPE_INTEGER_32BIT				= 0x07,
	LIBFWEVT_VALUE_TYPE_UNSIGNED_INTEGER_32BIT			= 0x08,
	LIBFWEVT_VALUE_TYPE_INTEGER_64BIT				= 0x09,
	LIBFWEVT_VALUE_TYPE_UNSIGNED_INTEGER_64BIT			= 0x0a,
	LIBFWEVT_VALUE_TYPE_FLOATING_POINT_32BIT			= 0x0b,
	LIBFWEVT_VALUE_TYPE_FLOATING_POINT_64BIT			= 0x0c,
	LIBFWEVT_VALUE_TYPE_BOOLEAN					= 0x0d,
	LIBFWEVT_VALUE_TYPE_BINARY_DATA					= 0x0e,
	LIBFWEVT_VALUE_TYPE_GUID					= 0x0f,
	LIBFWEVT_VALUE_TYPE_SIZE					= 0x10,
	LIBFWEVT_VALUE_TYPE_FILETIME					= 0x11,
	LIBFWEVT_VALUE_TYPE_SYSTEMTIME					= 0x12,
	LIBFWEVT_VALUE_TYPE_NT_SECURITY_IDENTIFIER			= 0x13,
	LIBFWEVT_VALUE_TYPE_HEXADECIMAL_INTEGER_32BIT			= 0x14,
	LIBFWEVT_VALUE_TYPE_HEXADECIMAL_INTEGER_64BIT			= 0x15,

	LIBFWEVT_VALUE_TYPE_BINARY_XML					= 0x21,

	LIBFWEVT_VALUE_TYPE_ARRAY_OF_STRING_UTF16			= 0x81,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_STRING_BYTE_STREAM			= 0x82,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_INTEGER_8BIT			= 0x83,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_UNSIGNED_INTEGER_8BIT		= 0x84,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_INTEGER_16BIT			= 0x85,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_UNSIGNED_INTEGER_16BIT		= 0x86,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_INTEGER_32BIT			= 0x87,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_UNSIGNED_INTEGER_32BIT		= 0x88,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_INTEGER_64BIT			= 0x89,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_UNSIGNED_INTEGER_64BIT		= 0x8a,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_FLOATING_POINT_32BIT		= 0x8b,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_FLOATING_POINT_64BIT		= 0x8c,

	LIBFWEVT_VALUE_TYPE_ARRAY_OF_GUID				= 0x8f,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_SIZE				= 0x90,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_FILETIME				= 0x91,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_SYSTEMTIME				= 0x92,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_NT_SECURITY_IDENTIFIER		= 0x93,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_HEXADECIMAL_INTEGER_32BIT		= 0x94,
	LIBFWEVT_VALUE_TYPE_ARRAY_OF_HEXADECIMAL_INTEGER_64BIT		= 0x95,
};

#define LIBFWEVT_VALUE_TYPE_ARRAY					0x80

/* The XML tag type definitions
 */
enum LIBFWEVT_XML_TAG_TYPES
{
	LIBFWEVT_XML_TAG_TYPE_NODE,
	LIBFWEVT_XML_TAG_TYPE_CDATA,
	LIBFWEVT_XML_TAG_TYPE_PI
};

/* The XML tag flags definitions
 */
enum LIBFWEVT_XML_TAG_FLAGS
{
	LIBFWEVT_XML_TAG_FLAG_IS_TEMPLATE_DEFINITION			= 0x01
};

/* The XML template value flags definitions
 */
enum LIBFWEVT_XML_TEMPLATE_VALUE_FLAGS
{
	LIBFWEVT_XML_TEMPLATE_VALUE_FLAG_IS_DEFINITION			= 0x01
};

#endif /* !defined( HAVE_LOCAL_LIBFWEVT ) */

#define LIBFWEVT_XML_DOCUMENT_ELEMENT_RECURSION_DEPTH			256
#define LIBFWEVT_XML_DOCUMENT_TEMPLATE_INSTANCE_RECURSION_DEPTH		16
#define LIBFWEVT_XML_DOCUMENT_TEMPLATE_VALUE_ARRAY_RECURSION_DEPTH	64

#endif /* !defined( LIBFWEVT_INTERNAL_DEFINITIONS_H ) */

