# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

modules = \
['patchutils', 'patchutils_cli']
entry_points = \
{'console_scripts': ['patchutils = patchutils_cli:main']}

setup_kwargs = {
    'name': 'patchutils',
    'version': '1.1.2',
    'description': 'Work on patches based on files and directories',
    'long_description': '# patchutils\n\npatchutils provide utilities for making patches from directories and applying patches to directories.\nIf you like the library and use it in your project, please consider giving us a star :star:\n\nMade with :heart: by [Contributers](https://github.com/xcodz-dot/patchutils/blob/master/AUTHORS.md/)\n\n## Usage\n\n### Installation\n\nfrom pip:\n\n```bash\npip install patchutils -U\n```\n\nfrom latest repo\n\n```bash\ngit clone xcodz-dot/patchutils\npip install poetry\npoetry install\n```\n\n**do not use poetry until you know how it works**\n\n\n### API Documentation\nYou can check the steps to build documentation by doing this:\n\n```python\n>>> import patchutils\n>>> help(patchutils)\n```\n\nFor your convinience all documentation is pre-built under the docs directory.\n\n### Concept\n\nThere are three things to be noted:\n* directory information\n* patch\n* update files\n\n#### Directory Information\n\nDirectory Information is a simple dictionary object containing 3 fields:\n\n* ##### `files`\n  Files is a list that contain relative paths for all the files for the\n  provided directory.\n\n* ##### `directories`\n  Directories is a list that contain relative paths for all the subdirectories\n  for the provided directory.\n\n* ##### `hash`\n  Hash is a dictionary with key as file names and values as `SHA-256` checksums\n  for the respective files.\n\nHere is a Sample Directory Information:\n```json\n{\n    "files": [\n        "my_file_1.txt",\n        "folder1/myfile2.txt",\n        "folder2/another_folder/myfile3.txt"\n    ],\n    "directories": [\n        "folder1",\n        "folder2",\n        "folder2/another_folder",\n        "empty_folder"\n    ],\n    "hash": {\n        "my_file_1.txt": "blablablablbalbalblblablblblblblblbl some sha hash blahblabla",\n        "folder1/myfile2.txt": "blablablablablablablablablabla hash is in a hexdigest format",\n        "folder2/another_folder/myfile3.txt": "blablablablbalbalblablg7ty913griubkeda"\n    }\n}\n```\n\n#### Patch\n\nPatch is a dictionary that tells what changes have been made in comparision\nto two different Directory Informations. It consists of the following feilds:\n\n* ##### `files_added`\n  List of Files added in comparision to the old directory information\n\n* ##### `files_removed`\n  List of Files removed in comparision to the old directory information\n\n* ##### `files_modified`\n  List of Files modified in comparision to the old directory information\n\n* ##### `directories_added`\n  List of directories added including empty directories\n\n* ##### `directories_removed`\n  List of directories removed including all their content within them\n\nHere is an example patch:\n\n```json\n{\n    "files_added": ["new_file.txt"],\n    "files_removed": ["i_hate_python.txt"],\n    "files_modified": ["why_i_like_python.txt"],\n    "directories_added": ["Temp"],\n    "directories_removed": [".Temp"],\n    "hash": {\n        "new_file.txt": "blablablablbalbalbalbblablbablablbalbblabla",\n        "why_i_like_python.txt": "blablablablablablablablablalbalgialbdblablbla"\n    }\n}\n```\n\n#### Update Files\n\nUpdate files are simple uncompressed zip archives that are made using\npatch. Here is a typical workflow of a server and a client requesting\nupdates:\n\n* Clients gives their version number to the server.\n* Server checks the version number and loads up stored directory information for that version.\n* Server creates a patch using the latest directory information and that specific version directory\n  information.\n* Server creates an uncompressed update file and starts streaming it to the client **OR** alternatively\n  server sends the patch in json format and client starts querying the server for different files listed\n  in the patch and applies the patch to required positions.\n* If the client recieved the update file instead of patch information then the client applies the update\n  file to the required positions.\n\nAlternatively to above if their is no version specifications then the workflow might\nlook like this:\n\n* Client generates directory information from local filesystem and sends it to the server\n* Server creates a patch using client provided directory information and latest server\n  directory information.\n* *And from this point on the process of updating is same as in above example*\n\n## Contributers\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<table>\n  <tr>\n    <td align="center"><a href="https://xcodz-dot.github.io/"><img src="https://avatars.githubusercontent.com/u/71920621?v=4?s=100" width="100px;" alt=""/><br /><sub><b>xcodz-dot</b></sub></a><br /><a href="https://github.com/xcodz-dot/patchutils/commits?author=xcodz-dot" title="Code">💻</a> <a href="https://github.com/xcodz-dot/patchutils/commits?author=xcodz-dot" title="Documentation">📖</a> <a href="#infra-xcodz-dot" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/xcodz-dot/patchutils/commits?author=xcodz-dot" title="Tests">⚠️</a> <a href="#maintenance-xcodz-dot" title="Maintenance">🚧</a></td>\n  </tr>\n</table>\n\n<!-- markdownlint-restore -->\n<!-- prettier-ignore-end -->\n\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n',
    'author': 'xcodz-dot',
    'author_email': '71920621+xcodz-dot@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/xcodz-dot/patchutils',
    'package_dir': package_dir,
    'py_modules': modules,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
