# generated by datamodel-codegen:
#   filename:  csm_api-swagger.json

from __future__ import annotations

from typing import Any

from pydantic import Field

from cherwell_pydantic_api.generated_api_utils import ApiBaseModel


class CherwellModel(ApiBaseModel):
    __root__: Any = Field(
        ...,
        basePath='/CherwellAPI',
        definitions={
            'Trebuchet.WebApi.DataContracts.BusinessObject.SaveResponse': {
                'type': 'object',
                'properties': {
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'cacheKey': {'type': 'string'},
                    'fieldValidationErrors': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldValidationError'
                        },
                    },
                    'notificationTriggers': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.NotificationTrigger'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.FieldValidationError': {
                'type': 'object',
                'properties': {
                    'error': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'fieldId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.NotificationTrigger': {
                'type': 'object',
                'properties': {
                    'sourceType': {'type': 'string'},
                    'sourceId': {'type': 'string'},
                    'sourceChange': {'type': 'string'},
                    'key': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Approval.ApprovalReadResponse': {
                'type': 'object',
                'properties': {
                    'properties': {
                        'type': 'object',
                        'additionalProperties': {'$ref': '#/definitions/Object'},
                    },
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Object': {'type': 'object', 'properties': {}},
            'Trebuchet.WebApi.DataContracts.Core.Link': {
                'type': 'object',
                'properties': {'name': {'type': 'string'}, 'url': {'type': 'string'}},
            },
            'Trebuchet.WebApi.DataContracts.Approval.GetApprovalsResponse': {
                'type': 'object',
                'properties': {
                    'totalRecords': {'format': 'int32', 'type': 'integer'},
                    'approvals': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Approval.ApprovalReadResponse'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.BatchDeleteRequest': {
                'type': 'object',
                'properties': {
                    'deleteRequests': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.DeleteRequest'
                        },
                    },
                    'stopOnError': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.DeleteRequest': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.BatchDeleteResponse': {
                'type': 'object',
                'properties': {
                    'responses': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.DeleteResponse'
                        },
                    }
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.DeleteResponse': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.RelatedBusinessObjectResponse': {
                'type': 'object',
                'properties': {
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'pageNumber': {'format': 'int32', 'type': 'integer'},
                    'pageSize': {'format': 'int32', 'type': 'integer'},
                    'parentBusObId': {'type': 'string'},
                    'parentBusObPublicId': {'type': 'string'},
                    'parentBusObRecId': {'type': 'string'},
                    'relatedBusinessObjects': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.ReadResponse'
                        },
                    },
                    'relationshipId': {'type': 'string'},
                    'totalRecords': {'format': 'int32', 'type': 'integer'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.ReadResponse': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'fields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem': {
                'type': 'object',
                'properties': {
                    'dirty': {'type': 'boolean'},
                    'displayName': {'type': 'string'},
                    'fieldId': {'type': 'string'},
                    'fullFieldId': {'type': 'string'},
                    'html': {'type': 'string'},
                    'name': {'type': 'string'},
                    'value': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.FieldValuesLookupRequest': {
                'type': 'object',
                'properties': {
                    'busbPublicId': {'type': 'string'},
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'fieldId': {'type': 'string'},
                    'fieldName': {'type': 'string'},
                    'fields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.FieldValuesLookupResponse': {
                'type': 'object',
                'properties': {
                    'values': {'type': 'array', 'items': {'type': 'string'}},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.BusObActivity': {
                'type': 'object',
                'properties': {
                    'id': {'type': 'string'},
                    'parentBusObDefId': {'type': 'string'},
                    'parentBusObRecId': {'type': 'string'},
                    'historyBusObDefId': {'type': 'string'},
                    'historyBusObRecId': {'type': 'string'},
                    'type': {'type': 'string'},
                    'title': {'type': 'string'},
                    'body': {'type': 'string'},
                    'createdBy': {'type': 'string'},
                    'created': {'format': 'date-time', 'type': 'string'},
                    'modified': {'format': 'date-time', 'type': 'string'},
                    'modifiedBy': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsResponse': {
                'type': 'object',
                'properties': {
                    'attachments': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.Attachment'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.Attachment': {
                'type': 'object',
                'properties': {
                    'attachedBusObId': {'type': 'string'},
                    'attachedBusObRecId': {'type': 'string'},
                    'attachmentFileId': {'type': 'string'},
                    'attachmentFileName': {'type': 'string'},
                    'attachmentFileType': {'type': 'string'},
                    'attachmentId': {'type': 'string'},
                    'attachmentType': {
                        'enum': ['Imported', 'Linked', 'URL'],
                        'type': 'string',
                    },
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'comment': {'type': 'string'},
                    'created': {'format': 'date-time', 'type': 'string'},
                    'displayText': {'type': 'string'},
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'owner': {'type': 'string'},
                    'scope': {
                        'enum': [
                            'None',
                            'Global',
                            'Team',
                            'Persona',
                            'SecurityGroup',
                            'User',
                            'UserInPersona',
                            'OtherUsers',
                            'Core',
                            'BusIntel',
                            'FromResource',
                            'Site',
                            'Custom',
                            'BusObRecord',
                        ],
                        'type': 'string',
                    },
                    'scopeOwner': {'type': 'string'},
                    'type': {
                        'enum': [
                            'None',
                            'File',
                            'FileManagerFile',
                            'BusOb',
                            'History',
                            'Other',
                            'Solution',
                            'UsedAsSolution',
                            'ExternalSolution',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsRequest': {
                'type': 'object',
                'properties': {
                    'attachmentId': {'type': 'string'},
                    'attachmentTypes': {
                        'type': 'array',
                        'items': {
                            'enum': ['Imported', 'Linked', 'URL'],
                            'type': 'string',
                        },
                    },
                    'busObId': {'type': 'string'},
                    'busObName': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'includeLinks': {'type': 'boolean'},
                    'types': {
                        'type': 'array',
                        'items': {
                            'enum': [
                                'None',
                                'File',
                                'FileManagerFile',
                                'BusOb',
                                'History',
                                'Other',
                                'Solution',
                                'UsedAsSolution',
                                'ExternalSolution',
                            ],
                            'type': 'string',
                        },
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.BatchReadRequest': {
                'type': 'object',
                'properties': {
                    'readRequests': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.ReadRequest'
                        },
                    },
                    'stopOnError': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.ReadRequest': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.BatchReadResponse': {
                'type': 'object',
                'properties': {
                    'responses': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.ReadResponse'
                        },
                    }
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.BarcodeLookupResponse': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.SchemaResponse': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'fieldDefinitions': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldDefinition'
                        },
                    },
                    'firstRecIdField': {'type': 'string'},
                    'gridDefinitions': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.GridDefinition'
                        },
                    },
                    'name': {'type': 'string'},
                    'recIdFields': {'type': 'string'},
                    'relationships': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.Relationship'
                        },
                    },
                    'stateFieldId': {'type': 'string'},
                    'states': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.FieldDefinition': {
                'type': 'object',
                'properties': {
                    'autoFill': {'type': 'boolean'},
                    'calculated': {'type': 'boolean'},
                    'category': {'type': 'string'},
                    'decimalDigits': {'format': 'int32', 'type': 'integer'},
                    'description': {'type': 'string'},
                    'details': {'type': 'string'},
                    'displayName': {'type': 'string'},
                    'enabled': {'type': 'boolean'},
                    'fieldId': {'type': 'string'},
                    'hasDate': {'type': 'boolean'},
                    'hasTime': {'type': 'boolean'},
                    'isFullTextSearchable': {'type': 'boolean'},
                    'maximumSize': {'type': 'string'},
                    'name': {'type': 'string'},
                    'readOnly': {'type': 'boolean'},
                    'required': {'type': 'boolean'},
                    'type': {'type': 'string'},
                    'typeLocalized': {'type': 'string'},
                    'validated': {'type': 'boolean'},
                    'wholeDigits': {'format': 'int32', 'type': 'integer'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.GridDefinition': {
                'type': 'object',
                'properties': {
                    'gridId': {'type': 'string'},
                    'name': {'type': 'string'},
                    'displayName': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.Relationship': {
                'type': 'object',
                'properties': {
                    'cardinality': {'type': 'string'},
                    'description': {'type': 'string'},
                    'displayName': {'type': 'string'},
                    'fieldDefinitions': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldDefinition'
                        },
                    },
                    'relationshipId': {'type': 'string'},
                    'target': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.Summary': {
                'type': 'object',
                'properties': {
                    'firstRecIdField': {'type': 'string'},
                    'groupSummaries': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.Summary'
                        },
                    },
                    'recIdFields': {'type': 'string'},
                    'stateFieldId': {'type': 'string'},
                    'states': {'type': 'string'},
                    'busObId': {'type': 'string'},
                    'displayName': {'type': 'string'},
                    'group': {'type': 'boolean'},
                    'lookup': {'type': 'boolean'},
                    'major': {'type': 'boolean'},
                    'name': {'type': 'string'},
                    'supporting': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.TemplateRequest': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'fieldNames': {'type': 'array', 'items': {'type': 'string'}},
                    'fieldIds': {'type': 'array', 'items': {'type': 'string'}},
                    'includeAll': {'type': 'boolean'},
                    'includeRequired': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.TemplateResponse': {
                'type': 'object',
                'properties': {
                    'fields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.BusObsForViewResponse': {
                'type': 'object',
                'properties': {
                    'summaries': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.ViewSummary'
                        },
                    }
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.ViewSummary': {
                'type': 'object',
                'properties': {
                    'groupSummaries': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.ViewSummary'
                        },
                    },
                    'image': {'type': 'string'},
                    'isPartOfView': {'type': 'boolean'},
                    'busObId': {'type': 'string'},
                    'displayName': {'type': 'string'},
                    'group': {'type': 'boolean'},
                    'lookup': {'type': 'boolean'},
                    'major': {'type': 'boolean'},
                    'name': {'type': 'string'},
                    'supporting': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.RelatedBusinessObjectRequest': {
                'type': 'object',
                'properties': {
                    'allFields': {'type': 'boolean'},
                    'customGridId': {'type': 'string'},
                    'fieldsList': {'type': 'array', 'items': {'type': 'string'}},
                    'filters': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.FilterInfo'
                        },
                    },
                    'pageNumber': {'format': 'int32', 'type': 'integer'},
                    'pageSize': {'format': 'int32', 'type': 'integer'},
                    'parentBusObId': {'type': 'string'},
                    'parentBusObRecId': {'type': 'string'},
                    'relationshipId': {'type': 'string'},
                    'sorting': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SortInfo'
                        },
                    },
                    'useDefaultGrid': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.FilterInfo': {
                'type': 'object',
                'properties': {
                    'fieldId': {'type': 'string'},
                    'operator': {'type': 'string'},
                    'value': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SortInfo': {
                'type': 'object',
                'properties': {
                    'fieldId': {'type': 'string'},
                    'sortDirection': {'format': 'int32', 'type': 'integer'},
                },
            },
            'Trebuchet.WebApi.DataContracts.ResponseBase': {
                'type': 'object',
                'properties': {
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.SaveBusObAttachmentRequest': {
                'type': 'object',
                'properties': {
                    'attachBusObId': {'type': 'string'},
                    'attachBusObName': {'type': 'string'},
                    'attachBusObPublicId': {'type': 'string'},
                    'attachBusObRecId': {'type': 'string'},
                    'busObId': {'type': 'string'},
                    'busObName': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'comment': {'type': 'string'},
                    'includeLinks': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.SaveLinkAttachmentRequest': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObName': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'comment': {'type': 'string'},
                    'displayText': {'type': 'string'},
                    'includeLinks': {'type': 'boolean'},
                    'uncFilePath': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.SaveUrlAttachmentRequest': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObName': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'comment': {'type': 'string'},
                    'displayText': {'type': 'string'},
                    'includeLinks': {'type': 'boolean'},
                    'url': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.BatchSaveRequest': {
                'type': 'object',
                'properties': {
                    'saveRequests': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.SaveRequest'
                        },
                    },
                    'stopOnError': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.SaveRequest': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'cacheKey': {'type': 'string'},
                    'cacheScope': {
                        'enum': ['Tenant', 'User', 'Session'],
                        'type': 'string',
                    },
                    'fields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                    'persist': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.BatchSaveResponse': {
                'type': 'object',
                'properties': {
                    'responses': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.SaveResponse'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.RelatedSaveRequest': {
                'type': 'object',
                'properties': {
                    'parentBusObId': {'type': 'string'},
                    'parentBusObPublicId': {'type': 'string'},
                    'parentBusObRecId': {'type': 'string'},
                    'relationshipId': {'type': 'string'},
                    'busObId': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'cacheKey': {'type': 'string'},
                    'cacheScope': {
                        'enum': ['Tenant', 'User', 'Session'],
                        'type': 'string',
                    },
                    'fields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                    'persist': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.BusinessObject.RelatedSaveResponse': {
                'type': 'object',
                'properties': {
                    'parentBusObId': {'type': 'string'},
                    'parentBusObPublicId': {'type': 'string'},
                    'parentBusObRecId': {'type': 'string'},
                    'relationshipId': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'cacheKey': {'type': 'string'},
                    'fieldValidationErrors': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldValidationError'
                        },
                    },
                    'notificationTriggers': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.NotificationTrigger'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.ManagerData': {
                'type': 'object',
                'properties': {
                    'root': {
                        '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerFolder'
                    },
                    'supportedAssociations': {
                        'type': 'array',
                        'items': {'$ref': '#/definitions/Trebuchet.NameValuePair'},
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.ManagerFolder': {
                'type': 'object',
                'properties': {
                    'association': {'type': 'string'},
                    'childFolders': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerFolder'
                        },
                    },
                    'childItems': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerItem'
                        },
                    },
                    'id': {'type': 'string'},
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'localizedScopeName': {'type': 'string'},
                    'name': {'type': 'string'},
                    'parentId': {'type': 'string'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                },
            },
            'Trebuchet.NameValuePair': {
                'type': 'object',
                'properties': {
                    'name': {'type': 'string'},
                    'valueObject': {'$ref': '#/definitions/Object'},
                    'valueString': {'type': 'string'},
                    'category': {'type': 'string'},
                    'description': {'type': 'string'},
                    'displayShowsValue': {'type': 'boolean'},
                    'specialUseFlag': {'type': 'boolean'},
                    'displayString': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.ManagerItem': {
                'type': 'object',
                'properties': {
                    'association': {'type': 'string'},
                    'description': {'type': 'string'},
                    'displayName': {'type': 'string'},
                    'galleryImage': {'type': 'string'},
                    'id': {'type': 'string'},
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'localizedScopeName': {'type': 'string'},
                    'name': {'type': 'string'},
                    'parentFolder': {'type': 'string'},
                    'parentIsScopeFolder': {'type': 'boolean'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                    'standInKey': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.StoredValueResponse': {
                'type': 'object',
                'properties': {
                    'description': {'type': 'string'},
                    'folder': {'type': 'string'},
                    'id': {'type': 'string'},
                    'name': {'type': 'string'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                    'standInKey': {'type': 'string'},
                    'storedValueType': {
                        'enum': [
                            'Text',
                            'Number',
                            'DateTime',
                            'Logical',
                            'Color',
                            'Json',
                            'JsonArray',
                            'Xml',
                            'XmlCollection',
                        ],
                        'type': 'string',
                    },
                    'value': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.ViewsResponse': {
                'type': 'object',
                'properties': {
                    'views': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.View'
                        },
                    }
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.View': {
                'type': 'object',
                'properties': {
                    'name': {'type': 'string'},
                    'viewId': {'type': 'string'},
                    'image': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.LogBatchRequest': {
                'type': 'object',
                'properties': {
                    'logRequests': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.LogRequest'
                        },
                    }
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.LogRequest': {
                'type': 'object',
                'properties': {
                    'keyValueProperties': {
                        'type': 'array',
                        'items': {'$ref': '#/definitions/Object'},
                    },
                    'level': {
                        'enum': ['Fatal', 'Error', 'Warning', 'Info', 'Stats', 'Debug'],
                        'type': 'string',
                    },
                    'message': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.SaveGalleryImageRequest': {
                'type': 'object',
                'properties': {
                    'base64EncodedImageData': {'type': 'string'},
                    'description': {'type': 'string'},
                    'folder': {'type': 'string'},
                    'imageType': {
                        'enum': ['Imported', 'File', 'Url'],
                        'type': 'string',
                    },
                    'name': {'type': 'string'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                    'standInKey': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.SaveGalleryImageResponse': {
                'type': 'object',
                'properties': {
                    'name': {'type': 'string'},
                    'standInKey': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.SaveStoredValueRequest': {
                'type': 'object',
                'properties': {
                    'description': {'type': 'string'},
                    'folder': {'type': 'string'},
                    'name': {'type': 'string'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                    'standInKey': {'type': 'string'},
                    'storedValueType': {
                        'enum': [
                            'Text',
                            'Number',
                            'DateTime',
                            'Logical',
                            'Color',
                            'Json',
                            'JsonArray',
                            'Xml',
                            'XmlCollection',
                        ],
                        'type': 'string',
                    },
                    'value': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Forms.MobileFormResponse': {
                'type': 'object',
                'properties': {
                    'actions': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Action'
                        },
                    },
                    'attachments': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.Attachment'
                        },
                    },
                    'galleryImage': {'type': 'string'},
                    'locationInformation': {
                        '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Location'
                    },
                    'sections': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Forms.Section'
                        },
                    },
                    'title': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.Action': {
                'type': 'object',
                'properties': {
                    'actionCommand': {'type': 'string'},
                    'actionType': {
                        'enum': [
                            'None',
                            'OneStep',
                            'Command',
                            'BuiltIn',
                            'Category',
                            'SearchGrp',
                            'Report',
                            'Dashboard',
                            'Calendar',
                            'Visualization',
                            'Group',
                            'Page',
                            'DocRepository',
                            'PortalCommand',
                            'ActionCatalog',
                            'OneStepForRecord',
                        ],
                        'type': 'string',
                    },
                    'alwaysTextAndImage': {'type': 'boolean'},
                    'beginGroup': {'type': 'boolean'},
                    'childActions': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Action'
                        },
                    },
                    'dependencies': {'type': 'array', 'items': {'type': 'string'}},
                    'displayText': {'type': 'string'},
                    'enabled': {'type': 'boolean'},
                    'galleryImage': {'type': 'string'},
                    'helpText': {'type': 'string'},
                    'loginEnabledMode': {
                        'enum': ['Anonymous', 'LoggedIn', 'Both'],
                        'type': 'string',
                    },
                    'loginVisibilityMode': {
                        'enum': ['Anonymous', 'LoggedIn', 'Both'],
                        'type': 'string',
                    },
                    'name': {'type': 'string'},
                    'parameters': {
                        'type': 'object',
                        'additionalProperties': {'type': 'string'},
                    },
                    'visible': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.Location': {
                'type': 'object',
                'properties': {
                    'altitude': {'format': 'double', 'type': 'number'},
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'latitude': {'format': 'double', 'type': 'number'},
                    'longitude': {'format': 'double', 'type': 'number'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Forms.Section': {
                'type': 'object',
                'properties': {
                    'sectionFields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Forms.SectionField'
                        },
                    },
                    'galleryImage': {'type': 'string'},
                    'title': {'type': 'string'},
                    'relationshipId': {'type': 'string'},
                    'targetBusObId': {'type': 'string'},
                    'targetBusObRecId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Forms.SectionField': {
                'type': 'object',
                'properties': {
                    'attributes': {
                        'type': 'array',
                        'items': {'$ref': '#/definitions/Object'},
                    },
                    'fieldId': {'type': 'string'},
                    'fieldType': {'type': 'string'},
                    'label': {'type': 'string'},
                    'multiline': {'type': 'boolean'},
                    'value': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Lifecycle.GetStagesResponse': {
                'type': 'object',
                'properties': {
                    'stages': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.GetStagesResponseStages'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Lifecycle.GetStagesResponseStages': {
                'type': 'object',
                'properties': {
                    'id': {'type': 'string'},
                    'isFinal': {'type': 'boolean'},
                    'name': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Lifecycle.GetStatusesResponse': {
                'type': 'object',
                'properties': {
                    'statuses': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.GetStatusesResponseStatuses'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Lifecycle.GetStatusesResponseStatuses': {
                'type': 'object',
                'properties': {
                    'id': {'type': 'string'},
                    'isInitial': {'type': 'boolean'},
                    'name': {'type': 'string'},
                    'stageId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Lifecycle.GetTransitionsResponse': {
                'type': 'object',
                'properties': {
                    'transitions': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.GetTransitionsResponseTransition'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Lifecycle.GetTransitionsResponseTransition': {
                'type': 'object',
                'properties': {
                    'id': {'type': 'string'},
                    'name': {'type': 'string'},
                    'fromStatusId': {'type': 'string'},
                    'toStatusId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Lifecycle.GetRecordStatusResponse': {
                'type': 'object',
                'properties': {
                    'id': {'type': 'string'},
                    'name': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Lifecycle.GetTransitionOptionsResponse': {
                'type': 'object',
                'properties': {
                    'transitions': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.GetTransitionOptionsResponseTransition'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Lifecycle.GetTransitionOptionsResponseTransition': {
                'type': 'object',
                'properties': {
                    'name': {'type': 'string'},
                    'id': {'type': 'string'},
                    'isAvailable': {'type': 'boolean'},
                    'criteria': {'type': 'array', 'items': {'type': 'string'}},
                },
            },
            'Trebuchet.WebApi.DataContracts.Lifecycle.TransitionRecordRequest': {
                'type': 'object',
                'properties': {'transitionOptionId': {'type': 'string'}},
            },
            'Trebuchet.WebApi.DataContracts.OneStepActions.OneStepActionResponse': {
                'type': 'object',
                'properties': {
                    'completed': {'type': 'boolean'},
                    'currentPrimaryBusObId': {'type': 'string'},
                    'currentPrimaryBusObRecId': {'type': 'string'},
                    'hasNewAccessToken': {'type': 'boolean'},
                    'newAccessToken': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.OneStepActions.OneStepActionRequest': {
                'type': 'object',
                'properties': {
                    'acquireLicense': {'type': 'boolean'},
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'oneStepActionStandInKey': {'type': 'string'},
                    'promptValues': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.SimplePromptValue'
                        },
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.SimplePromptValue': {
                'type': 'object',
                'properties': {
                    'promptDefId': {'type': 'string'},
                    'promptName': {'type': 'string'},
                    'value': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Queues.AddItemToQueueRequest': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'queueStandInKey': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Queues.AddItemToQueueResponse': {
                'type': 'object',
                'properties': {
                    'historyRecId': {'type': 'string'},
                    'historyText': {'type': 'string'},
                    'historyTypeId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Queues.CheckInQueueItemRequest': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'historyNotes': {'type': 'string'},
                    'queueStandInKey': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Queues.CheckInQueueItemResponse': {
                'type': 'object',
                'properties': {
                    'historyRecId': {'type': 'string'},
                    'historyText': {'type': 'string'},
                    'historyTypeId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Queues.CheckOutQueueItemRequest': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'historyNotes': {'type': 'string'},
                    'queueStandInKey': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Queues.CheckOutQueueItemResponse': {
                'type': 'object',
                'properties': {
                    'historyRecId': {'type': 'string'},
                    'historyText': {'type': 'string'},
                    'historyTypeId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Queues.RemoveItemFromQueueRequest': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'historyNotes': {'type': 'string'},
                    'queueStandInKey': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Queues.RemoveItemFromQueueResponse': {
                'type': 'object',
                'properties': {
                    'historyRecId': {'type': 'string'},
                    'historyText': {'type': 'string'},
                    'historyTypeId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.QuickSearchConfigSavedRequest': {
                'type': 'object',
                'properties': {
                    'standIn': {'type': 'string'},
                    'busObIds': {'type': 'array', 'items': {'type': 'string'}},
                    'isGeneral': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.QuickSearchConfigurationResponse': {
                'type': 'object',
                'properties': {
                    'allowQuickSearch': {'type': 'boolean'},
                    'allowSpecificSearch': {'type': 'boolean'},
                    'defaultToQuickSearch': {'type': 'boolean'},
                    'displayName': {'type': 'string'},
                    'galleryImage': {'type': 'string'},
                    'history': {'type': 'array', 'items': {'type': 'string'}},
                    'includeAvailableInSpecific': {'type': 'boolean'},
                    'includeQuickSearchInSpecific': {'type': 'boolean'},
                    'quickSearchId': {'type': 'string'},
                    'quickSearchItems': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.QuickSearchItem'
                        },
                    },
                    'quickSearchWatermark': {'type': 'string'},
                    'sortByRelevance': {'type': 'boolean'},
                    'resolvedQuickSearchWatermark': {'type': 'string'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                    'specificSearchItems': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.QuickSearchItem'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.QuickSearchItem': {
                'type': 'object',
                'properties': {
                    'ascending': {'type': 'boolean'},
                    'changedLimits': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.ChangedLimit'
                        },
                    },
                    'changedOption': {
                        'enum': ['None', 'Use', 'Display', 'UseAndDisplay'],
                        'type': 'string',
                    },
                    'displayName': {'type': 'string'},
                    'galleryImage': {'type': 'string'},
                    'hasAnyOptions': {'type': 'boolean'},
                    'nonFinalStateOption': {
                        'enum': ['None', 'Use', 'Display', 'UseAndDisplay'],
                        'type': 'string',
                    },
                    'searchAnyWordsOption': {
                        'enum': ['None', 'Use', 'Display', 'UseAndDisplay'],
                        'type': 'string',
                    },
                    'searchAttachmentsOption': {
                        'enum': ['None', 'Use', 'Display', 'UseAndDisplay'],
                        'type': 'string',
                    },
                    'searchRelatedOption': {
                        'enum': ['None', 'Use', 'Display', 'UseAndDisplay'],
                        'type': 'string',
                    },
                    'searchTargetId': {'type': 'string'},
                    'searchTargetType': {
                        'enum': ['BusOb', 'DocRepository'],
                        'type': 'string',
                    },
                    'selectedChangedLimit': {
                        '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.ChangedLimit'
                    },
                    'selectedSortByFieldId': {'type': 'string'},
                    'sortByFields': {
                        'type': 'object',
                        'additionalProperties': {'type': 'string'},
                    },
                    'sortByOption': {
                        'enum': ['None', 'Use', 'Display', 'UseAndDisplay'],
                        'type': 'string',
                    },
                    'watermarkText': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.ChangedLimit': {
                'type': 'object',
                'properties': {
                    'displayName': {'type': 'string'},
                    'units': {'type': 'string'},
                    'value': {'format': 'int32', 'type': 'integer'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.QuickSearchConfigurationRequest': {
                'type': 'object',
                'properties': {
                    'busObIds': {'type': 'array', 'items': {'type': 'string'}}
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.QuickSearchByIdRequest': {
                'type': 'object',
                'properties': {
                    'busObIds': {'type': 'array', 'items': {'type': 'string'}},
                    'isGeneral': {'type': 'boolean'},
                    'searchText': {'type': 'string'},
                    'standIn': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SimpleResultsList': {
                'type': 'object',
                'properties': {
                    'groups': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SimpleResultsListGroup'
                        },
                    },
                    'title': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SimpleResultsListGroup': {
                'type': 'object',
                'properties': {
                    'isBusObTarget': {'type': 'boolean'},
                    'simpleResultsListItems': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SimpleResultsListItem'
                        },
                    },
                    'subTitle': {'type': 'string'},
                    'targetId': {'type': 'string'},
                    'title': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SimpleResultsListItem': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'docRepositoryItemId': {'type': 'string'},
                    'galleryImage': {'type': 'string'},
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'publicId': {'type': 'string'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                    'subTitle': {'type': 'string'},
                    'text': {'type': 'string'},
                    'title': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.QuickSearchRequest': {
                'type': 'object',
                'properties': {
                    'busObIds': {'type': 'array', 'items': {'type': 'string'}},
                    'searchText': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.QuickSearchSpecificByIdRequest': {
                'type': 'object',
                'properties': {
                    'busObIds': {'type': 'array', 'items': {'type': 'string'}},
                    'standIn': {'type': 'string'},
                    'ascending': {'type': 'boolean'},
                    'isBusObTarget': {'type': 'boolean'},
                    'nonFinalState': {'type': 'boolean'},
                    'searchAnyWords': {'type': 'boolean'},
                    'searchAttachments': {'type': 'boolean'},
                    'searchRelated': {'type': 'boolean'},
                    'searchText': {'type': 'string'},
                    'selectedChangedLimit': {
                        '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.ChangedLimit'
                    },
                    'selectedSortByFieldId': {'type': 'string'},
                    'sortByRelevance': {'type': 'boolean'},
                    'specificSearchTargetId': {'type': 'string'},
                    'useSortBy': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SearchResultsTableResponse': {
                'type': 'object',
                'properties': {
                    'columns': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.Field'
                        },
                    },
                    'rows': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchResultsRow'
                        },
                    },
                    'sorting': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SortInfo'
                        },
                    },
                    'totalRows': {'format': 'int64', 'type': 'integer'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.Field': {
                'type': 'object',
                'properties': {
                    'caption': {'type': 'string'},
                    'currencyCulture': {'type': 'string'},
                    'currencySymbol': {'type': 'string'},
                    'decimalDigits': {'format': 'int32', 'type': 'integer'},
                    'defaultSortOrderAscending': {'type': 'boolean'},
                    'displayName': {'type': 'string'},
                    'fieldName': {'type': 'string'},
                    'fullFieldId': {'type': 'string'},
                    'hasDefaultSortField': {'type': 'boolean'},
                    'fieldId': {'type': 'string'},
                    'isBinary': {'type': 'boolean'},
                    'isCurrency': {'type': 'boolean'},
                    'isDateTime': {'type': 'boolean'},
                    'isFilterAllowed': {'type': 'boolean'},
                    'isLogical': {'type': 'boolean'},
                    'isNumber': {'type': 'boolean'},
                    'isShortDate': {'type': 'boolean'},
                    'isShortTime': {'type': 'boolean'},
                    'isVisible': {'type': 'boolean'},
                    'sortable': {'type': 'boolean'},
                    'sortOrder': {'type': 'string'},
                    'storageName': {'type': 'string'},
                    'wholeDigits': {'format': 'int32', 'type': 'integer'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SearchResultsRow': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'publicId': {'type': 'string'},
                    'rowColor': {'type': 'string'},
                    'searchResultsFieldValues': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.QuickSearchResponse': {
                'type': 'object',
                'properties': {
                    'searchResultsTable': {
                        '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchResultsTableResponse'
                    },
                    'simpleResultsList': {
                        '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SimpleResultsList'
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.QuickSearchSpecificRequest': {
                'type': 'object',
                'properties': {
                    'ascending': {'type': 'boolean'},
                    'isBusObTarget': {'type': 'boolean'},
                    'nonFinalState': {'type': 'boolean'},
                    'searchAnyWords': {'type': 'boolean'},
                    'searchAttachments': {'type': 'boolean'},
                    'searchRelated': {'type': 'boolean'},
                    'searchText': {'type': 'string'},
                    'selectedChangedLimit': {
                        '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.ChangedLimit'
                    },
                    'selectedSortByFieldId': {'type': 'string'},
                    'sortByRelevance': {'type': 'boolean'},
                    'specificSearchTargetId': {'type': 'string'},
                    'useSortBy': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SearchItemResponse': {
                'type': 'object',
                'properties': {
                    'root': {
                        '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchFolder'
                    },
                    'supportedAssociations': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.Association'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SearchFolder': {
                'type': 'object',
                'properties': {
                    'association': {'type': 'string'},
                    'childFolders': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchFolder'
                        },
                    },
                    'childItems': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchItem'
                        },
                    },
                    'folderId': {'type': 'string'},
                    'folderName': {'type': 'string'},
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'localizedScopeName': {'type': 'string'},
                    'parentFolderId': {'type': 'string'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.Association': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObName': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SearchItem': {
                'type': 'object',
                'properties': {
                    'association': {'type': 'string'},
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'localizedScopeName': {'type': 'string'},
                    'parentFolderId': {'type': 'string'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                    'searchId': {'type': 'string'},
                    'searchName': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SearchResultsRequest': {
                'type': 'object',
                'properties': {
                    'association': {'type': 'string'},
                    'associationName': {'type': 'string'},
                    'busObId': {'type': 'string'},
                    'customGridDefId': {'type': 'string'},
                    'dateTimeFormatting': {'type': 'string'},
                    'fieldId': {'type': 'string'},
                    'fields': {'type': 'array', 'items': {'type': 'string'}},
                    'filters': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.FilterInfo'
                        },
                    },
                    'includeAllFields': {'type': 'boolean'},
                    'includeSchema': {'type': 'boolean'},
                    'pageNumber': {'format': 'int32', 'type': 'integer'},
                    'pageSize': {'format': 'int32', 'type': 'integer'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                    'searchId': {'type': 'string'},
                    'searchName': {'type': 'string'},
                    'searchText': {'type': 'string'},
                    'sorting': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SortInfo'
                        },
                    },
                    'promptValues': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.PromptValue'
                        },
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.PromptValue': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'collectionStoreEntireRow': {'type': 'string'},
                    'collectionValueField': {'type': 'string'},
                    'fieldId': {'type': 'string'},
                    'listReturnFieldId': {'type': 'string'},
                    'promptId': {'type': 'string'},
                    'value': {'$ref': '#/definitions/Object'},
                    'valueIsRecId': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.SearchResultsResponse': {
                'type': 'object',
                'properties': {
                    'businessObjects': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.ReadResponse'
                        },
                    },
                    'hasPrompts': {'type': 'boolean'},
                    'links': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Link'
                        },
                    },
                    'prompts': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.Prompt'
                        },
                    },
                    'searchResultsFields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.Field'
                        },
                    },
                    'simpleResults': {
                        '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SimpleResultsList'
                    },
                    'totalRows': {'format': 'int64', 'type': 'integer'},
                    'hasMoreRecords': {'type': 'boolean'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.Prompt': {
                'type': 'object',
                'properties': {
                    'allowValuesOnly': {'type': 'boolean'},
                    'busObId': {'type': 'string'},
                    'collectionStoreEntireRow': {'type': 'string'},
                    'collectionValueField': {'type': 'string'},
                    'constraintXml': {'type': 'string'},
                    'contents': {'type': 'string'},
                    'default': {'type': 'string'},
                    'fieldId': {'type': 'string'},
                    'isDateRange': {'type': 'boolean'},
                    'listDisplayOption': {
                        'enum': [
                            'Auto',
                            'Text',
                            'Combo',
                            'GridList',
                            'SimpleList',
                            'PromptSimpleGrid',
                        ],
                        'type': 'string',
                    },
                    'listReturnFieldId': {'type': 'string'},
                    'multiLine': {'type': 'boolean'},
                    'promptId': {'type': 'string'},
                    'promptType': {
                        'enum': [
                            'None',
                            'Text',
                            'Number',
                            'DateTime',
                            'Logical',
                            'Binary',
                            'DateOnly',
                            'TimeOnly',
                            'Json',
                            'JsonArray',
                            'Xml',
                            'XmlCollection',
                            'TimeValue',
                        ],
                        'type': 'string',
                    },
                    'promptTypeName': {'type': 'string'},
                    'required': {'type': 'boolean'},
                    'text': {'type': 'string'},
                    'value': {'$ref': '#/definitions/Object'},
                    'values': {'type': 'array', 'items': {'type': 'string'}},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.ExportSearchResultsRequest': {
                'type': 'object',
                'properties': {
                    'customSeparator': {'type': 'string'},
                    'exportFormat': {
                        'enum': [
                            'CSV',
                            'Excel',
                            'Tab',
                            'Word',
                            'CustomSeparator',
                            'Json',
                        ],
                        'type': 'string',
                    },
                    'exportTitle': {'type': 'string'},
                    'association': {'type': 'string'},
                    'associationName': {'type': 'string'},
                    'busObId': {'type': 'string'},
                    'customGridDefId': {'type': 'string'},
                    'dateTimeFormatting': {'type': 'string'},
                    'fieldId': {'type': 'string'},
                    'fields': {'type': 'array', 'items': {'type': 'string'}},
                    'filters': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.FilterInfo'
                        },
                    },
                    'includeAllFields': {'type': 'boolean'},
                    'includeSchema': {'type': 'boolean'},
                    'pageNumber': {'format': 'int32', 'type': 'integer'},
                    'pageSize': {'format': 'int32', 'type': 'integer'},
                    'scope': {'type': 'string'},
                    'scopeOwner': {'type': 'string'},
                    'searchId': {'type': 'string'},
                    'searchName': {'type': 'string'},
                    'searchText': {'type': 'string'},
                    'sorting': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SortInfo'
                        },
                    },
                    'promptValues': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.PromptValue'
                        },
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.StoredSearchRequest': {
                'type': 'object',
                'properties': {
                    'associationId': {'type': 'string'},
                    'associationName': {'type': 'string'},
                    'gridId': {'type': 'string'},
                    'includeSchema': {'type': 'boolean'},
                    'scope': {'type': 'string'},
                    'scopeOwnerId': {'type': 'string'},
                    'searchId': {'type': 'string'},
                    'searchName': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.StoredSearchResults': {
                'type': 'object',
                'properties': {
                    'columns': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.ColumnSchema'
                        },
                    },
                    'rows': {
                        'type': 'array',
                        'items': {
                            'type': 'array',
                            'items': {'$ref': '#/definitions/Object'},
                        },
                        'readOnly': True,
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Searches.ColumnSchema': {
                'type': 'object',
                'properties': {
                    'name': {'type': 'string'},
                    'fieldId': {'type': 'string'},
                    'type': {
                        'enum': [
                            'Text',
                            'Number',
                            'Currency',
                            'Integer',
                            'Datetime',
                            'Date',
                            'Time',
                            'Logical',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.DeleteApiClientSettingsResponse': {
                'type': 'object',
                'properties': {
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.GetApiClientSettingsResponse': {
                'type': 'object',
                'properties': {
                    'settings': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.GetApiClientSettingsResponseItem'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.GetApiClientSettingsResponseItem': {
                'type': 'object',
                'properties': {
                    'name': {'type': 'string'},
                    'standInKey': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.ApiClientSettingResponse': {
                'type': 'object',
                'properties': {
                    'name': {'type': 'string'},
                    'description': {'type': 'string'},
                    'culture': {'type': 'string'},
                    'clientKey': {'type': 'string'},
                    'tokenLifespanMinutes': {'format': 'int32', 'type': 'integer'},
                    'refreshTokenLifespanMinutes': {
                        'format': 'int32',
                        'type': 'integer',
                    },
                    'apiAccessIsEnabled': {'type': 'boolean'},
                    'allowAnonymousAccess': {'type': 'boolean'},
                    'standInKey': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.ClientSecuritySettingsResponse': {
                'type': 'object',
                'properties': {
                    'internalLoginAllowed': {'type': 'boolean'},
                    'ldapLoginAllowed': {'type': 'boolean'},
                    'samlLoginAllowed': {'type': 'boolean'},
                    'windowsLoginAllowed': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.MobileCredentialsModeResponse': {
                'type': 'object',
                'properties': {
                    'credentialsMode': {'format': 'int32', 'type': 'integer'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.RoleReadResponse': {
                'type': 'object',
                'properties': {
                    'error': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'roles': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.Role'
                        },
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.Role': {
                'type': 'object',
                'properties': {
                    'browserClientCustomViewId': {'type': 'string'},
                    'businessObjectExcludeList': {
                        'type': 'array',
                        'items': {'type': 'string'},
                    },
                    'culture': {'type': 'string'},
                    'description': {'type': 'string'},
                    'mobileClientCustomViewId': {'type': 'string'},
                    'primaryBusObId': {'type': 'string'},
                    'roleId': {'type': 'string'},
                    'roleName': {'type': 'string'},
                    'smartClientCustomViewId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.RoleReadV2Response': {
                'type': 'object',
                'properties': {
                    'roles': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.Role'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.BusinessObjectPermission': {
                'type': 'object',
                'properties': {
                    'busObId': {'type': 'string'},
                    'busObName': {'type': 'string'},
                    'departmentMemberEdit': {'type': 'boolean'},
                    'departmentMemberView': {'type': 'boolean'},
                    'edit': {'type': 'boolean'},
                    'fieldPermissions': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.FieldPermission'
                        },
                    },
                    'managerOfOwnerEdit': {'type': 'boolean'},
                    'managerOfOwnerView': {'type': 'boolean'},
                    'ownerEdit': {'type': 'boolean'},
                    'ownerView': {'type': 'boolean'},
                    'teamEdit': {'type': 'boolean'},
                    'teamManagerOfOwnerEdit': {'type': 'boolean'},
                    'teamManagerOfOwnerView': {'type': 'boolean'},
                    'teamView': {'type': 'boolean'},
                    'view': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.FieldPermission': {
                'type': 'object',
                'properties': {
                    'departmentMemberEdit': {'type': 'boolean'},
                    'departmentMemberView': {'type': 'boolean'},
                    'edit': {'type': 'boolean'},
                    'fieldId': {'type': 'string'},
                    'fieldName': {'type': 'string'},
                    'managerOfOwnerEdit': {'type': 'boolean'},
                    'managerOfOwnerView': {'type': 'boolean'},
                    'ownerEdit': {'type': 'boolean'},
                    'ownerView': {'type': 'boolean'},
                    'teamEdit': {'type': 'boolean'},
                    'teamManagerOfOwnerEdit': {'type': 'boolean'},
                    'teamManagerOfOwnerView': {'type': 'boolean'},
                    'teamView': {'type': 'boolean'},
                    'view': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.GetSecurityGroupBusinessObjectPermissionsResponse': {
                'type': 'object',
                'properties': {
                    'businessObjectPermissions': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.BusinessObjectPermission'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.RightCategory': {
                'type': 'object',
                'properties': {
                    'categoryDescription': {'type': 'string'},
                    'categoryId': {'type': 'string'},
                    'categoryName': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.SecurityRightCategoriesResponse': {
                'type': 'object',
                'properties': {
                    'rightCategories': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.RightCategory'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.Right': {
                'type': 'object',
                'properties': {
                    'add': {'type': 'boolean'},
                    'allow': {'type': 'boolean'},
                    'categoryDescription': {'type': 'string'},
                    'categoryId': {'type': 'string'},
                    'categoryName': {'type': 'string'},
                    'delete': {'type': 'boolean'},
                    'edit': {'type': 'boolean'},
                    'isYesNoRight': {'type': 'boolean'},
                    'nonScopeOwnerAdd': {'type': 'boolean'},
                    'nonScopeOwnerDelete': {'type': 'boolean'},
                    'nonScopeOwnerEdit': {'type': 'boolean'},
                    'nonScopeOwnerView': {'type': 'boolean'},
                    'rightId': {'type': 'string'},
                    'rightName': {'type': 'string'},
                    'standardRightName': {'type': 'string'},
                    'viewRunOpen': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.SecurityRightsResponse': {
                'type': 'object',
                'properties': {
                    'rights': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.Right'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.SecurityGroupResponse': {
                'type': 'object',
                'properties': {
                    'securityGroups': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.SecurityGroup'
                        },
                    }
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.SecurityGroup': {
                'type': 'object',
                'properties': {
                    'description': {'type': 'string'},
                    'groupId': {'type': 'string'},
                    'groupName': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.SecurityGroupV2Response': {
                'type': 'object',
                'properties': {
                    'securityGroups': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.SecurityGroup'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.User': {
                'type': 'object',
                'properties': {
                    'accountLocked': {'type': 'boolean'},
                    'createDateTime': {'format': 'date-time', 'type': 'string'},
                    'displayName': {'type': 'string'},
                    'error': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'fields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                    'hasError': {'type': 'boolean'},
                    'lastPasswordResetDate': {'format': 'date-time', 'type': 'string'},
                    'lastResetDateTime': {'format': 'date-time', 'type': 'string'},
                    'ldapRequired': {'type': 'boolean'},
                    'passwordNeverExpires': {'type': 'boolean'},
                    'publicId': {'type': 'string'},
                    'recordId': {'type': 'string'},
                    'securityGroupId': {'type': 'string'},
                    'shortDisplayName': {'type': 'string'},
                    'userCannotChangePassword': {'type': 'boolean'},
                    'userMustResetPasswordAtNextLogin': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserReadV2Response': {
                'type': 'object',
                'properties': {
                    'users': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserV2'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserV2': {
                'type': 'object',
                'properties': {
                    'accountLocked': {'type': 'boolean'},
                    'createDateTime': {'format': 'date-time', 'type': 'string'},
                    'displayName': {'type': 'string'},
                    'fields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                    'lastPasswordResetDate': {'format': 'date-time', 'type': 'string'},
                    'lastResetDateTime': {'format': 'date-time', 'type': 'string'},
                    'ldapRequired': {'type': 'boolean'},
                    'passwordNeverExpires': {'type': 'boolean'},
                    'publicId': {'type': 'string'},
                    'recordId': {'type': 'string'},
                    'securityGroupId': {'type': 'string'},
                    'shortDisplayName': {'type': 'string'},
                    'userCannotChangePassword': {'type': 'boolean'},
                    'userMustResetPasswordAtNextLogin': {'type': 'boolean'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.SaveApiClientSettingRequest': {
                'type': 'object',
                'properties': {
                    'allowAnonymousAccess': {'type': 'boolean'},
                    'apiAccessIsEnabled': {'type': 'boolean'},
                    'createNewClientKey': {'type': 'boolean'},
                    'culture': {'type': 'string'},
                    'description': {'type': 'string'},
                    'name': {'type': 'string'},
                    'refreshTokenLifespanMinutes': {
                        'format': 'int32',
                        'type': 'integer',
                    },
                    'standInKey': {'type': 'string'},
                    'tokenLifespanMinutes': {'format': 'int32', 'type': 'integer'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.CloneSecurityGroupRequest': {
                'type': 'object',
                'properties': {
                    'securityGroupName': {'type': 'string'},
                    'sourceSecurityGroupNameOrId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.CloneSecurityGroupResponse': {
                'type': 'object',
                'properties': {
                    'securityGroupId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Core.ServiceInfoResponse': {
                'type': 'object',
                'properties': {
                    'apiVersion': {'type': 'string'},
                    'csmCulture': {'type': 'string'},
                    'csmVersion': {'type': 'string'},
                    'systemDateTime': {'format': 'date-time', 'type': 'string'},
                    'timeZone': {'$ref': '#/definitions/Object'},
                    'systemUtcOffset': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamByBatchRequest': {
                'type': 'object',
                'properties': {
                    'addUserToTeamRequests': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamRequest'
                        },
                    },
                    'stopOnError': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamRequest': {
                'type': 'object',
                'properties': {
                    'teamId': {'type': 'string'},
                    'userIsTeamManager': {'type': 'boolean'},
                    'userRecordId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamByBatchResponse': {
                'type': 'object',
                'properties': {
                    'responses': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamResponse'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamResponse': {
                'type': 'object',
                'properties': {
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.TeamsResponse': {
                'type': 'object',
                'properties': {
                    'error': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'teams': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.Team'
                        },
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.Team': {
                'type': 'object',
                'properties': {
                    'teamId': {'type': 'string'},
                    'teamName': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.TeamsV2Response': {
                'type': 'object',
                'properties': {
                    'teams': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.Team'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.TeamResponse': {
                'type': 'object',
                'properties': {
                    'description': {'type': 'string'},
                    'emailAlias': {'type': 'string'},
                    'fields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                    'image': {'type': 'string'},
                    'name': {'type': 'string'},
                    'teamId': {'type': 'string'},
                    'teamType': {
                        'enum': ['User', 'CustomerWorkgroup'],
                        'type': 'string',
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.RemoveUserFromTeamResponse': {
                'type': 'object',
                'properties': {
                    'teamId': {'type': 'string'},
                    'userRecordId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.RemoveCustomerFromWorkgroupResponse': {
                'type': 'object',
                'properties': {
                    'workgroupId': {'type': 'string'},
                    'customerRecordId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.TeamSaveRequest': {
                'type': 'object',
                'properties': {
                    'description': {'type': 'string'},
                    'emailAlias': {'type': 'string'},
                    'image': {'type': 'string'},
                    'teamId': {'type': 'string'},
                    'teamName': {'type': 'string'},
                    'teamType': {
                        'enum': ['User', 'CustomerWorkgroup'],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.TeamSaveResponse': {
                'type': 'object',
                'properties': {
                    'teamId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.SaveTeamMemberRequest': {
                'type': 'object',
                'properties': {
                    'isTeamManager': {'type': 'boolean'},
                    'setAsDefaultTeam': {'type': 'boolean'},
                    'teamId': {'type': 'string'},
                    'userRecId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.SaveTeamMemberResponse': {
                'type': 'object',
                'properties': {
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.SaveWorkgroupMemberRequest': {
                'type': 'object',
                'properties': {
                    'customerRecordId': {'type': 'string'},
                    'workgroupId': {'type': 'string'},
                    'customerIsWorkgroupManager': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Teams.SaveWorkgroupMemberResponse': {
                'type': 'object',
                'properties': {
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserBatchDeleteRequest': {
                'type': 'object',
                'properties': {
                    'stopOnError': {'type': 'boolean'},
                    'userRecordIds': {'type': 'array', 'items': {'type': 'string'}},
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserBatchDeleteResponse': {
                'type': 'object',
                'properties': {
                    'responses': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserDeleteResponse'
                        },
                    }
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserDeleteResponse': {
                'type': 'object',
                'properties': {
                    'error': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'users': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.User'
                        },
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserBatchDeleteV2Response': {
                'type': 'object',
                'properties': {
                    'responses': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserDeleteV2Response'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserDeleteV2Response': {
                'type': 'object',
                'properties': {
                    'userRecordId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserListResponse': {
                'type': 'object',
                'properties': {
                    'users': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserV2'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserBatchReadRequest': {
                'type': 'object',
                'properties': {
                    'readRequests': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserReadRequest'
                        },
                    },
                    'stopOnError': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserReadRequest': {
                'type': 'object',
                'properties': {
                    'loginId': {'type': 'string'},
                    'publicId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserBatchReadResponse': {
                'type': 'object',
                'properties': {
                    'responses': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserReadV2Response'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserReadResponse': {
                'type': 'object',
                'properties': {
                    'error': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'users': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.User'
                        },
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserBatchSaveRequest': {
                'type': 'object',
                'properties': {
                    'saveRequests': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserSaveRequest'
                        },
                    },
                    'stopOnError': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserSaveRequest': {
                'type': 'object',
                'properties': {
                    'accountLocked': {'type': 'boolean'},
                    'busObId': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'displayName': {'type': 'string'},
                    'error': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'ldapRequired': {'type': 'boolean'},
                    'loginId': {'type': 'string'},
                    'nextPasswordResetDate': {'format': 'date-time', 'type': 'string'},
                    'password': {'type': 'string'},
                    'passwordNeverExpires': {'type': 'boolean'},
                    'securityGroupId': {'type': 'string'},
                    'userCannotChangePassword': {'type': 'boolean'},
                    'userInfoFields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                    'userMustChangePasswordAtNextLogin': {'type': 'boolean'},
                    'windowsUserId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserBatchSaveResponse': {
                'type': 'object',
                'properties': {
                    'responses': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserSaveResponse'
                        },
                    }
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserSaveResponse': {
                'type': 'object',
                'properties': {
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'error': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserBatchSaveV2Request': {
                'type': 'object',
                'properties': {
                    'saveRequests': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserSaveV2Request'
                        },
                    },
                    'stopOnError': {'type': 'boolean'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserSaveV2Request': {
                'type': 'object',
                'properties': {
                    'accountLocked': {'type': 'boolean'},
                    'allCultures': {'type': 'boolean'},
                    'busObId': {'type': 'string'},
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'displayName': {'type': 'string'},
                    'ldapRequired': {'type': 'boolean'},
                    'loginId': {'type': 'string'},
                    'nextPasswordResetDate': {'format': 'date-time', 'type': 'string'},
                    'password': {'type': 'string'},
                    'passwordNeverExpires': {'type': 'boolean'},
                    'securityGroupId': {'type': 'string'},
                    'specificCulture': {'type': 'string'},
                    'userCannotChangePassword': {'type': 'boolean'},
                    'userInfoFields': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldTemplateItem'
                        },
                    },
                    'userMustChangePasswordAtNextLogin': {'type': 'boolean'},
                    'windowsUserId': {'type': 'string'},
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserBatchSaveV2Response': {
                'type': 'object',
                'properties': {
                    'responses': {
                        'type': 'array',
                        'items': {
                            '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserSaveV2Response'
                        },
                    },
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Users.UserSaveV2Response': {
                'type': 'object',
                'properties': {
                    'busObPublicId': {'type': 'string'},
                    'busObRecId': {'type': 'string'},
                    'errorCode': {'type': 'string'},
                    'errorMessage': {'type': 'string'},
                    'hasError': {'type': 'boolean'},
                    'httpStatusCode': {
                        'enum': [
                            'Continue',
                            'SwitchingProtocols',
                            'OK',
                            'Created',
                            'Accepted',
                            'NonAuthoritativeInformation',
                            'NoContent',
                            'ResetContent',
                            'PartialContent',
                            'MultipleChoices',
                            'Ambiguous',
                            'MovedPermanently',
                            'Moved',
                            'Found',
                            'Redirect',
                            'SeeOther',
                            'RedirectMethod',
                            'NotModified',
                            'UseProxy',
                            'Unused',
                            'TemporaryRedirect',
                            'RedirectKeepVerb',
                            'BadRequest',
                            'Unauthorized',
                            'PaymentRequired',
                            'Forbidden',
                            'NotFound',
                            'MethodNotAllowed',
                            'NotAcceptable',
                            'ProxyAuthenticationRequired',
                            'RequestTimeout',
                            'Conflict',
                            'Gone',
                            'LengthRequired',
                            'PreconditionFailed',
                            'RequestEntityTooLarge',
                            'RequestUriTooLong',
                            'UnsupportedMediaType',
                            'RequestedRangeNotSatisfiable',
                            'ExpectationFailed',
                            'UpgradeRequired',
                            'InternalServerError',
                            'NotImplemented',
                            'BadGateway',
                            'ServiceUnavailable',
                            'GatewayTimeout',
                            'HttpVersionNotSupported',
                        ],
                        'type': 'string',
                    },
                },
            },
            'Trebuchet.WebApi.DataContracts.Security.TokenResponse': {
                'type': 'object',
                'properties': {
                    'access_token': {'type': 'string'},
                    'as:client_id': {'type': 'string'},
                    '.expires': {'type': 'string'},
                    'expires_in': {'format': 'int32', 'type': 'integer'},
                    '.issued': {'type': 'string'},
                    'refresh_token': {'type': 'string'},
                    'token_type': {'type': 'string'},
                    'username': {'type': 'string'},
                },
            },
        },
        info={
            'version': '10.4.0',
            'title': 'Cherwell Rest API',
            'description': '<a href="https://cherwellsupport.com/CherwellOnlineDocs?Product=CSM&Locale=en-US&Version=10.4.0.1730&Context=ExternalAPIMajorTypesDlg">Cherwell Rest API Documentation</a><br>Select version options from the header drop-down list (to the left of the Client Key box). Then, click Explore to view different versions of operations.',
            'termsOfService': 'Terms of Service',
            'contact': {
                'name': 'Cherwell Software, LLC',
                'url': 'http://www.cherwell.com/community',
            },
        },
        paths={
            '/api/V1/approval/{approvalRecId}/{approvalAction}': {
                'post': {
                    'tags': ['Approval'],
                    'summary': 'Action an Approval',
                    'description': "Operation that actions an Approval Business Object. Use this method, passing either approve, abstain or deny to update the Business Object's state",
                    'operationId': 'Approval_ActionApprovalV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'approvalRecId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'approvalAction',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.SaveResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/approval/{approvalRecId}': {
                'get': {
                    'tags': ['Approval'],
                    'summary': 'Get Approval',
                    'description': 'Operation that returns an Approval Business Object.  Use the provided links to action the Approval',
                    'operationId': 'Approval_GetApprovalByRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'approvalRecId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Approval.ApprovalReadResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getmyapprovals': {
                'get': {
                    'tags': ['Approval'],
                    'summary': 'Get all waiting Approvals for the current user',
                    'description': "Operation that returns a list of Approval Business Objects that are in a state of 'Waiting' for the current user.  Use the provided links to action the Approval",
                    'operationId': 'Approval_GetMyApprovalsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Approval.GetApprovalsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getmypendingapprovals': {
                'get': {
                    'tags': ['Approval'],
                    'summary': 'Get all waiting approvals that were created by the current user',
                    'description': "Operation that returns a list of Approval Business Objects that are in a state of 'Waiting' that were created by the current user.  Use the provided links to action the Approval",
                    'operationId': 'Approval_GetMyPendingApprovalsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Approval.GetApprovalsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/deletebusinessobjectbatch': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Delete Business Objects in a batch',
                    'description': 'Operation to delete a batch of Business Objects.',
                    'operationId': 'BusinessObject_DeleteBusinessObjectBatchV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Specify an array of Business Object IDs and record IDs or public IDs. Use a flag to stop on error or continue on error.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.BatchDeleteRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.BatchDeleteResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/deletebusinessobject/busobid/{busobid}/publicid/{publicid}': {
                'delete': {
                    'tags': ['BusinessObject'],
                    'summary': 'Delete a Business Object by public ID',
                    'description': 'Operation to delete a Business Object by Business Object ID.',
                    'operationId': 'BusinessObject_DeleteBusinessObjectByPublicIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the Business Object public ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.DeleteResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/deletebusinessobject/busobid/{busobid}/busobrecid/{busobrecid}': {
                'delete': {
                    'tags': ['BusinessObject'],
                    'summary': 'Delete a Business Object by record ID',
                    'description': 'Operation to delete a single Business Object.',
                    'operationId': 'BusinessObject_DeleteBusinessObjectByRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': ' Specify the Business Object record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.DeleteResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/deleterelatedbusinessobject/parentbusobid/{parentbusobid}/parentbusobrecid/{parentbusobrecid}/relationshipid/{relationshipid}/publicid/{publicid}': {
                'delete': {
                    'tags': ['BusinessObject'],
                    'summary': 'Delete a related Business Object by public ID',
                    'description': 'Operation to delete a related Business Object. (Use "Unlink Related Business Object" to unlink two Business Objects rather that deleting the related Business Object.)',
                    'operationId': 'BusinessObject_DeleteRelatedBusinessObjectByPublicIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'parentbusobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'parentbusobrecid',
                            'in': 'path',
                            'description': 'Specify the record ID for the parent Business Object',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'relationshipid',
                            'in': 'path',
                            'description': 'Specify the Relationship ID for the related Business Object you want to delete.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the public ID for the related Business Object you want to delete. Use only for Business Objects with unique public IDs. Use "Delete a related Business Object by record ID" when public IDs are not unique.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.RelatedBusinessObjectResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/deleterelatedbusinessobject/parentbusobid/{parentbusobid}/parentbusobrecid/{parentbusobrecid}/relationshipid/{relationshipid}/busobrecid/{busobrecid}': {
                'delete': {
                    'tags': ['BusinessObject'],
                    'summary': 'Delete a related Business Object by record ID',
                    'description': 'Operation to delete a related Business Object. (Use "Unlink Related Business Object" to unlink two Business Objects rather that deleting the related Business Object.)',
                    'operationId': 'BusinessObject_DeleteRelatedBusinessObjectByRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'parentbusobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'parentbusobrecid',
                            'in': 'path',
                            'description': 'Specify the record ID for the parent Business Object',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'relationshipid',
                            'in': 'path',
                            'description': 'Specify the Relationship ID for the related Business Object you want to delete.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the record ID for the related Business Object you want to delete.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.RelatedBusinessObjectResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/fieldvalueslookup': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get lookup values for fields',
                    'description': 'Operation to get potentially valid values for Business Object fields.',
                    'operationId': 'BusinessObject_FieldValuesLookupV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object that specifies the Business Object and fields for which values are to be returned.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldValuesLookupRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.FieldValuesLookupResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getactivities/busobid/{busobid}/busobrecid/{busobrecid}/pagesize/{pageSize}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Retrieve all activities for a business object',
                    'description': 'Operation to retrieve all activities for a business object. Activities are mapped to history tracking business objects.',
                    'operationId': 'BusinessObject_GetActivitiesV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'pageSize',
                            'in': 'path',
                            'description': 'Specify the number of rows to return per page. Maximum value is 2000 per page.',
                            'required': True,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'pageNumber',
                            'in': 'query',
                            'description': 'Specify the page number of the result set to return.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'activityType',
                            'in': 'query',
                            'description': 'The category of activities to retrieve. Will default to All if not specified.',
                            'required': False,
                            'type': 'string',
                            'enum': [
                                'All',
                                'Audit',
                                'Communication',
                                'Notes',
                                'Pinned',
                            ],
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.BusObActivity'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectattachment/attachmentid/{attachmentid}/busobid/{busobid}/busobrecid/{busobrecid}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get an imported Business Object attachment',
                    'description': 'Operation to get a Business Object attachment that has been imported into the system.  HTTP Range Header can be used but is optional.',
                    'operationId': 'BusinessObject_GetBusinessObjectAttachmentByAttachmentIdV1',
                    'consumes': [],
                    'produces': ['application/octet-stream'],
                    'parameters': [
                        {
                            'name': 'attachmentid',
                            'in': 'path',
                            'description': 'Specify the internal ID of the attachment record that contains information about the imported file.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {'format': 'binary', 'type': 'string'},
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectattachments/busobid/{busobid}/publicid/{publicid}/type/{type}/attachmenttype/{attachmenttype}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get attachments by Business Object public ID',
                    'description': 'Operation to get attachments for a Business Object by Business Object ID and public ID.',
                    'operationId': 'BusinessObject_GetBusinessObjectAttachmentsByIdAndPublicIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the Business Object public ID for the record that contains the attachments.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'type',
                            'in': 'path',
                            'description': 'Record attachment type: </br>\nNone - Not applicable to the REST API. </br>\nFile - Linked files. </br>\nFileManagerFile - Imported files.</br>\nBusOb - Attached Business Objects. </br>\nHistory - Information about the attachment, if any is available. For example, an e-mail message may store the name of an attachment sent.</br>\nOther - Not applicable to the REST API. </br>',
                            'required': True,
                            'type': 'string',
                            'enum': [
                                'None',
                                'File',
                                'FileManagerFile',
                                'BusOb',
                                'History',
                                'Other',
                                'Solution',
                                'UsedAsSolution',
                                'ExternalSolution',
                            ],
                        },
                        {
                            'name': 'attachmenttype',
                            'in': 'path',
                            'description': 'For file types, select the type of attachment: </br>\nImported - Attachment was imported into database. </br>\nLinked - Attachment is linked to an external file. </br>\nURL - Attachment is a URL.',
                            'required': True,
                            'type': 'string',
                            'enum': ['Imported', 'Linked', 'URL'],
                        },
                        {
                            'name': 'includelinks',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectattachments/busobid/{busobid}/busobrecid/{busobrecid}/type/{type}/attachmenttype/{attachmenttype}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get attachments by Business Object record ID',
                    'description': 'Operation to get attachments for a Business Object by Business Object ID and record ID.',
                    'operationId': 'BusinessObject_GetBusinessObjectAttachmentsByIdAndRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'type',
                            'in': 'path',
                            'description': 'Record attachment type: </br>\nNone - Not applicable to the REST API. </br>\nFile - Linked files. </br>\nFileManagerFile - Imported files.</br>\nBusOb - Attached Business Objects. </br>\nHistory - Information about the attachment, if any is available. For example, an e-mail message may store the name of an attachment sent.</br>\nOther - Not applicable to the REST API. </br>',
                            'required': True,
                            'type': 'string',
                            'enum': [
                                'None',
                                'File',
                                'FileManagerFile',
                                'BusOb',
                                'History',
                                'Other',
                                'Solution',
                                'UsedAsSolution',
                                'ExternalSolution',
                            ],
                        },
                        {
                            'name': 'attachmenttype',
                            'in': 'path',
                            'description': 'For file types, select the type of attachment: </br>\nImported - Attachment was imported into database. </br>\nLinked - Attachment is linked to an external file. </br>\nURL - Attachment is a URL.',
                            'required': True,
                            'type': 'string',
                            'enum': ['Imported', 'Linked', 'URL'],
                        },
                        {
                            'name': 'includelinks',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectattachments/busobname/{busobname}/publicid/{publicid}/type/{type}/attachmenttype/{attachmenttype}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get attachments by Business Object name and public ID',
                    'description': 'Operation to get attachments for a Business Object by Business Object Name and public ID.',
                    'operationId': 'BusinessObject_GetBusinessObjectAttachmentsByNameAndPublicIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the Business Object public ID for the record that contains the attachments.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'type',
                            'in': 'path',
                            'description': 'Record attachment type: </br>\nNone - Not applicable to the REST API. </br>\nFile - Linked files. </br>\nFileManagerFile - Imported files.</br>\nBusOb - Attached Business Objects. </br>\nHistory - Information about the attachment, if any is available. For example, an e-mail message may store the name of an attachment sent.</br>\nOther - Not applicable to the REST API. </br>',
                            'required': True,
                            'type': 'string',
                            'enum': [
                                'None',
                                'File',
                                'FileManagerFile',
                                'BusOb',
                                'History',
                                'Other',
                                'Solution',
                                'UsedAsSolution',
                                'ExternalSolution',
                            ],
                        },
                        {
                            'name': 'attachmenttype',
                            'in': 'path',
                            'description': 'For file types, select the type of attachment: </br>\nImported - Attachment was imported into database. </br>\nLinked - Attachment is linked to an external file. </br>\nURL - Attachment is a URL.',
                            'required': True,
                            'type': 'string',
                            'enum': ['Imported', 'Linked', 'URL'],
                        },
                        {
                            'name': 'includelinks',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectattachments/busobname/{busobname}/busobrecid/{busobrecid}/type/{type}/attachmenttype/{attachmenttype}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get attachments by Business Object name and record ID',
                    'description': 'Operation to get attachments for a Business Object by name and record ID.',
                    'operationId': 'BusinessObject_GetBusinessObjectAttachmentsByNameAndRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'type',
                            'in': 'path',
                            'description': 'Record attachment type: </br>\nNone - Not applicable to the REST API. </br>\nFile - Linked files. </br>\nFileManagerFile - Imported files.</br>\nBusOb - Attached Business Objects. </br>\nHistory - Information about the attachment, if any is available. For example, an e-mail message may store the name of an attachment sent.</br>\nOther - Not applicable to the REST API. </br>',
                            'required': True,
                            'type': 'string',
                            'enum': [
                                'None',
                                'File',
                                'FileManagerFile',
                                'BusOb',
                                'History',
                                'Other',
                                'Solution',
                                'UsedAsSolution',
                                'ExternalSolution',
                            ],
                        },
                        {
                            'name': 'attachmenttype',
                            'in': 'path',
                            'description': 'For file types, select the type of attachment: </br>\nImported - Attachment was imported into database. </br>\nLinked - Attachment is linked to an external file. </br>\nURL - Attachment is a URL.',
                            'required': True,
                            'type': 'string',
                            'enum': ['Imported', 'Linked', 'URL'],
                        },
                        {
                            'name': 'includelinks',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectattachments': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get Business Object attachments by request object',
                    'description': 'Operation to get attachments for a Business Object by attachments request object.',
                    'operationId': 'BusinessObject_GetBusinessObjectAttachmentsV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'attachmentsRequest',
                            'in': 'body',
                            'description': 'Object with all the parameters to request an attachments list. You can also request a list of types to get more than just one type at a time.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectbatch': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get a batch of Business Object records',
                    'description': 'Operation that returns a batch of Business Object records that includes a list of field record IDs, display names, and values for each record.',
                    'operationId': 'BusinessObject_GetBusinessObjectBatchV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Specify an array of Business Object IDs, record IDs, or public IDs. Use a flag to stop on error or continue on error.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.BatchReadRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.BatchReadResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobject/busobid/{busobid}/publicid/{publicid}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get a Business Object record',
                    'description': 'Operation that returns a Business Object record that includes a list of fields and their record IDs, names, and set values.',
                    'operationId': 'BusinessObject_GetBusinessObjectByPublicIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the Business Object public ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.ReadResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobject/busobid/{busobid}/busobrecid/{busobrecid}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get a Business Object record',
                    'description': 'Operation that returns a Business Object record that includes a list of fields and their record IDs, names, and set values.',
                    'operationId': 'BusinessObject_GetBusinessObjectByRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.ReadResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobject/scancode/{scanCode}/busobid/{busobid}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get a Business Object by its scan code and Business Object ID',
                    'description': 'Operation to get a Business Object based on its associated scan code and Business Object ID.',
                    'operationId': 'BusinessObject_GetBusinessObjectByScanCodeBusObIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scanCode',
                            'in': 'path',
                            'description': 'The scan code for a Business Object record.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'The Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.BarcodeLookupResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobject/scancode/{scanCode}/busobname/{busobname}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get a Business Object by its scan code and Business Object name',
                    'description': 'Operation to get a Business Object based on its associated scan code and Business Object name.',
                    'operationId': 'BusinessObject_GetBusinessObjectByScanCodeBusObNameV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scanCode',
                            'in': 'path',
                            'description': 'The scan code for a Business Object record.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'The Business Bbject name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.BarcodeLookupResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectschema/busobid/{busobId}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get a Business Object schema',
                    'description': 'Operation that returns the schema for a Business Object and, optionally, its related Business Objects.',
                    'operationId': 'BusinessObject_GetBusinessObjectSchemaV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobId',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'includerelationships',
                            'in': 'query',
                            'description': 'Flag to include schemas for related Business Object. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.SchemaResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectsummaries/type/{type}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get Business Object summaries by type',
                    'description': 'Operation that returns a list of Business Object summaries by type (Major, Supporting, Lookup, Groups, and All). ',
                    'operationId': 'BusinessObject_GetBusinessObjectSummariesV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'type',
                            'in': 'path',
                            'description': 'Use to show:<br />All - All objects<br />Major - Major objects only<br />Supporting - Supporting objects only<br />Lookup - Lookup objects only<br />Groups - Groups only',
                            'required': True,
                            'type': 'string',
                            'enum': ['All', 'Major', 'Supporting', 'Lookup', 'Groups'],
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.Summary'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectsummary/busobid/{busobid}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get a Business Object summary by ID',
                    'description': 'Operation that returns a single Business Object summary by ID.',
                    'operationId': 'BusinessObject_GetBusinessObjectSummaryByIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify a Business Object ID to get its summary.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.Summary'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjectsummary/busobname/{busobname}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get a Business Object summary by name',
                    'description': 'Operation that returns a single Business Object summary by name.',
                    'operationId': 'BusinessObject_GetBusinessObjectSummaryByNameV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify a Business Object name to get its summary.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.Summary'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getbusinessobjecttemplate': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get Business Object templates for create',
                    'description': 'Operation that returns a template to create Business Objects.  The template includes placeholders for field values. You can then send the template with these values to the Business Object Save operation.',
                    'operationId': 'BusinessObject_GetBusinessObjectTemplateV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Specify the Business Object ID. Use true to include all required fields or all fields. Specify an optional fields list by adding field names in a comma-delimited list ["field1", "field2"]. ',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.TemplateRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.TemplateResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getrelatedbusinessobject': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get related Business Objects using a request object',
                    'description': 'Operation to get related Business Objects for a specific relationship. Specify a list of fields to include in the response. The order of parameter usage and overrides is: all fields set to true overrides default overrides;  custom grid overrides field list settings.',
                    'operationId': 'BusinessObject_GetRelatedBusinessObjectByRequestV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'relatedBusinessObjectRequest',
                            'in': 'body',
                            'description': 'Request object containing all the possible parameters to get related Business Objects.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.RelatedBusinessObjectRequest'
                            },
                        },
                        {
                            'name': 'includelinks',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.RelatedBusinessObjectResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getrelatedbusinessobject/parentbusobid/{parentbusobid}/parentbusobrecid/{parentbusobrecid}/relationshipid/{relationshipid}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get related Business Objects by ID',
                    'description': 'Operation to get the related objects for a Business Object relationship specifying all fields or default grid as the field to return.',
                    'operationId': 'BusinessObject_GetRelatedBusinessObjectV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'parentbusobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'parentbusobrecid',
                            'in': 'path',
                            'description': 'Specify the record ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'relationshipid',
                            'in': 'path',
                            'description': 'Specify the Relationship ID for the related Business Object you want to return.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'pageNumber',
                            'in': 'query',
                            'description': 'Specify the page number of the result set to return.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'pageSize',
                            'in': 'query',
                            'description': 'Specify the number of rows to return per page.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'allfields',
                            'in': 'query',
                            'description': 'Flag to include all related Business Object fields.  Default is true if not supplied.  If true, then UseDefaultGrid is not used.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'usedefaultgrid',
                            'in': 'query',
                            'description': 'Flag to trigger the use of the related Business Objects default grid for the list of fields to return.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'includelinks',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.RelatedBusinessObjectResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getrelatedbusinessobject/parentbusobid/{parentbusobid}/parentbusobrecid/{parentbusobrecid}/relationshipid/{relationshipid}/gridid/{gridid}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Get related Business Objects custom grid',
                    'description': 'Operation to get related Business Objects for a specific relationship. Specify a custom grid ID as the fields to return.',
                    'operationId': 'BusinessObject_GetRelatedBusinessObjectWithCustomGridV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'parentbusobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'parentbusobrecid',
                            'in': 'path',
                            'description': 'Specify the record ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'relationshipid',
                            'in': 'path',
                            'description': 'Specify the Relationship ID for the related Business Object you want to return.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'gridid',
                            'in': 'path',
                            'description': 'Specify the ID for the custom grid that contains the field list.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'pageNumber',
                            'in': 'query',
                            'description': 'Specify the page number of the result set to return.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'pageSize',
                            'in': 'query',
                            'description': 'Specify the number of rows to return per page.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'includelinks',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.RelatedBusinessObjectResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/linkrelatedbusinessobject/parentbusobid/{parentbusobid}/parentbusobrecid/{parentbusobrecid}/relationshipid/{relationshipid}/busobid/{busobid}/busobrecid/{busobrecid}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Link related Business Objects',
                    'description': 'Operation to link related Business Objects. ',
                    'operationId': 'BusinessObject_LinkRelatedBusinessObjectByRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'parentbusobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'parentbusobrecid',
                            'in': 'path',
                            'description': 'Specify the record ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'relationshipid',
                            'in': 'path',
                            'description': 'Specify the Relationship ID for the related Business Object you want to link.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID of the Business Object to be linked.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID of the Business Object to be linked.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.RelatedBusinessObjectResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/linkrelatedbusinessobject/parentbusobid/{parentbusobid}/parentbusobrecid/{parentbusobrecid}/relationshipid/{relationshipid}/busobid/{busobid}/busobrecid/{busobrecid}': {
                'get': {
                    'tags': ['BusinessObject'],
                    'summary': 'Link related Business Objects',
                    'description': 'Operation to link related Business Objects. ',
                    'operationId': 'BusinessObject_LinkRelatedBusinessObjectByRecIdV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'parentbusobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'parentbusobrecid',
                            'in': 'path',
                            'description': 'Specify the record ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'relationshipid',
                            'in': 'path',
                            'description': 'Specify the Relationship ID for the related Business Object you want to link.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID of the Business Object to be linked.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID of the Business Object to be linked.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.ResponseBase'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/removebusinessobjectattachment/attachmentid/{attachmentid}/busobid/{busobid}/publicid/{publicid}': {
                'delete': {
                    'tags': ['BusinessObject'],
                    'summary': 'Remove an attachment by Business Object ID and public ID',
                    'description': 'Operation to remove an attachment from a Business Object using the attachment record ID, Business Object ID, and Business Object public ID.',
                    'operationId': 'BusinessObject_RemoveBusinessObjectAttachmentByIdAndPublicIdV1',
                    'consumes': [],
                    'produces': [],
                    'parameters': [
                        {
                            'name': 'attachmentid',
                            'in': 'path',
                            'description': 'Specify the internal ID of the attachment record.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the Business Object public ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {'204': {'description': 'No Content'}},
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/removebusinessobjectattachment/attachmentid/{attachmentid}/busobid/{busobid}/busobrecid/{busobrecid}': {
                'delete': {
                    'tags': ['BusinessObject'],
                    'summary': 'Remove an attachment by Business Object ID and record ID',
                    'description': 'Operation to remove an attachment from a Business Object using the attachment record ID, Business Object ID, and Business Object record ID.',
                    'operationId': 'BusinessObject_RemoveBusinessObjectAttachmentByIdAndRecIdV1',
                    'consumes': [],
                    'produces': [],
                    'parameters': [
                        {
                            'name': 'attachmentid',
                            'in': 'path',
                            'description': 'Specify the internal ID of the attachment record.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {'204': {'description': 'No Content'}},
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/removebusinessobjectattachment/attachmentid/{attachmentid}/busobname/{busobname}/publicid/{publicid}': {
                'delete': {
                    'tags': ['BusinessObject'],
                    'summary': 'Remove an attachment by Business Object name and public ID',
                    'description': 'Operation to remove an attachment from a Business Object using the attachment record ID, Business Object name, and Business Object record ID.',
                    'operationId': 'BusinessObject_RemoveBusinessObjectAttachmentByNameAndPublicIdV1',
                    'consumes': [],
                    'produces': [],
                    'parameters': [
                        {
                            'name': 'attachmentid',
                            'in': 'path',
                            'description': 'Specify the internal ID of the attachment record.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the Business Object public ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {'204': {'description': 'No Content'}},
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/removebusinessobjectattachment/attachmentid/{attachmentid}/busobname/{busobname}/busobrecid/{busobrecid}': {
                'delete': {
                    'tags': ['BusinessObject'],
                    'summary': 'Remove an attachment by Business Object name and record ID',
                    'description': 'Operation to remove an attachment from a Business Object using the attachment record ID, Business Object name, and Business Object public ID.',
                    'operationId': 'BusinessObject_RemoveBusinessObjectAttachmentByNameAndRecIdV1',
                    'consumes': [],
                    'produces': [],
                    'parameters': [
                        {
                            'name': 'attachmentid',
                            'in': 'path',
                            'description': 'Specify the internal ID of the attachment record.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {'204': {'description': 'No Content'}},
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/savebusinessobjectattachmentbusob': {
                'put': {
                    'tags': ['BusinessObject'],
                    'summary': 'Attach a Business Object to a Business Object',
                    'description': 'Operation to attach a Business Object to a Business Object. This links the Business Object but does not create a relationship between the two. (Use "Link Related Business Objects" to create a relationship.)',
                    'operationId': 'BusinessObject_SaveBusinessObjectAttachmentBusObV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object used to specify the Business Objects to attach. You can use Business Object name or ID and Business Object record ID or public ID.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.SaveBusObAttachmentRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/savebusinessobjectattachmentlink': {
                'put': {
                    'tags': ['BusinessObject'],
                    'summary': 'Attach a file via UNC',
                    'description': 'Operation to attach a file to a Business Object via a path (UNC recommended).',
                    'operationId': 'BusinessObject_SaveBusinessObjectAttachmentLinkV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object used to specify the file path (UNC recommended) and the Business Object. You can use Business Object name or ID and Business Object record ID or public ID.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.SaveLinkAttachmentRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/savebusinessobjectattachmenturl': {
                'put': {
                    'tags': ['BusinessObject'],
                    'summary': 'Attach a URL path',
                    'description': 'Operation to attach a URL path to a Business Object.',
                    'operationId': 'BusinessObject_SaveBusinessObjectAttachmentUrlV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object used to specify the URL path and Business Object. You can use Business Object name or ID and Business Object record ID or public ID.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.SaveUrlAttachmentRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.AttachmentsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/savebusinessobjectbatch': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Create or update a batch of Business Objects',
                    'description': 'Operation that creates or updates an array of Business Objects in a batch. To update, specify record ID or public ID. To create, leave record ID and public ID empty.',
                    'operationId': 'BusinessObject_SaveBusinessObjectBatchV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Specify the array of Business Object templates. ',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.BatchSaveRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.BatchSaveResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/savebusinessobject': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Create or Update a Business Object',
                    'description': 'Operation that creates a new Business Object or updates an existing Business Object. To create, leave record ID and public ID empty. Upon creating or saving, a cache key is returned to use for subsequent requests. If the object is not found in the cache with said cache key, specify record ID or public ID to save and return a new cache key. Set persist = true, to actually save the Business Object to disk, persist = false will just cache it.',
                    'operationId': 'BusinessObject_SaveBusinessObjectV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Specify a list of fields from a Business Object template. ',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.SaveRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.SaveResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/saverelatedbusinessobject': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Create or update a related Business Object',
                    'description': 'Operation that creates or updates a related Business Object. To update, specify record ID or public ID. To create, leave record ID and public ID empty.',
                    'operationId': 'BusinessObject_SaveRelatedBusinessObjectV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object specifying the parent the Business Object, the Relationship, and field values for the Business Object to create or update. ',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.RelatedSaveRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.BusinessObject.RelatedSaveResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/unlinkrelatedbusinessobject/parentbusobid/{parentbusobid}/parentbusobrecid/{parentbusobrecid}/relationshipid/{relationshipid}/busobid/{busobid}/busobrecid/{busobrecid}': {
                'delete': {
                    'tags': ['BusinessObject'],
                    'summary': 'UnLink related Business Objects',
                    'description': 'Operation to unlink related Business Objects.',
                    'operationId': 'BusinessObject_UnLinkRelatedBusinessObjectByRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'parentbusobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'parentbusobrecid',
                            'in': 'path',
                            'description': 'Specify the record ID for the parent Business Object.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'relationshipid',
                            'in': 'path',
                            'description': 'Specify the Relationship ID for the related Business Object you want to unlink.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID of the Business Object to be unlinked.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID of the Business Object to be unlinked.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.RelatedBusinessObjectResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/uploadbusinessobjectattachment/filename/{filename}/busobid/{busobid}/publicid/{publicid}/offset/{offset}/totalsize/{totalsize}': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Upload an attachment by Business Object ID and public ID',
                    'description': 'Operation to upload an attachment to a Business Object record using a Business Object ID and public ID. The body of the request is the byte array of the file part being uploaded.',
                    'operationId': 'BusinessObject_UploadBusinessObjectAttachmentByIdAndPublicIdV1',
                    'consumes': ['application/octet-stream'],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'body',
                            'in': 'body',
                            'required': True,
                            'schema': {'format': 'binary', 'type': 'string'},
                        },
                        {
                            'name': 'filename',
                            'in': 'path',
                            'description': 'Specify the name of the file being uploaded. If no attachment name is provided, the file name is used.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the Business Object public ID  to attach the file to.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'offset',
                            'in': 'path',
                            'description': 'The offset is the starting index of the file part being uploaded.  If this is the first part then the offset will be zero.',
                            'required': True,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'totalsize',
                            'in': 'path',
                            'description': 'The entire file size in bytes.',
                            'required': True,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'attachmentid',
                            'in': 'query',
                            'description': 'Specify the attachment ID of an uploaded file to upload subsequent parts and ensure each part gets appended to the parts that have already been uploaded.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'displaytext',
                            'in': 'query',
                            'description': 'Specify the attachment name, which is the display text for the attachment record.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {'description': 'OK', 'schema': {'type': 'string'}}
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/uploadbusinessobjectattachment/filename/{filename}/busobid/{busobid}/busobrecid/{busobrecid}/offset/{offset}/totalsize/{totalsize}': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Upload an attachment by Business Object ID and record ID',
                    'description': 'Operation to upload an attachment to a Business Object record using a Business Object ID and record ID. The body of the request is the byte array of the file part being uploaded.',
                    'operationId': 'BusinessObject_UploadBusinessObjectAttachmentByIdAndRecIdV1',
                    'consumes': ['application/octet-stream'],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'body',
                            'in': 'body',
                            'required': True,
                            'schema': {'format': 'binary', 'type': 'string'},
                        },
                        {
                            'name': 'filename',
                            'in': 'path',
                            'description': 'Specify the name of the file being uploaded. If no attachment name is provided, the file name is used.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID to attach the file to.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'offset',
                            'in': 'path',
                            'description': 'The offset is the starting index of the file part being uploaded.  If this is the first part then the offset will be zero.',
                            'required': True,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'totalsize',
                            'in': 'path',
                            'description': 'The entire file size in bytes.',
                            'required': True,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'attachmentid',
                            'in': 'query',
                            'description': 'Specify the attachment ID of an uploaded file to upload subsequent parts and ensure each part gets appended to the parts that have already been uploaded.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'displaytext',
                            'in': 'query',
                            'description': 'Specify the attachment name, which is the display text for the attachment record.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {'description': 'OK', 'schema': {'type': 'string'}}
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/uploadbusinessobjectattachment/filename/{filename}/busobname/{busobname}/publicid/{publicid}/offset/{offset}/totalsize/{totalsize}': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Upload an attachment by Business Object name and public ID',
                    'description': 'Operation to upload an attachment to a Business Object record using a Business Object name and public ID. The body of the request is the byte array of the file part being uploaded.',
                    'operationId': 'BusinessObject_UploadBusinessObjectAttachmentByNameAndPublicIdV1',
                    'consumes': ['application/octet-stream'],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'body',
                            'in': 'body',
                            'required': True,
                            'schema': {'format': 'binary', 'type': 'string'},
                        },
                        {
                            'name': 'filename',
                            'in': 'path',
                            'description': 'Specify the name of the file being uploaded. If no attachment name is provided, the file name is used.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the Business Object public ID  to attach the file to.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'offset',
                            'in': 'path',
                            'description': 'The offset is the starting index of the file part being uploaded.  If this is the first part then the offset will be zero.',
                            'required': True,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'totalsize',
                            'in': 'path',
                            'description': 'The entire file size in bytes.',
                            'required': True,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'attachmentid',
                            'in': 'query',
                            'description': 'Specify the attachment ID of an uploaded file to upload subsequent parts and ensure each part gets appended to the parts that have already been uploaded.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'displaytext',
                            'in': 'query',
                            'description': 'Specify the attachment name, which is the display text for the attachment record.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {'description': 'OK', 'schema': {'type': 'string'}}
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/uploadbusinessobjectattachment/filename/{filename}/busobname/{busobname}/busobrecid/{busobrecid}/offset/{offset}/totalsize/{totalsize}': {
                'post': {
                    'tags': ['BusinessObject'],
                    'summary': 'Upload an attachment by Business Object name and record ID',
                    'description': 'Operation to upload an attachment to a Business Object record using a Business Object name and record ID. The body of the request is the byte array of the file part being uploaded.',
                    'operationId': 'BusinessObject_UploadBusinessObjectAttachmentByNameAndRecIdV1',
                    'consumes': ['application/octet-stream'],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'body',
                            'in': 'body',
                            'required': True,
                            'schema': {'format': 'binary', 'type': 'string'},
                        },
                        {
                            'name': 'filename',
                            'in': 'path',
                            'description': 'Specify the name of the file being uploaded. If no attachment name is provided, the file name is used.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID to attach the file to.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'offset',
                            'in': 'path',
                            'description': 'The offset is the starting index of the file part being uploaded.  If this is the first part then the offset will be zero.',
                            'required': True,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'totalsize',
                            'in': 'path',
                            'description': 'The entire file size in bytes.',
                            'required': True,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'attachmentid',
                            'in': 'query',
                            'description': 'Specify the attachment ID of an uploaded file to upload subsequent parts and ensure each part gets appended to the parts that have already been uploaded.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'displaytext',
                            'in': 'query',
                            'description': 'Specify the attachment name, which is the display text for the attachment record.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {'description': 'OK', 'schema': {'type': 'string'}}
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/deletegalleryimage/standinkey/{standinkey}': {
                'delete': {
                    'tags': ['Core'],
                    'summary': 'Delete a gallery image',
                    'description': 'Endpoint to delete a gallery image.',
                    'operationId': 'Core_DeleteGalleryImageByStandInKeyV1',
                    'consumes': [],
                    'produces': [],
                    'parameters': [
                        {
                            'name': 'standinkey',
                            'in': 'path',
                            'description': 'The StandIn key for the gallery image to delete.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {'204': {'description': 'No Content'}},
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getgalleryimages/scope/{scope}/scopeowner/{scopeowner}/folder/{folder}': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Get gallery images by scope, scopeowner, and folder',
                    'description': 'Get gallery images for the specified scope, scopeowner, and folder.',
                    'operationId': 'Core_GetGalleryImagesFolderV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'The scope to get gallery images for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'the scopeowner to get gallery images for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'folder',
                            'in': 'path',
                            'description': 'The folder to get gallery images for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getgalleryimages/scope/{scope}/scopeowner/{scopeowner}': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Get gallery images by scope and scopeowner',
                    'description': 'Get all gallery images for the specified scope and scope owner.',
                    'operationId': 'Core_GetGalleryImagesScopeOwnerV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'The scope to get gallery images for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'The scopeowner to get gallery images for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getgalleryimages/scope/{scope}': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Get gallery images by scope',
                    'description': 'Get all gallery images for the specified scope.',
                    'operationId': 'Core_GetGalleryImagesScopeV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'The scope to get the images for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getgalleryimages': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Get all gallery images',
                    'description': 'Get all the gallery images in the system.',
                    'operationId': 'Core_GetGalleryImagesV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getgalleryimage/name/{name}': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Get built-in images',
                    'description': 'Operation that gets built-in images. If you are requesting an icon (.ico), you can specify width and height.',
                    'operationId': 'Core_GetGalleryImageV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'name',
                            'in': 'path',
                            'description': 'Image name and folder location in the Image Manager. Parameter must begin with "[PlugIn]Images;" and then a period-separated list of folders. Example: "[PlugIn]Images;Images.Common.Cherwell.ico".',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'width',
                            'in': 'query',
                            'description': 'Specify the width (icons only).',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'height',
                            'in': 'query',
                            'description': 'Specify the height (icons only).',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {'description': 'OK', 'schema': {'type': 'string'}}
                    },
                    'deprecated': False,
                }
            },
            '/api/V1/storedvalues/scope/{scope}/scopeowner/{scopeowner}/folder/{folder}': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Get stored values by folder',
                    'description': 'Get stored values for the specified folder.',
                    'operationId': 'Core_GetStoredValuesFolderV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'The scope for which to get stored values.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'The scope owner for which to get stored values.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'folder',
                            'in': 'path',
                            'description': 'The folder for which to get stored values.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/storedvalues/scope/{scope}/scopeowner/{scopeowner}': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Get stored values by scope owner',
                    'description': 'Get stored values for the specified scope and scope owner.',
                    'operationId': 'Core_GetStoredValuesScopeOwnerV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'The scope for which to get stored values.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'The scope owner for which to get stored values.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/storedvalues/scope/{scope}': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Get stored values by scope',
                    'description': 'Get all the stored values for the specified scope.',
                    'operationId': 'Core_GetStoredValuesScopeV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'The scope for which to get stored values.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/storedvalues': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Gets all the stored values in the system',
                    'description': 'Get all the stored values in the system.',
                    'operationId': 'Core_GetStoredValuesV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getstoredvalue/standinkey/{standInKey}': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Get a  stored value',
                    'description': 'Get a stored value by its StandIn key.',
                    'operationId': 'Core_GetStoredValueV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'standInKey',
                            'in': 'path',
                            'description': 'The StandIn key for the Stored Value you would like to retrieve.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.StoredValueResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getviews': {
                'get': {
                    'tags': ['Core'],
                    'summary': 'Get a list of the views',
                    'description': 'Operation to get a list of views that are configured in the system.',
                    'operationId': 'Core_GetViewsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ViewsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/savegalleryimage': {
                'post': {
                    'tags': ['Core'],
                    'summary': 'Create or update a gallery image',
                    'description': 'Endpoint to Create or update a gallery image. To create a new gallery image leave the StandIn key blank. To update a gallery image provide the StandIn key of the gallery image you want to update.\nThere are three different ImageTypes allowed: Imported, Url, and File. To use the Imported image type, provide the filename in the Name property, with extension, and provide the image data in a Base64 encoded format in the Base64EncodedImageData property. The max file size is 512k.\nTo use the Url image type,  provide the full network share path to the file in the Name property, ie: "\\\\\\\\\\\\\\\\networkshare\\\\\\somefolder\\\\\\somefile.jpg". If the file is not accessible to all users it will not visible to all users.\nTo use the File image type, provide the full path to the file in the Name property, ie: "C:\\\\\\somefolder\\\\\\somfile.jpg". If the file is not accessible to all users it will not visible to all users.\nWhen creating or updating an image, Name and ImageType are always required, and if the image type is "Imported", then the Base64EncodedImageData is also required. \nscope, scopeowner, and folder can all be updated independently.',
                    'operationId': 'Core_SaveGalleryImageV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'To create a new gallery image leave the StandIn key blank. To update a gallery image provide the StandIn key of the gallery image you want to update.\nThere are three different ImageTypes allowed: Imported, Url, and File. To use the Imported image type, provide the filename in the Name property, with extension, and provide the image data in a Base64 encoded format in the Base64EncodedImageData property. The max file size is 512k.\nTo use the Url image type,  provide the full network share path to the file in the Name property, ie: "\\\\\\\\\\\\\\\\networkshare\\\\\\somefolder\\\\\\somefile.jpg". If the file is not accessible to all users it will not visible to all users.\nTo use the File image type, provide the full path to the file in the Name property, ie: "C:\\\\\\somefolder\\\\\\somfile.jpg". If the file is not accessible to all users it will not visible to all users.\nWhen creating or updating an image, Name and ImageType are always required, and if the image type is "Imported", then the Base64EncodedImageData is also required. \nscope, scopeowner, and folder can all be updated independently.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.SaveGalleryImageRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.SaveGalleryImageResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/savestoredvalue': {
                'post': {
                    'tags': ['Core'],
                    'summary': 'Create or update a stored value',
                    'description': 'Operation to create or update a stored value. To update, specify the StandIn key for the stored value to update. To create leave StandIn key blank, and provide a name, a scope, a type, and a value.',
                    'operationId': 'Core_SaveStoredValueV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'The stored value to create or update. To update include the StandIn key for the associated stored value. To create, name, scope, type, and value are required.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.SaveStoredValueRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.StoredValueResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/setculture/culturecode/{culturecode}': {
                'put': {
                    'tags': ['Core'],
                    'summary': 'Set the culture for the current user',
                    'description': 'Operation to update the current users culture by culture code. This returns a new access token that has the updated information in it.',
                    'operationId': 'Core_SetCultureV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'culturecode',
                            'in': 'path',
                            'description': 'The culture code to set for the current user.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {'description': 'OK', 'schema': {'type': 'string'}}
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getmobileformforbusob/busobid/{busobid}/publicid/{publicid}': {
                'get': {
                    'tags': ['Forms'],
                    'summary': 'Get mobile form by BusObId and Public ID',
                    'description': 'Operation that gets a mobile form for a specific Business Object by Business Object ID and Public ID.',
                    'operationId': 'Forms_GetMobileFormForBusObByIdAndPublicIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the Business Object Public ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'foredit',
                            'in': 'query',
                            'description': 'Flag to get the edit mode version of a form.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'formid',
                            'in': 'query',
                            'description': 'Specify the form ID if the default is not desired.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Forms.MobileFormResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getmobileformforbusob/busobid/{busobid}/busobrecid/{busobrecid}': {
                'get': {
                    'tags': ['Forms'],
                    'summary': 'Get mobile form by Business Object ID and Business Object Record ID.',
                    'description': 'Operation that gets a mobile form for a specific Business Object by Business Object ID and record ID.',
                    'operationId': 'Forms_GetMobileFormForBusObByIdAndRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object Record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'foredit',
                            'in': 'query',
                            'description': 'Flag to get the edit mode version of a form.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'formid',
                            'in': 'query',
                            'description': 'Specify the form ID if the default is not desired.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Forms.MobileFormResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getmobileformforbusob/busobname/{busobname}/publicid/{publicid}': {
                'get': {
                    'tags': ['Forms'],
                    'summary': 'Get mobile form by Business Object name and Public ID',
                    'description': 'Operation that gets a mobile form for a specific Business Object by Business Object name and public ID.',
                    'operationId': 'Forms_GetMobileFormForBusObByNameAndPublicIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': 'Specify the Business Object public ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'foredit',
                            'in': 'query',
                            'description': 'Flag to get the edit mode version of a form.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'formid',
                            'in': 'query',
                            'description': 'Specify the form ID if the default is not desired.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Forms.MobileFormResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getmobileformforbusob/busobname/{busobname}/busobrecid/{busobrecid}': {
                'get': {
                    'tags': ['Forms'],
                    'summary': 'Get mobile form by Business Object name and record ID.',
                    'description': 'Operation that gets a mobile form for a specific Business Object by Business Object name and record ID.',
                    'operationId': 'Forms_GetMobileFormForBusObByNameAndRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'foredit',
                            'in': 'query',
                            'description': 'Flag to get the edit mode version of a form.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'formid',
                            'in': 'query',
                            'description': 'Specify the form ID if the default is not desired.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Forms.MobileFormResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/{businessObjectDefinitionId}/lifecycle/stages': {
                'get': {
                    'tags': ['Lifecycle'],
                    'summary': 'Get lifecycle stages',
                    'description': 'Gets all of the stages on the lifecycle for a Business Object',
                    'operationId': 'Lifecycle_GetStages',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'businessObjectDefinitionId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.GetStagesResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/{businessObjectDefinitionId}/lifecycle/statuses': {
                'get': {
                    'tags': ['Lifecycle'],
                    'summary': 'Get lifecycle statuses',
                    'description': 'Gets all of the statuses on the lifecycle for a Business Object',
                    'operationId': 'Lifecycle_GetStatuses',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'businessObjectDefinitionId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.GetStatusesResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/{businessObjectDefinitionId}/lifecycle/transitions': {
                'get': {
                    'tags': ['Lifecycle'],
                    'summary': 'Get lifecycle transitions',
                    'description': 'Gets all of the transitions on the lifecycle for a Business Object',
                    'operationId': 'Lifecycle_GetTransitions',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'businessObjectDefinitionId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.GetTransitionsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/{businessObjectDefinitionId}/records/{recordId}/status': {
                'get': {
                    'tags': ['Lifecycle'],
                    'summary': 'Get current lifecycle status for record',
                    'description': 'Gets the current lifecycle status of a business object record',
                    'operationId': 'Lifecycle_GetRecordStatus',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'businessObjectDefinitionId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'recordId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.GetRecordStatusResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/{businessObjectDefinitionId}/records/{recordId}/stage': {
                'get': {
                    'tags': ['Lifecycle'],
                    'summary': 'Get current lifecycle stage for record',
                    'description': 'Gets the current lifecycle stage of a business object record',
                    'operationId': 'Lifecycle_GetRecordStage',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'businessObjectDefinitionId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'recordId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.GetRecordStatusResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/{businessObjectDefinitionId}/records/{recordId}/transitionOptions': {
                'get': {
                    'tags': ['Lifecycle'],
                    'summary': 'Get lifecycle transition options for record',
                    'description': 'Gets the lifecycle transition options currently available to a business object record',
                    'operationId': 'Lifecycle_GetTransitionOptions',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'businessObjectDefinitionId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'recordId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.GetTransitionOptionsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/{businessObjectDefinitionId}/records/{recordId}/transitions': {
                'post': {
                    'tags': ['Lifecycle'],
                    'summary': 'Transition a business object record',
                    'description': 'Transitions a business object record in to the specified lifecycle status',
                    'operationId': 'Lifecycle_TransitionRecord',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'businessObjectDefinitionId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'recordId',
                            'in': 'path',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'transitionRecordRequest',
                            'in': 'body',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Lifecycle.TransitionRecordRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.ResponseBase'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getonestepactions/association/{association}/scope/{scope}/scopeowner/{scopeowner}/folder/{folder}': {
                'get': {
                    'tags': ['OneStepActions'],
                    'summary': 'Get One-Step Actions by Folder',
                    'description': 'Operation to get One-Step Actions by Association, Scope, Scope Owner in a specific folder.',
                    'operationId': 'OneStepActions_GetOneStepActionsByAssociation_Scope_ScopeOwner_FolderV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Business Object association to get One-Step Actions for',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Scope to get One-Step Actions for',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'Scope owner to get One-Step Actions for',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'folder',
                            'in': 'path',
                            'description': 'Folder to get One-Step Actions from',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getonestepactions/association/{association}/scope/{scope}/scopeowner/{scopeowner}': {
                'get': {
                    'tags': ['OneStepActions'],
                    'summary': 'Get One-Step Actions by Scope Owner',
                    'description': 'Operation to get One-Step Actions by Association, Scope, Scope Owner',
                    'operationId': 'OneStepActions_GetOneStepActionsByAssociation_Scope_ScopeOwnerV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Business Object association to get One-Step Actions for',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Scope to get One-Step Actions for',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'Scope owner to get One-Step Actions for',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getonestepactions/association/{association}/scope/{scope}': {
                'get': {
                    'tags': ['OneStepActions'],
                    'summary': 'Get One-Step Actions by Scope',
                    'description': 'Operation to get One-Step Actions by Association, Scope',
                    'operationId': 'OneStepActions_GetOneStepActionsByAssociation_ScopeV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Business Object association to get One-Step Actions for',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Scope to get One-Step Actions for',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getonestepactions/association/{association}': {
                'get': {
                    'tags': ['OneStepActions'],
                    'summary': 'Get One-Step Actions by Association',
                    'description': 'Operation to get One-Step Actions by Association',
                    'operationId': 'OneStepActions_GetOneStepActionsByAssociationV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Business Object association to get One-Step Actions for',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getonestepactions': {
                'get': {
                    'tags': ['OneStepActions'],
                    'summary': 'Get One-Step Actions by default Association',
                    'description': 'Operation to get One-Step Actions by default Association',
                    'operationId': 'OneStepActions_GetOneStepActionsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/runonestepaction/standinkey/{standinkey}/busobid/{busobid}/busobrecid/{busobrecid}': {
                'get': {
                    'tags': ['OneStepActions'],
                    'summary': 'Run a One-Step Action for a Business Object record',
                    'description': 'Operation to run a One-Step Action for a Business Object record by Business Object ID and Business Object Record ID.',
                    'operationId': 'OneStepActions_RunOneStepActionByKeyForRecordByRecIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'standinkey',
                            'in': 'path',
                            'description': 'The key to find the One-Step Action to run',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobid',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobrecid',
                            'in': 'path',
                            'description': 'Specify the Business Object record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.OneStepActions.OneStepActionResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/runonestepaction/standinkey/{standinkey}': {
                'get': {
                    'tags': ['OneStepActions'],
                    'summary': 'Run a stand alone One-Step Action',
                    'description': "Operation to run a One-Step Action that doesn't run against a Business Object Record.",
                    'operationId': 'OneStepActions_RunOneStepActionByStandInKeyV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'standinkey',
                            'in': 'path',
                            'description': 'The key to find the One-Step Action to run',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.OneStepActions.OneStepActionResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/runonestepaction': {
                'post': {
                    'tags': ['OneStepActions'],
                    'summary': 'Run a One-Step Action using a OneStepActionRequest',
                    'description': 'Operation to run a One-Step Action using a OneStepActionRequest. This request is used to start a One-Step Action run with additional information such as prompt values.',
                    'operationId': 'OneStepActions_RunOneStepActionV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object containing all the properties need to start a One-Step Action.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.OneStepActions.OneStepActionRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.OneStepActions.OneStepActionResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/additemtoqueue': {
                'post': {
                    'tags': ['Queues'],
                    'summary': 'Add a Business Object to a queue',
                    'description': 'Operation to add a Business Object to a queue',
                    'operationId': 'Queues_AddItemToQueueV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object containing all properties necessary to add an item to a queue. All properties are required. The standin key defines the queue to which we want to add the Business Object.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Queues.AddItemToQueueRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Queues.AddItemToQueueResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/checkinqueueitem': {
                'post': {
                    'tags': ['Queues'],
                    'summary': 'Check a Business Object in to a queue',
                    'description': 'Operation to check in a queue item',
                    'operationId': 'Queues_CheckInQueueItemV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'The request object for checking in an item to a queue. All properties are required except for historyNotes',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Queues.CheckInQueueItemRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Queues.CheckInQueueItemResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/checkoutqueueitem': {
                'post': {
                    'tags': ['Queues'],
                    'summary': 'Check a Business Object out of a queue',
                    'description': 'Operation to check out a queue item',
                    'operationId': 'Queues_CheckOutQueueItemV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'The request object for checking out an item from a queue. All properties are required except for historyNotes',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Queues.CheckOutQueueItemRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Queues.CheckOutQueueItemResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getqueues/scope/{scope}/scopeowner/{scopeowner}/folder/{folder}': {
                'get': {
                    'tags': ['Queues'],
                    'summary': 'Get available queues.',
                    'description': 'Get available queues for a specific Business Object type based on scope, scope owner, and folder.',
                    'operationId': 'Queues_GetQueuesFolderV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'The scope to get available queues for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'The scope owner to get available queues for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'folder',
                            'in': 'path',
                            'description': 'The folder to get available queues for.  This has to be the folder ID which can be retrieved by doing a getqueues operation without the folder including links option then the links will have the folder IDs.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Whether or not to include links.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getqueues/scope/{scope}/scopeowner/{scopeowner}': {
                'get': {
                    'tags': ['Queues'],
                    'summary': 'Get available queues.',
                    'description': 'Get available queues for a specific Business Object type based on scope, and scope owner.',
                    'operationId': 'Queues_GetQueuesScopeOwnerV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'The scope to get available queues for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'The scope owner to get available queues for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Whether or not to include links.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getqueues/scope/{scope}': {
                'get': {
                    'tags': ['Queues'],
                    'summary': 'Get available queues.',
                    'description': 'Get available queues for a specific Business Object type based on scope.',
                    'operationId': 'Queues_GetQueuesScopeV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'The scope to get available queues for.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Whether or not to include links.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getqueues': {
                'get': {
                    'tags': ['Queues'],
                    'summary': 'Get available queues.',
                    'description': 'Get available queues for a specific Business Object.',
                    'operationId': 'Queues_GetQueuesV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Whether or not to include links.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/removeitemfromqueue': {
                'post': {
                    'tags': ['Queues'],
                    'summary': 'Remove an item from a queue',
                    'description': 'Operation to remove an item from a queue',
                    'operationId': 'Queues_RemoveItemFromQueueV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'The request object to remove an item from a queue. All properties are required except for historyNotes',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Queues.RemoveItemFromQueueRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Queues.RemoveItemFromQueueResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getquicksearchconfigurationforbusobs': {
                'post': {
                    'tags': ['Searches'],
                    'summary': 'Get a Quick Search from a list of Business Object IDs',
                    'description': 'Operation to build a Quick Search configuration that you can use to execute a Quick Search for multiple Business Objects. The configuration  includes supplied Business Object IDs and specific search items with the following options. Use the Option Key to determine if you can change the options. \n</br></br>ChangedOption</br>\nNonFinalStateOption</br>\nSearchAnyWordsOption</br>\nSearchAttachmentsOption</br>\nSearchRelatedOption</br>\nSortByOption</br>\n</br>Option Key:</br>\n0 = None (Not selected and cannot select.)</br>\n1 = Use (Selected and cannot clear.)</br>\n2 = Display (Not selected and can select.)</br>\n3 = UseAndDisplay (Selected and can clear.)</br></br>\nSearchTargetType:</br>\n0 = BusOb (Business Object)</br>\n1 = DocRepository (Document Repository)',
                    'operationId': 'Searches_GetQuickSearchConfigurationForBusObsV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'dataRequest',
                            'in': 'body',
                            'description': 'Request containing the Business Object IDs list.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.QuickSearchConfigurationRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.QuickSearchConfigurationResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getquicksearchconfigurationforbusobswithviewrights': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get a Quick Search by Business Objects with view rights',
                    'description': "Operation to get a Quick Search configuration that you can use to execute a Quick Search based the current user's Business Object view rights. The configuration  includes supplied Business Object IDs and specific search items with the following options. Use the Option Key to determine if you can change the options.</br></br>ChangedOption</br>\nNonFinalStateOption</br>\nSearchAnyWordsOption</br>\nSearchAttachmentsOption</br>\nSearchRelatedOption</br>\nSortByOption</br>\n</br>Option Key:</br>\n0 = None (Not selected and cannot select.)</br>\n1 = Use (Selected and cannot clear.)</br>\n2 = Display (Not selected and can select.)</br>\n3 = UseAndDisplay (Selected and can clear.)</br></br>\nSearchTargetType:</br>\n0 = BusOb (Business Object)</br>\n1 = DocRepository (Document Repository)",
                    'operationId': 'Searches_GetQuickSearchConfigurationForBusObsWithViewRightsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.QuickSearchConfigurationResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getquicksearchresults': {
                'post': {
                    'tags': ['Searches'],
                    'summary': 'Execute a Quick Search from a list of Business Object IDs and search text',
                    'description': 'Operation to execute a Quick Search using a list of Business Object IDs and search text.',
                    'operationId': 'Searches_GetQuickSearchResultsV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'dataRequest',
                            'in': 'body',
                            'description': 'Request object listing Business Object IDs and search text. Leave out the entire Business Object IDs parameter and all configured quick search Business Objects will be searched.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.QuickSearchRequest'
                            },
                        },
                        {
                            'name': 'includeLinks',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SimpleResultsList'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getquicksearchspecificresults': {
                'post': {
                    'tags': ['Searches'],
                    'summary': 'Execute a Quick Search on a specific Business Object',
                    'description': 'Operation to execute a Quick Search for a specific Business Object ID. Use "Get a Quick Search from a list of Business Object IDs" to find values for specific search item options, such as NonFinalStateOption.',
                    'operationId': 'Searches_GetQuickSearchSpecificResultsV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'dataRequest',
                            'in': 'body',
                            'description': 'Request object containing the parameters for specific Business Object Quick Search execution.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.QuickSearchSpecificRequest'
                            },
                        },
                        {
                            'name': 'includeSchema',
                            'in': 'query',
                            'description': 'Flag to include the schema for the results.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'includeLocationFields',
                            'in': 'query',
                            'description': 'Flag to include location fields in the results.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'includeLinks',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchResultsTableResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getquicksearchspecificresults': {
                'post': {
                    'tags': ['Searches'],
                    'summary': 'Execute a Quick Search on a specific Business Object',
                    'description': 'Operation to execute a Quick Search for a specific Business Object ID. Use "Get a Quick Search from a list of Business Object IDs" to find values for specific search item options, such as NonFinalStateOption.',
                    'operationId': 'Searches_GetQuickSearchSpecificResultsV2',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'dataRequest',
                            'in': 'body',
                            'description': 'Request object containing the parameters for specific Business Object Quick Search execution.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.QuickSearchSpecificRequest'
                            },
                        },
                        {
                            'name': 'includeSchema',
                            'in': 'query',
                            'description': 'Flag to include the schema for the results.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'includeLocationFields',
                            'in': 'query',
                            'description': 'Flag to include location fields in the results.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'includeLinks',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.QuickSearchResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchitems/association/{association}/scope/{scope}/scopeowner/{scopeowner}/folder/{folder}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get all saved searches by Folder ID',
                    'description': 'Operation that returns a tree of saved queries, including scope, search name, IDs, and location within the tree.',
                    'operationId': 'Searches_GetSearchItemsByAssociation_Scope_ScopeOwner_FolderV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Use to filter results by Business Object association ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Use to filter results by scope name or ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'Use to filter results by scope owner ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'folder',
                            'in': 'path',
                            'description': 'Use to filter results by Search Group folder ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchItemResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsearchitems/association/{association}/scope/{scope}/scopeowner/{scopeowner}/folder/{folder}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get all saved searches by Folder ID',
                    'description': 'Operation that returns a tree of saved queries, including scope, search name, IDs, and location within the tree.',
                    'operationId': 'Searches_GetSearchItemsByAssociation_Scope_ScopeOwner_FolderV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Use to filter results by Business Object association ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Use to filter results by scope name or ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'Use to filter results by scope owner ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'folder',
                            'in': 'path',
                            'description': 'Use to filter results by Search Group folder ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchitems/association/{association}/scope/{scope}/scopeowner/{scopeowner}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get all saved searches by scope owner (sub scope)',
                    'description': 'Operation that returns a tree of saved queries, including scope, search name, IDs, and location within the tree.',
                    'operationId': 'Searches_GetSearchItemsByAssociation_Scope_ScopeOwnerV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Use to filter results by Business Object association ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Use to filter results by scope name or ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'Use to filter results by scope owner ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchItemResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsearchitems/association/{association}/scope/{scope}/scopeowner/{scopeowner}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get all saved searches by scope owner (sub scope)',
                    'description': 'Operation that returns a tree of saved queries, including scope, search name, IDs, and location within the tree.',
                    'operationId': 'Searches_GetSearchItemsByAssociation_Scope_ScopeOwnerV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Use to filter results by Business Object association ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Use to filter results by scope name or ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'Use to filter results by scope owner ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchitems/association/{association}/scope/{scope}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get all saved searches by scope',
                    'description': 'Operation that returns a tree of saved queries, including scope, search name, IDs, and location within the tree.',
                    'operationId': 'Searches_GetSearchItemsByAssociation_ScopeV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Use to filter results by Business Object association ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Use to filter results by scope name or ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchItemResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsearchitems/association/{association}/scope/{scope}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get all saved searches by scope',
                    'description': 'Operation that returns a tree of saved queries, including scope, search name, IDs, and location within the tree.',
                    'operationId': 'Searches_GetSearchItemsByAssociation_ScopeV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Use to filter results by Business Object association ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Use to filter results by scope name or ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchitems/association/{association}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get all saved searches by Business Object association',
                    'description': 'Operation that returns a tree of saved queries, including scope, search name, IDs, and location within the tree.',
                    'operationId': 'Searches_GetSearchItemsByAssociationV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Use to filter results by Business Object association ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchItemResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsearchitems/association/{association}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get all saved searches by Business Object association',
                    'description': 'Operation that returns a tree of saved queries, including scope, search name, IDs, and location within the tree.',
                    'operationId': 'Searches_GetSearchItemsByAssociationV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Use to filter results by Business Object association ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchitems': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get all saved searches by default Business Object association',
                    'description': 'Operation that returns a tree of saved queries, including scope, search name, IDs, and location within the tree.',
                    'operationId': 'Searches_GetSearchItemsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchItemResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsearchitems': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get all saved searches by default Business Object association',
                    'description': 'Operation that returns a tree of saved queries, including scope, search name, IDs, and location within the tree.',
                    'operationId': 'Searches_GetSearchItemsV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'links',
                            'in': 'query',
                            'description': 'Flag to include hyperlinks in results. Default is false. ',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ManagerData'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchresults': {
                'post': {
                    'tags': ['Searches'],
                    'summary': 'Run an ad-hoc search',
                    'description': 'Operation that runs an ad-hoc Business Object search. To execute a search with Prompts, the PromptId and Value are required in the Prompt request object.</br></br>PromptType is a FieldSubType enum as described below:</br>FieldSubType</br>None = 0</br>Text = 1</br>Number = 2</br>DateTime = 3</br>Logical = 4</br>Binary = 5</br>DateOnly = 6</br>TimeOnly = 7</br>Json = 8</br>JsonArray = 9</br>Xml = 10</br>XmlCollection = 11</br>TimeValue = 12</br>',
                    'operationId': 'Searches_GetSearchResultsAdHocV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'dataRequest',
                            'in': 'body',
                            'description': 'Request object to specify search parameters.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchResultsRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchResultsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchresults/association/{association}/scope/{scope}/scopeowner/{scopeowner}/searchid/{searchid}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Run a saved search by internal ID',
                    'description': 'Operation that returns the paged results of a saved search. When the search contains Prompts, the response contains the Prompt. Send the Prompt and the original operation parameters to  SearchResultsRequest to the getsearchresults ad-hoc http post operation.</br></br>PromptType is a FieldSubType enum as described below:</br>FieldSubType</br>None = 0</br>Text = 1</br>Number = 2</br>DateTime = 3</br>Logical = 4</br>Binary = 5</br>DateOnly = 6</br>TimeOnly = 7</br>Json = 8</br>JsonArray = 9</br>Xml = 10</br>XmlCollection = 11</br>TimeValue = 12</br>',
                    'operationId': 'Searches_GetSearchResultsByIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Specify the Business Object association ID for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Specify the scope name or ID for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'Specify the scope owner ID for the saved search. Use (None) when no scope owner exists.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'searchid',
                            'in': 'path',
                            'description': 'Specify the internal ID for the saved search. Use "Run a saved search by name" if you do not have the internal ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'searchTerm',
                            'in': 'query',
                            'description': 'Specify search text filter the results. Example: Use "Service Request" to filter Incident results to include only service requests.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'pagenumber',
                            'in': 'query',
                            'description': 'Specify the page number of the result set to return.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'pagesize',
                            'in': 'query',
                            'description': 'Specify the number of rows to return per page.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'includeschema',
                            'in': 'query',
                            'description': 'Use to include the table schema of the saved search. If false, results contain the fieldid and field value without field information. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'resultsAsSimpleResultsList',
                            'in': 'query',
                            'description': 'Indicates if the results should be returned in a simple results list format or a table format. Default is a table format.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchResultsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchresults/association/{association}/scope/{scope}/scopeowner/{scopeowner}/searchname/{searchname}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Run a saved search by name',
                    'description': 'Operation that returns the paged results of a saved search. When the search contains Prompts, the response contains the Prompt. Send the Prompt and the original operation parameters to  SearchResultsRequest to the getsearchresults ad-hoc http post operation.</br></br>PromptType is a FieldSubType enum as described below:</br>FieldSubType</br>None = 0</br>Text = 1</br>Number = 2</br>DateTime = 3</br>Logical = 4</br>Binary = 5</br>DateOnly = 6</br>TimeOnly = 7</br>Json = 8</br>JsonArray = 9</br>Xml = 10</br>XmlCollection = 11</br>TimeValue = 12</br>',
                    'operationId': 'Searches_GetSearchResultsByNameV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Specify the Business Object association ID for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Specify the scope name or ID for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'Specify the scope owner ID for the saved search. Use (None) when no scope owner exists.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'searchname',
                            'in': 'path',
                            'description': 'Specify the name of the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'searchTerm',
                            'in': 'query',
                            'description': 'Specify search text filter the results. Example: Use "Service Request" to filter Incident results to include only service requests.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'pagenumber',
                            'in': 'query',
                            'description': 'Specify the page number of the result set to return.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'pagesize',
                            'in': 'query',
                            'description': 'Specify the number of rows to return per page.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'includeschema',
                            'in': 'query',
                            'description': 'Use to include the table schema of the saved search. If false, results contain the fieldid and field value without field information. Default is false.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'resultsAsSimpleResultsList',
                            'in': 'query',
                            'description': 'Indicates if the results should be returned in a simple results list format or a table format. Default is a table format.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.SearchResultsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchresultsexport': {
                'post': {
                    'tags': ['Searches'],
                    'summary': 'Export an ad-hoc search',
                    'description': 'Operation that returns an ad-hoc search in a specified export format: 0=CSV, 1=Excel, 2=Tab, 3=Word, 4=Custom Separator, 5=Simple JSON. To execute a search with Prompts, the PromptId and Value are required in the Prompt request object.</br></br>PromptType is a FieldSubType enum as described below:</br>FieldSubType</br>None = 0</br>Text = 1</br>Number = 2</br>DateTime = 3</br>Logical = 4</br>Binary = 5</br>DateOnly = 6</br>TimeOnly = 7</br>Json = 8</br>JsonArray = 9</br>Xml = 10</br>XmlCollection = 11</br>TimeValue = 12</br>',
                    'operationId': 'Searches_GetSearchResultsExportAdHocV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'dataRequest',
                            'in': 'body',
                            'description': 'Request object to specify search parameters and export format.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.ExportSearchResultsRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {'description': 'OK', 'schema': {'type': 'string'}}
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchresultsexport/association/{association}/scope/{scope}/scopeowner/{scopeowner}/searchid/{searchid}/exportformat/{exportformat}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Export a saved search by ID',
                    'description': 'Operation that returns the paged results of a saved search in a specified format. When the search contains Prompts, the response contains the Prompt. Send the Prompt and the original operation parameters to  SearchResultsRequest to the getsearchresultsexport ad-hoc http post operation.</br></br>PromptType is a FieldSubType enum as described below:</br>FieldSubType</br>None = 0</br>Text = 1</br>Number = 2</br>DateTime = 3</br>Logical = 4</br>Binary = 5</br>DateOnly = 6</br>TimeOnly = 7</br>Json = 8</br>JsonArray = 9</br>Xml = 10</br>XmlCollection = 11</br>TimeValue = 12</br>',
                    'operationId': 'Searches_GetSearchResultsExportByIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Specify the Business Object association ID for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Specify the scope name or ID for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'Specify the scope owner ID for the saved search. Use (None) when no scope owner exists.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'searchid',
                            'in': 'path',
                            'description': 'Specify the internal ID for the saved search. Use "Run a saved search by name" if you do not have the internal ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'exportformat',
                            'in': 'path',
                            'description': 'Specify the format of the export',
                            'required': True,
                            'type': 'string',
                            'enum': [
                                'CSV',
                                'Excel',
                                'Tab',
                                'Word',
                                'CustomSeparator',
                                'Json',
                            ],
                        },
                        {
                            'name': 'searchTerm',
                            'in': 'query',
                            'description': 'Specify search text filter the results. Example: Use "Service Request" to filter Incident results to include only service requests.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'pagenumber',
                            'in': 'query',
                            'description': 'Specify the page number of the result set to return.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'pagesize',
                            'in': 'query',
                            'description': 'Specify the number of rows to return per page.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {'description': 'OK', 'schema': {'type': 'string'}}
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsearchresultsexport/association/{association}/scope/{scope}/scopeowner/{scopeowner}/searchname/{searchname}/exportformat/{exportformat}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Export a saved search by name',
                    'description': 'Operation that returns the paged results of a saved search in a specified format. When the search contains Prompts, the response contains the Prompt. Send the Prompt and the original operation parameters to  SearchResultsRequest to the getsearchresultsexport ad-hoc http post operation.</br></br>PromptType is a FieldSubType enum as described below:</br>FieldSubType</br>None = 0</br>Text = 1</br>Number = 2</br>DateTime = 3</br>Logical = 4</br>Binary = 5</br>DateOnly = 6</br>TimeOnly = 7</br>Json = 8</br>JsonArray = 9</br>Xml = 10</br>XmlCollection = 11</br>TimeValue = 12</br>',
                    'operationId': 'Searches_GetSearchResultsExportByNameV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'association',
                            'in': 'path',
                            'description': 'Specify the Business Object association ID for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Specify the scope name or ID for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeowner',
                            'in': 'path',
                            'description': 'Specify the scope owner ID for the saved search. Use (None) when no scope owner exists.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'searchname',
                            'in': 'path',
                            'description': 'Specify the name of the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'exportformat',
                            'in': 'path',
                            'description': 'Specify the format of the export',
                            'required': True,
                            'type': 'string',
                            'enum': [
                                'CSV',
                                'Excel',
                                'Tab',
                                'Word',
                                'CustomSeparator',
                                'Json',
                            ],
                        },
                        {
                            'name': 'searchTerm',
                            'in': 'query',
                            'description': 'Specify search text filter the results. Example: Use "Service Request" to filter Incident results to include only service requests.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'pagenumber',
                            'in': 'query',
                            'description': 'Specify the page number of the result set to return.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'pagesize',
                            'in': 'query',
                            'description': 'Specify the number of rows to return per page.',
                            'required': False,
                            'type': 'integer',
                            'format': 'int32',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {'description': 'OK', 'schema': {'type': 'string'}}
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/storedsearches/{scope}/{associationName}/{searchName}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get results of a saved search',
                    'description': 'Operation that returns the results of a saved search in JSON format.</br> \n\t\tThis API is protected by a rate limiter and will reject any requests sent from an IP Address when a certain threshold of active concurrent requests has been hit.</br> \n\t\tThis value can be configured by the Max Concurrent Requests configuration value in the Web API config.</br> \n\t\tOnce this limit has been reached, all subsequent requests will receive a status code of 429 (Too Many Requests).\n\t',
                    'operationId': 'Searches_GetSearchResultsAsStringByNameV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Specify the scope name for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'associationName',
                            'in': 'path',
                            'description': 'Specify the Business Object association Name for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'searchName',
                            'in': 'path',
                            'description': 'Specify the name of the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeOwner',
                            'in': 'query',
                            'description': 'Specify the scope owner ID for the saved search. Use (None) when no scope owner exists.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    'type': 'object',
                                    'additionalProperties': {'type': 'string'},
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/storedsearches/{scope}/{associationName}/{searchName}': {
                'get': {
                    'tags': ['Searches'],
                    'summary': 'Get results of a saved search',
                    'description': 'Operation that returns the results of a saved search in JSON format.</br>\nThis API is protected by a rate limiter and will reject any requests sent from an IP Address when a certain threshold of active concurrent requests has been hit.</br>\nThis value can be configured by the Max Concurrent Requests configuration value in the Web API config.</br>\nOnce this limit has been reached, all subsequent requests will receive a status code of 429 (Too Many Requests).</br>\nThis version is not subject to row limits and will return the entire result set of the stored search.\n',
                    'operationId': 'Searches_GetSearchResultsAsStringByNameV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'scope',
                            'in': 'path',
                            'description': 'Specify the scope name for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'associationName',
                            'in': 'path',
                            'description': 'Specify the Business Object association Name for the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'searchName',
                            'in': 'path',
                            'description': 'Specify the name of the saved search.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'scopeOwner',
                            'in': 'query',
                            'description': 'Specify the scope owner ID for the saved search. Use (None) when no scope owner exists.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    'type': 'object',
                                    'additionalProperties': {'type': 'string'},
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/storedsearches': {
                'post': {
                    'tags': ['Searches'],
                    'summary': 'Get results of a saved search',
                    'description': 'Operation that returns the results of a saved search in JSON format.</br>\nThis API is protected by a rate limiter and will reject any requests sent from an IP Address when a certain threshold of active concurrent requests has been hit.</br>\nThis value can be configured by the Max Concurrent Requests configuration value in the Web API config.</br>\nOnce this limit has been reached, all subsequent requests will receive a status code of 429 (Too Many Requests).</br>\nThis version is not subject to row limits and will return the entire result set of the stored search.\n',
                    'operationId': 'Searches_GetSearchResultsAsStringByIdV2',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'searchRequest',
                            'in': 'body',
                            'description': 'Request object to specify search parameters.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.StoredSearchRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Searches.StoredSearchResults'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getclientsecuritysettings/applicationtype/{applicationtype}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get client security settings',
                    'description': 'Operation to get the configured client security settings. Returns true if internal, Windows, LDAP, or SAML are enabled as authentication methods.',
                    'operationId': 'Security_GetClientSecuritySettingsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'applicationtype',
                            'in': 'path',
                            'description': 'The type of CSM application to return security settings for.  Application type is Desktop Client, Browser Client, Browser Portal or Cherwell Mobile.',
                            'required': True,
                            'type': 'string',
                            'enum': [
                                'NotSet',
                                'RichClient',
                                'BrowserClient',
                                'BrowserPortal',
                                'MobileClient',
                                'ServiceMonitor',
                            ],
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.ClientSecuritySettingsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                }
            },
            '/api/V1/getroles': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get all available Roles',
                    'description': 'Operation to get all available Roles.',
                    'operationId': 'Security_GetRolesV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.RoleReadResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getroles': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get all available Roles',
                    'description': 'Operation to get all available Roles.',
                    'operationId': 'Security_GetRolesV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.RoleReadV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsecuritygroupbusinessobjectpermissions/groupid/{groupid}/busobid/{busObId}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get Business Object permissions by Security Group',
                    'description': 'Operation to get specific Business Object permissions for a Security Group. ',
                    'operationId': 'Security_GetSecurityGroupBusinessObjectPermissionsByBusObIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'groupid',
                            'in': 'path',
                            'description': 'Specify the Security Group ID. ',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busObId',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.BusinessObjectPermission'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsecuritygroupbusinessobjectpermissions/groupid/{groupid}/busobid/{busObId}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get Business Object permissions by Security Group',
                    'description': 'Operation to get specific Business Object permissions for a Security Group. ',
                    'operationId': 'Security_GetSecurityGroupBusinessObjectPermissionsByBusObIdV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'groupid',
                            'in': 'path',
                            'description': 'Specify the Security Group ID. ',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busObId',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.GetSecurityGroupBusinessObjectPermissionsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsecuritygroupbusinessobjectpermissions/groupname/{groupname}/busobname/{busobname}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get Business Object permissions by Security Group',
                    'description': 'Operation to get specific Business Object permissions for a Security Group. ',
                    'operationId': 'Security_GetSecurityGroupBusinessObjectPermissionsByBusObNameV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'groupname',
                            'in': 'path',
                            'description': 'Specify the Security Group name. ',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.BusinessObjectPermission'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsecuritygroupbusinessobjectpermissions/groupname/{groupname}/busobname/{busobname}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get Business Object permissions by Security Group',
                    'description': 'Operation to get specific Business Object permissions for a Security Group. ',
                    'operationId': 'Security_GetSecurityGroupBusinessObjectPermissionsByBusObNameV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'groupname',
                            'in': 'path',
                            'description': 'Specify the Security Group name. ',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.GetSecurityGroupBusinessObjectPermissionsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsecuritygroupbusinessobjectpermissionsforcurrentuserbybusobid/busobid/{busObId}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get Business Object permission for current user',
                    'description': "Operation to get Business Object permissions for the currently logged-in user's Security Group.",
                    'operationId': 'Security_GetSecurityGroupBusinessObjectPermissionsForCurrentUserByBusObIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busObId',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.BusinessObjectPermission'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsecuritygroupbusinessobjectpermissionsforcurrentuserbybusobid/busobid/{busObId}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get Business Object permission for current user',
                    'description': "Operation to get Business Object permissions for the currently logged-in user's Security Group.",
                    'operationId': 'Security_GetSecurityGroupBusinessObjectPermissionsForCurrentUserByBusObIdV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busObId',
                            'in': 'path',
                            'description': 'Specify the Business Object ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.GetSecurityGroupBusinessObjectPermissionsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsecuritygroupbusinessobjectpermissionsforcurrentuserbybusobname/busobname/{busobname}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get Business Object permissions for current user',
                    'description': "Operation to get Business Object permissions for currently logged in user's Security Group.",
                    'operationId': 'Security_GetSecurityGroupBusinessObjectPermissionsForCurrentUserByBusObNameV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.BusinessObjectPermission'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsecuritygroupbusinessobjectpermissionsforcurrentuserbybusobname/busobname/{busobname}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get Business Object permissions for current user',
                    'description': "Operation to get Business Object permissions for currently logged in user's Security Group.",
                    'operationId': 'Security_GetSecurityGroupBusinessObjectPermissionsForCurrentUserByBusObNameV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'busobname',
                            'in': 'path',
                            'description': 'Specify the Business Object name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.GetSecurityGroupBusinessObjectPermissionsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsecuritygroupcategories': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get all Security Group categories',
                    'description': 'Operation to get IDs and names for all available Security Group categories. ',
                    'operationId': 'Security_GetSecurityGroupCategoriesV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.RightCategory'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsecuritygroupcategories': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get all Security Group categories',
                    'description': 'Operation to get IDs and names for all available Security Group categories. ',
                    'operationId': 'Security_GetSecurityGroupCategoriesV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.SecurityRightCategoriesResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsecuritygrouprights/groupid/{groupid}/categoryid/{categoryid}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get permissions for a Security Group by category',
                    'description': 'Operation to get permissions for a Security Group by category. To get Security Group IDs, use "Get all available Security Groups." To get Security Group category IDs, use "Get all Security Group categories."',
                    'operationId': 'Security_GetSecurityGroupRightsByGroupIdAndCategoryIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'groupid',
                            'in': 'path',
                            'description': 'Specify the Security Group ID',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'categoryid',
                            'in': 'path',
                            'description': 'Specify the Security Group category ID',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.Right'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsecuritygrouprights/groupid/{groupid}/categoryid/{categoryid}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get permissions for a Security Group by category',
                    'description': 'Operation to get permissions for a Security Group by category. To get Security Group IDs, use "Get all available Security Groups." To get Security Group category IDs, use "Get all Security Group categories."',
                    'operationId': 'Security_GetSecurityGroupRightsByGroupIdAndCategoryIdV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'groupid',
                            'in': 'path',
                            'description': 'Specify the Security Group ID',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'categoryid',
                            'in': 'path',
                            'description': 'Specify the Security Group category ID',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.SecurityRightsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsecuritygrouprights/groupname/{groupname}/categoryname/{categoryname}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get permissions for a Security Group by category',
                    'description': 'Operation to get permissions for a Security Group by category.',
                    'operationId': 'Security_GetSecurityGroupRightsByGroupNameAndCategoryNameV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'groupname',
                            'in': 'path',
                            'description': 'Specify the Security Group name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'categoryname',
                            'in': 'path',
                            'description': 'Specify the Security Group category name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.Right'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsecuritygrouprights/groupname/{groupname}/categoryname/{categoryname}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get permissions for a Security Group by category',
                    'description': 'Operation to get permissions for a Security Group by category.',
                    'operationId': 'Security_GetSecurityGroupRightsByGroupNameAndCategoryNameV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'groupname',
                            'in': 'path',
                            'description': 'Specify the Security Group name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'categoryname',
                            'in': 'path',
                            'description': 'Specify the Security Group category name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.SecurityRightsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsecuritygrouprightsforcurrentuserbycategoryid/categoryid/{categoryid}': {
                'get': {
                    'tags': ['Security'],
                    'summary': "Get current user's permissions by Security Group category by ID",
                    'description': 'Operation to get permissions for the current user\'s Security Group by category. To get Security Group category IDs, use "Get all Security Group categories."',
                    'operationId': 'Security_GetSecurityGroupRightsForCurrentUserByCategoryIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'categoryid',
                            'in': 'path',
                            'description': 'Specify the Security Group category ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.Right'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsecuritygrouprightsforcurrentuserbycategoryid/categoryid/{categoryid}': {
                'get': {
                    'tags': ['Security'],
                    'summary': "Get current user's permissions by Security Group category by ID",
                    'description': 'Operation to get permissions for the current user\'s Security Group by category. To get Security Group category IDs, use "Get all Security Group categories."',
                    'operationId': 'Security_GetSecurityGroupRightsForCurrentUserByCategoryIdV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'categoryid',
                            'in': 'path',
                            'description': 'Specify the Security Group category ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.SecurityRightsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsecuritygrouprightsforcurrentuserbycategoryname/categoryname/{categoryname}': {
                'get': {
                    'tags': ['Security'],
                    'summary': "Get current user's permissions by Security Group category by name",
                    'description': "Operation to get permissions for the current user's Security Group by category.",
                    'operationId': 'Security_GetSecurityGroupRightsForCurrentUserByCategoryNameV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'categoryname',
                            'in': 'path',
                            'description': 'Specify the Security Group category name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.Right'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsecuritygrouprightsforcurrentuserbycategoryname/categoryname/{categoryname}': {
                'get': {
                    'tags': ['Security'],
                    'summary': "Get current user's permissions by Security Group category by name",
                    'description': "Operation to get permissions for the current user's Security Group by category.",
                    'operationId': 'Security_GetSecurityGroupRightsForCurrentUserByCategoryNameV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'categoryname',
                            'in': 'path',
                            'description': 'Specify the Security Group category name.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.SecurityRightsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getsecuritygroups': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get all available Security Groups',
                    'description': 'Operation to get IDs, names, and descriptions for all available Security Groups.',
                    'operationId': 'Security_GetSecurityGroupsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.SecurityGroupResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getsecuritygroups': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get all available Security Groups',
                    'description': 'Operation to get IDs, names, and descriptions for all available Security Groups.',
                    'operationId': 'Security_GetSecurityGroupsV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.SecurityGroupV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getusersinsecuritygroup/groupid/{groupid}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get users in a Security Group',
                    'description': 'Operation to get the users in a specified Security Group. Use "Get all available Security Groups" to get Security Group record IDs. ',
                    'operationId': 'Security_GetUsersInSecurityGroupV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'groupid',
                            'in': 'path',
                            'description': 'Specify the Security Group ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                'type': 'array',
                                'items': {
                                    '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.User'
                                },
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getusersinsecuritygroup/groupid/{groupid}': {
                'get': {
                    'tags': ['Security'],
                    'summary': 'Get users in a Security Group',
                    'description': 'Operation to get the users in a specified Security Group. Use "Get all available Security Groups" to get Security Group record IDs. ',
                    'operationId': 'Security_GetUsersInSecurityGroupV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'groupid',
                            'in': 'path',
                            'description': 'Specify the Security Group ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserReadV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/serviceinfo': {
                'get': {
                    'tags': ['Service'],
                    'summary': 'Get information about the REST Api and CSM',
                    'description': 'Operation to get information about the REST API and CSM.  The response is latest REST API operation version, CSM version, and CSM system date and time.',
                    'operationId': 'Service_GetServiceInfoV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Core.ServiceInfoResponse'
                            },
                        }
                    },
                    'deprecated': False,
                }
            },
            '/api/V1/logout': {
                'delete': {
                    'tags': ['Service'],
                    'summary': 'Log out user by token',
                    'description': 'Operation that logs out the user referenced in the authentication token.',
                    'operationId': 'Service_LogoutUserV1',
                    'consumes': [],
                    'produces': [],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {'204': {'description': 'No Content'}},
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/addusertoteambybatch': {
                'post': {
                    'tags': ['Teams'],
                    'summary': 'Add users to a team by batch',
                    'description': 'Operation to add users to a Team by batch. To get internal IDs for users, use “Get User Information in a Batch.” To get a Team\'s internal ID, use "Get all available Teams."',
                    'operationId': 'Teams_AddUserToTeamByBatchV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object to specify a list of add user to team request objects.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamByBatchRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamByBatchResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/addusertoteam': {
                'post': {
                    'tags': ['Teams'],
                    'summary': 'Add a user to a team',
                    'description': 'Operation to add a user to a Team. To get the user\'s internal ID, use "Get a user by login ID" or "Get a user by public ID." To get a Team\'s internal ID, use "Get all available Teams."',
                    'operationId': 'Teams_AddUserToTeamV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [],
                    'parameters': [
                        {
                            'name': 'dataRequest',
                            'in': 'body',
                            'description': 'Request object to specify user and team values.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {'204': {'description': 'No Content'}},
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/addusertoteam': {
                'post': {
                    'tags': ['Teams'],
                    'summary': 'Add a user to a team',
                    'description': 'Operation to add a user to a Team. To get the user\'s internal ID, use "Get a user by login ID" or "Get a user by public ID." To get a Team\'s internal ID, use "Get all available Teams."',
                    'operationId': 'Teams_AddUserToTeamV2',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'dataRequest',
                            'in': 'body',
                            'description': 'Request object to specify user and team values.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.AddUserToTeamResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/deleteteam/{teamid}': {
                'delete': {
                    'tags': ['Teams'],
                    'summary': 'Delete a Team',
                    'description': 'Operation to delete a Team by Team ID.',
                    'operationId': 'Teams_DeleteTeamV1',
                    'consumes': [],
                    'produces': [],
                    'parameters': [
                        {
                            'name': 'teamid',
                            'in': 'path',
                            'description': 'Specify the Team ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {'204': {'description': 'No Content'}},
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getteams': {
                'get': {
                    'tags': ['Teams'],
                    'summary': 'Get all available Teams',
                    'description': 'Operation to get IDs and names for all available Teams.',
                    'operationId': 'Teams_GetTeamsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.TeamsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getteams': {
                'get': {
                    'tags': ['Teams'],
                    'summary': 'Get all available Teams',
                    'description': 'Operation to get IDs and names for all available Teams.',
                    'operationId': 'Teams_GetTeamsV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.TeamsV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getteam/{teamid}': {
                'get': {
                    'tags': ['Teams'],
                    'summary': 'Get a team by its TeamId',
                    'description': 'Operation to get Team Info for a  single Team using its Team ID. To get a Team\'s internal ID, use "Get all available Teams." Note that TeamType has two possible values, where TeamType = 0 for User (CSM Users), or TeamType = 1 for Workgroup (CSM Customers).',
                    'operationId': 'Teams_GetTeamV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'teamid',
                            'in': 'path',
                            'description': 'The Team ID of the Team to get.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.TeamResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getusersteams/userrecordid/{userRecordId}': {
                'get': {
                    'tags': ['Teams'],
                    'summary': 'Get Team assignments for a user',
                    'description': 'Operation to get Team assignments for a user. To get record IDs, use "Get a user by login ID" or "Get a user by public id."',
                    'operationId': 'Teams_GetUsersTeamsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'userRecordId',
                            'in': 'path',
                            'description': 'Specify the user record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.TeamsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getusersteams/userrecordid/{userRecordId}': {
                'get': {
                    'tags': ['Teams'],
                    'summary': 'Get Team assignments for a user',
                    'description': 'Operation to get Team assignments for a user. To get record IDs, use "Get a user by login ID" or "Get a user by public id."',
                    'operationId': 'Teams_GetUsersTeamsV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'userRecordId',
                            'in': 'path',
                            'description': 'Specify the user record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.TeamsV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getworkgroups': {
                'get': {
                    'tags': ['Teams'],
                    'summary': 'Get all available Workgroups',
                    'description': 'Operation to get IDs and names for all available Workgroups.',
                    'operationId': 'Teams_GetWorkgroupsV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.TeamsResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getworkgroups': {
                'get': {
                    'tags': ['Teams'],
                    'summary': 'Get all available Workgroups',
                    'description': 'Operation to get IDs and names for all available Workgroups.',
                    'operationId': 'Teams_GetWorkgroupsV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.TeamsV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/removeuserfromteam/teamid/{teamId}/userrecordid/{userrecordid}': {
                'delete': {
                    'tags': ['Teams'],
                    'summary': 'Operation to remove a User from a Team.',
                    'description': 'Operation to remove a User from a Team. To get the User\'s record ID, use "Get a User by login ID" or "Get a User by public ID." To get a Team\'s internal ID, use "Get all available Teams."',
                    'operationId': 'Teams_RemoveUserFromTeamV1',
                    'consumes': [],
                    'produces': [],
                    'parameters': [
                        {
                            'name': 'teamId',
                            'in': 'path',
                            'description': 'Specify the internal ID of the Team.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'userrecordid',
                            'in': 'path',
                            'description': 'Specify the record ID of the User to remove.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {'204': {'description': 'No Content'}},
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/removeuserfromteam/teamid/{teamId}/userrecordid/{userrecordid}': {
                'delete': {
                    'tags': ['Teams'],
                    'summary': 'Operation to remove a User from a Team.',
                    'description': 'Operation to remove a User from a Team. To get the User\'s record ID, use "Get a User by login ID" or "Get a User by public ID." To get a Team\'s internal ID, use "Get all available Teams."',
                    'operationId': 'Teams_RemoveUserFromTeamV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'teamId',
                            'in': 'path',
                            'description': 'Specify the internal ID of the Team.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'userrecordid',
                            'in': 'path',
                            'description': 'Specify the record ID of the User to remove.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.RemoveUserFromTeamResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/removecustomerfromworkgroup/workgroupid/{workgroupid}/customerrecordid/{customerrecordid}': {
                'delete': {
                    'tags': ['Teams'],
                    'summary': 'Remove a customer from a Workgroup',
                    'description': 'Operation to remove a Customer from a Workgroup.  To remove, specify the Workgroup ID and the Customer Record ID.',
                    'operationId': 'Teams_RemoveCustomerFromWorkgroupV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'workgroupid',
                            'in': 'path',
                            'description': 'Specify the Workgroup ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'customerrecordid',
                            'in': 'path',
                            'description': 'Specify the Customer record ID.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.RemoveCustomerFromWorkgroupResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/saveteam': {
                'post': {
                    'tags': ['Teams'],
                    'summary': 'Create or update a team',
                    'description': 'Operation to create or update a Team or Workgroup. ',
                    'operationId': 'Teams_SaveTeamV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object to create Teams or Workgroups. To create a Team, use teamType and teamName. To update a team, use teamID. Team type values must be User or CustomerWorkgroup. The teamType cannot be changed for existing Teams or Workgroups.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.TeamSaveRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.TeamSaveResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/saveteammember': {
                'post': {
                    'tags': ['Teams'],
                    'summary': 'Add or Update a team member',
                    'description': "Operation to add or update a Team Member. To add or update, specify User ID, Team ID, and if Team Manager.   Optionally, set the Team as the User's default Team.",
                    'operationId': 'Teams_SaveTeamMemberV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': "The request object to add or update a Team Member. User recID specifies the User to add or update. TeamId specifies the Team to update. IsTeamManager specifies whether the User is a Team Manager, and SetAsDefaultTeam specifies whether to set this Team as the User's default team. UserRecId, TeamId, and IsTeamManager are required.",
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.SaveTeamMemberRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.SaveTeamMemberResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/saveworkgroupmember': {
                'post': {
                    'tags': ['Teams'],
                    'summary': 'Save the membership status of a Workgroup member.',
                    'description': 'Operation to add or update a Workgroup Member.  To add or update, specify Customer Record ID, Workgroup ID, and if Workgroup Manager.',
                    'operationId': 'Teams_SaveWorkgroupMemberV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'The request object to add or update a Workgroup Member. CustomerRecordId specifies the Customer to add or update. WorkgroupId specifies the Workgroup to update. CustomerIsWorkgroupManager specifies whether the Customer is a Workgroup Manager.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.SaveWorkgroupMemberRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Teams.SaveWorkgroupMemberResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/deleteuserbatch': {
                'post': {
                    'tags': ['Users'],
                    'summary': 'Delete a batch of users',
                    'description': 'Operation to delete a batch of users. To get record IDs, use "Get a user by login ID" or "Get a user by public id."',
                    'operationId': 'Users_DeleteUserBatchV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object listing record IDs for users to be deleted and an error flag.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserBatchDeleteRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserBatchDeleteResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/deleteuserbatch': {
                'post': {
                    'tags': ['Users'],
                    'summary': 'Delete a batch of users',
                    'description': 'Operation to delete a batch of users. To get record IDs, use "Get a user by login ID" or "Get a user by public id."',
                    'operationId': 'Users_DeleteUserBatchV2',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object listing record IDs for users to be deleted and an error flag.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserBatchDeleteRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserBatchDeleteV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/deleteuser/userrecordid/{userrecordid}': {
                'delete': {
                    'tags': ['Users'],
                    'summary': 'Delete a user by record ID',
                    'description': 'Operation to delete a user by record ID. To get record IDs, use "Get a user by login ID" or "Get a user by public id."',
                    'operationId': 'Users_DeleteUserV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'userrecordid',
                            'in': 'path',
                            'description': 'Specify the record ID of the user you want to delete',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserDeleteResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/deleteuser/userrecordid/{userrecordid}': {
                'delete': {
                    'tags': ['Users'],
                    'summary': 'Delete a user by record ID',
                    'description': 'Operation to delete a user by record ID. To get record IDs, use "Get a user by login ID" or "Get a user by public id."',
                    'operationId': 'Users_DeleteUserV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'userrecordid',
                            'in': 'path',
                            'description': 'Specify the record ID of the user you want to delete',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserDeleteV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getlistofusers': {
                'get': {
                    'tags': ['Users'],
                    'summary': 'Get a list of all system users.',
                    'description': 'Operation to get a list of all system users.',
                    'operationId': 'Users_GetListOfUsers',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'loginidfilter',
                            'in': 'query',
                            'description': 'Specify the login ID filter to apply to the users list.',
                            'required': True,
                            'type': 'string',
                            'enum': ['Internal', 'Windows', 'Both'],
                        },
                        {
                            'name': 'stoponerror',
                            'in': 'query',
                            'description': 'Specify whether the operation is interrupted if retrieving any user causes an error.',
                            'required': False,
                            'type': 'boolean',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserListResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getuserbatch': {
                'post': {
                    'tags': ['Users'],
                    'summary': 'Get user information in a batch',
                    'description': 'Operation to get user information in a batch. To get record IDs, use "Get a user by login ID" or "Get a user by public id."',
                    'operationId': 'Users_GetUserBatchV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object that lists user record IDs or public IDs of users and an error flag.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserBatchReadRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserBatchReadResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getuserbyloginid/loginid/{loginid}': {
                'get': {
                    'tags': ['Users'],
                    'summary': 'Get a user by login ID',
                    'description': 'Operation to get detailed user information by login ID. Use to get user record IDs and account settings, for example. This operation has been deprecated by a V2 operation of the same name, but with query string parameters.',
                    'operationId': 'Users_GetUserByLoginIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'loginid',
                            'in': 'path',
                            'description': "Specify the user's login ID.",
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.User'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getuserbyloginid': {
                'get': {
                    'tags': ['Users'],
                    'summary': 'Get a user by login ID and login ID type',
                    'description': 'Operation to get detailed user information by login ID. Use to get user record IDs and account settings, for example.',
                    'operationId': 'Users_GetUserByLoginIdV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'loginid',
                            'in': 'query',
                            'description': "Specify the user's login ID.",
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'loginidtype',
                            'in': 'query',
                            'description': 'Specify the login ID type.',
                            'required': True,
                            'type': 'string',
                            'enum': ['Internal', 'Windows'],
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.User'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V3/getuserbyloginid': {
                'get': {
                    'tags': ['Users'],
                    'summary': 'Get a user by login ID and login ID type',
                    'description': 'Operation to get detailed user information by login ID. Use to get user record IDs and account settings, for example.',
                    'operationId': 'Users_GetUserByLoginIdV3',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'loginid',
                            'in': 'query',
                            'description': "Specify the user's login ID.",
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'loginidtype',
                            'in': 'query',
                            'description': 'Specify the login ID type.',
                            'required': True,
                            'type': 'string',
                            'enum': ['Internal', 'Windows'],
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserV2'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getuserbypublicid/publicid/{publicid}': {
                'get': {
                    'tags': ['Users'],
                    'summary': 'Get a user by public ID',
                    'description': 'Operation to get detailed user information by public ID. Use to get user record IDs and account settings, for example.',
                    'operationId': 'Users_GetUserByPublicIdV1',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': "Specify the user's public ID.",
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserReadResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/getuserbypublicid/publicid/{publicid}': {
                'get': {
                    'tags': ['Users'],
                    'summary': 'Get a user by public ID',
                    'description': 'Operation to get detailed user information by public ID. Use to get user record IDs and account settings, for example.',
                    'operationId': 'Users_GetUserByPublicIdV2',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'publicid',
                            'in': 'path',
                            'description': "Specify the user's public ID.",
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserReadV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/getuserbyrecid/recid/{recid}': {
                'get': {
                    'tags': ['Users'],
                    'summary': 'Get a user by record ID',
                    'description': 'Operation to get detailed user information by record ID.  Use to get user public IDs and account settings, for example.',
                    'operationId': 'Users_GetUserByRecId',
                    'consumes': [],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'recid',
                            'in': 'path',
                            'description': "Specify the user's record ID",
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserV2'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/saveuserbatch': {
                'post': {
                    'tags': ['Users'],
                    'summary': 'Create or update users in a batch',
                    'description': 'Operation to create or update users in a batch. To update, specify record ID. To create, leave record ID empty.',
                    'operationId': 'Users_SaveUserBatchV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object listing user record IDs and an error flag.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserBatchSaveRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserBatchSaveResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/saveuserbatch': {
                'post': {
                    'tags': ['Users'],
                    'summary': 'Create or update users in a batch',
                    'description': 'Operation to create or update users in a batch. To update, specify record ID. To create, leave record ID empty.',
                    'operationId': 'Users_SaveUserBatchV2',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object listing user record IDs and an error flag.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserBatchSaveV2Request'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserBatchSaveV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V1/saveuser': {
                'post': {
                    'tags': ['Users'],
                    'summary': 'Create or update a user',
                    'description': 'Operation to create or update a user.  The response is a collection because if you use a public ID, more than one user could be updated since public IDs may not be unique. ',
                    'operationId': 'Users_SaveUserV1',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object to specify user parameters and fields with values to be created or updated. The loginId and either the Business Object record ID or Public ID are required.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserSaveRequest'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserSaveResponse'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/api/V2/saveuser': {
                'post': {
                    'tags': ['Users'],
                    'summary': 'Create or update a user',
                    'description': 'Operation to create or update a user.  The response is a collection because if you use a public ID, more than one user could be updated since public IDs may not be unique. ',
                    'operationId': 'Users_SaveUserV2',
                    'consumes': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                        'application/x-www-form-urlencoded',
                    ],
                    'produces': [
                        'application/json',
                        'text/json',
                        'application/xml',
                        'text/xml',
                    ],
                    'parameters': [
                        {
                            'name': 'request',
                            'in': 'body',
                            'description': 'Request object to specify user parameters and fields with values to be created or updated. The loginId and either the Business Object record ID or Public ID are required.',
                            'required': True,
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserSaveV2Request'
                            },
                        },
                        {
                            'name': 'lang',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'locale',
                            'in': 'query',
                            'description': 'Optional parameter to specify the culture of the request. Either "lang" or "locale" can be used to specify the culture.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Users.UserSaveV2Response'
                            },
                        }
                    },
                    'deprecated': False,
                    'security': [],
                }
            },
            '/token': {
                'post': {
                    'tags': ['Service'],
                    'summary': 'Get an access token',
                    'description': 'Operation to request an access token for one of the following authentication modes. Or, you can request an access token using a refresh token. An API client key is required in both cases, and the authentication mode you use must be the mode used by the CSM Browser Client. </br>\nInternal - Use a CSM username and password. If no other mode is specified, Internal mode is used.</br>\nWindows - Uses the server variable LOGON_USER to attempt to find a CSM user.  You can also use domain\\username and password.</br>\nLDAP - Uses the LDAP settings configured for CSM and the server variable LOGON_USER to attempt to find a CSM user. You can also use domain\\username and password.</br>\nSAML - Uses the SAML settings configured for CSM to validate credentials and find the CSM user.</br>\nAuto - Uses the enabled authentication types configured for CSM.',
                    'operationId': 'Service_Token',
                    'consumes': ['application/x-www-form-urlencoded'],
                    'parameters': [
                        {
                            'name': 'grant_type',
                            'in': 'formData',
                            'description': 'The type of grant being requested: password or refresh_token.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'client_id',
                            'in': 'formData',
                            'description': 'The API client key for the client making the token request.',
                            'required': True,
                            'type': 'string',
                        },
                        {
                            'name': 'client_secret',
                            'in': 'formData',
                            'description': 'The API client secret for the native client making the token request.  This is only required for native clients.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'username',
                            'in': 'formData',
                            'description': 'Specify the login ID for the CSM user who will be granted the access token. ',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'password',
                            'in': 'formData',
                            'description': 'Specify the password assigned to the login ID.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'refresh_token',
                            'in': 'formData',
                            'description': 'Specify the refresh token used to grant another access token.',
                            'required': False,
                            'type': 'string',
                        },
                        {
                            'name': 'auth_mode',
                            'in': 'query',
                            'description': 'Specify the Authentication Mode to use for requesting an access token.',
                            'required': False,
                            'type': 'string',
                            'enum': ['Internal', 'Windows', 'LDAP', 'SAML', 'Auto'],
                        },
                        {
                            'name': 'site_name',
                            'in': 'query',
                            'description': 'If for portal specify the Site name to use for requesting an access token.',
                            'required': False,
                            'type': 'string',
                        },
                    ],
                    'responses': {
                        '200': {
                            'description': 'OK',
                            'schema': {
                                '$ref': '#/definitions/Trebuchet.WebApi.DataContracts.Security.TokenResponse'
                            },
                        }
                    },
                    'deprecated': False,
                }
            },
        },
        schemes=['http'],
        swagger='2.0',
        tags=[
            {'name': 'Searches', 'description': 'Perform search operations'},
            {'name': 'Service', 'description': 'General operations for the service'},
            {
                'name': 'BusinessObject',
                'description': 'Perform operations on Business Objects',
            },
            {'name': 'Security', 'description': 'Perform security-related operations'},
            {'name': 'Core', 'description': 'Perform operations on the Core Framework'},
            {
                'name': 'Forms',
                'description': 'Perform operations with Business Object Forms',
            },
            {'name': 'Sites', 'description': 'Perform operations on Portal Sites'},
            {
                'name': 'OneStepActions',
                'description': 'Perform operations on One-Step Actions',
            },
            {'name': 'Queues', 'description': 'Perform operations on Queues'},
            {'name': 'Teams', 'description': 'Perform operations on Teams'},
            {'name': 'Users', 'description': 'Perform operations on Users'},
            {
                'name': 'Named Objects',
                'description': 'Perform actions against Named Objects',
            },
            {
                'name': 'Canonical',
                'description': 'Perform operations against Canonical objects',
            },
            {
                'name': 'Approval',
                'description': 'Perform operations on Approval Objects',
            },
            {
                'name': 'Lifecycle',
                'description': 'Perform Business Object Lifecycle operations',
            },
        ],
    )


import cherwell_pydantic_api.types as ct
from cherwell_pydantic_api.types import CherwellObjectID
