
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/mitol/hubspot_api:mitol-hubspot-api

from setuptools import setup

setup(**{
    'authors': [
        'MIT Office of Open Learning <mitx-devops@mit.edu>',
    ],
    'classifiers': [
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    'description': 'Django application for Hubspot API integration',
    'install_requires': (
        'django<4.0,>=2.2.12',
        'djangorestframework>=3.0.0',
        'factory-boy~=3.2',
        'hubspot-api-client==6.1.0',
        'mitol-django-common~=2.7.0',
        'pytest==6.1.2',
        'setuptools',
        'urllib3>=1.26.5',
    ),
    'license': 'BSD 3-Clause License',
    'long_description': """mitol-django-hubspot-api
---

This is the Open Learning Hubspot API integration app. It provides helper functions for Hubspot CRM API calls:

- CRUD functions for custom properties and property groups 
- CRUD functions for deals, line items, products, and contacts
- Search/retrieve specific objects or lists of objects of a certain type

### Getting started

`pip install mitol-django-hubspot-api`

Add the hubspot app:

```python
INSTALLED_APPS = [
    ...
    "mitol.hubspot_api.apps.HubspotApp",
]
```

### Settings

#### Hubspot app settings

All settings for the `mitol-django-hubspot-api` app are namespaced in django settings with `MITOL_HUBSPOT_API` prefix.

- `MITOL_HUBSPOT_API_PRIVATE_TOKEN` - the private app token to be used for authentication (required)
- `MITOL_HUBSPOT_API_RETRIES` - the number of times to retry API calls on failures (default=3)
- `MITOL_HUBSPOT_API_ID_PREFIX` - a prefix used for generating custom unique object ids (default="app")

### Usage

#### Instantiate an API client to make custom hubspot requests

```python
from mitol.hubspot_api.api import HubspotApi, HubspotObjectType

client = HubspotApi()
client.crm.objects.basic_api.update(
    simple_public_object_input=input_body,
    object_id=123,
    object_type=HubspotObjectType.DEALS.value,
)
```

#### Use helper functions to make common hubspot requests
```python
from mitol.hubspot_api.api import find_product

hubspot_product = find_product("Product #1", price="123.99")
```
""",
    'long_description_content_type': 'text/markdown',
    'name': 'mitol-django-hubspot-api',
    'namespace_packages': (
        'mitol',
    ),
    'package_data': {
        'mitol.hubspot_api': (
            'CHANGELOG.md',
            'README.md',
            'py.typed',
        ),
    },
    'packages': (
        'mitol',
        'mitol.hubspot_api',
        'mitol.hubspot_api.migrations',
        'mitol.hubspot_api.settings',
    ),
    'python_requires': '>=3.7',
    'version': '1.1.0',
    'zip_safe': True,
})
