# pylint: disable=C0111,R0902,R0904,R0912,R0913,R0915,E1101
# Smartsheet Python SDK.
#
# Copyright 2018 Smartsheet.com, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from __future__ import absolute_import

from ..types import EnumeratedValue, Number, String, json
from ..util import deserialize, serialize
from .enums import CellLinkStatus


class CellLink:

    """Smartsheet CellLink data model."""

    def __init__(self, props=None, base_obj=None):
        """Initialize the CellLink model."""
        self._base = None
        if base_obj is not None:
            self._base = base_obj

        self._column_id = Number()
        self._row_id = Number()
        self._sheet_id = Number()
        self._sheet_name = String()
        self._status = EnumeratedValue(CellLinkStatus)

        if props:
            deserialize(self, props)

    @property
    def column_id(self):
        return self._column_id.value

    @column_id.setter
    def column_id(self, value):
        self._column_id.value = value

    @property
    def row_id(self):
        return self._row_id.value

    @row_id.setter
    def row_id(self, value):
        self._row_id.value = value

    @property
    def sheet_id(self):
        return self._sheet_id.value

    @sheet_id.setter
    def sheet_id(self, value):
        self._sheet_id.value = value

    @property
    def sheet_name(self):
        return self._sheet_name.value

    @sheet_name.setter
    def sheet_name(self, value):
        self._sheet_name.value = value

    @property
    def status(self):
        return self._status

    @status.setter
    def status(self, value):
        self._status.set(value)

    def to_dict(self):
        return serialize(self)

    def to_json(self):
        return json.dumps(self.to_dict())

    def __str__(self):
        return self.to_json()
