# pylint: disable=C0111,R0902,R0904,R0912,R0913,R0915,E1101
# Smartsheet Python SDK.
#
# Copyright 2017 Smartsheet.com, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from __future__ import absolute_import

from ..types import Number, String, TypedObject, json
from ..util import deserialize, serialize
from .error_result import ErrorResult


class ImageUrl:

    """Smartsheet ImageUrl data model."""

    def __init__(self, props=None, base_obj=None):
        """Initialize the ImageUrl model."""
        self._base = None
        if base_obj is not None:
            self._base = base_obj

        self._error = TypedObject(ErrorResult)
        self._height = Number()
        self._image_id = String()
        self._url = String()
        self._width = Number()

        if props:
            deserialize(self, props)

    @property
    def error(self):
        return self._error.value

    @error.setter
    def error(self, value):
        self._error.value = value

    @property
    def height(self):
        return self._height.value

    @height.setter
    def height(self, value):
        self._height.value = value

    @property
    def image_id(self):
        return self._image_id.value

    @image_id.setter
    def image_id(self, value):
        self._image_id.value = value

    @property
    def url(self):
        return self._url.value

    @url.setter
    def url(self, value):
        self._url.value = value

    @property
    def width(self):
        return self._width.value

    @width.setter
    def width(self, value):
        self._width.value = value

    def to_dict(self):
        return serialize(self)

    def to_json(self):
        return json.dumps(self.to_dict())

    def __str__(self):
        return self.to_json()
