"use strict";
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElastiCacheMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class ElastiCacheMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CPUUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static freeableMemoryAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'FreeableMemory',
            dimensions,
            statistic: 'Average',
        };
    }
    static swapUsageAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'SwapUsage',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkBytesInAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'NetworkBytesIn',
            dimensions,
            statistic: 'Average',
        };
    }
    static networkBytesOutAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'NetworkBytesOut',
            dimensions,
            statistic: 'Average',
        };
    }
    static currConnectionsSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CurrConnections',
            dimensions,
            statistic: 'Sum',
        };
    }
    static evictionsSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'Evictions',
            dimensions,
            statistic: 'Sum',
        };
    }
    static reclaimedSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'Reclaimed',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CacheHits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CacheMisses',
            dimensions,
            statistic: 'Sum',
        };
    }
    static replicationBytesSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'ReplicationBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static replicationLagAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'ReplicationLag',
            dimensions,
            statistic: 'Average',
        };
    }
    static bytesUsedForCacheSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'BytesUsedForCache',
            dimensions,
            statistic: 'Sum',
        };
    }
    static currItemsSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CurrItems',
            dimensions,
            statistic: 'Sum',
        };
    }
    static casHitsSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CasHits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static casMissesSum(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'CasMisses',
            dimensions,
            statistic: 'Sum',
        };
    }
    static globalDatastoreReplicationLagAverage(dimensions) {
        return {
            namespace: 'AWS/ElastiCache',
            metricName: 'GlobalDatastoreReplicationLag',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.ElastiCacheMetrics = ElastiCacheMetrics;
//# sourceMappingURL=data:application/json;base64,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