/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import java.text.MessageFormat;
import java.util.Date;

public class TdgssUtil {
    private static final char[] HEXMAP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String dump(String string, byte[] byArray) {
        if (byArray == null) {
            return TdgssUtil.buildMsg(string + '\n' + "*** Nothing to dump: The data to dump is null");
        }
        return TdgssUtil.dump(string, byArray, 0, byArray.length);
    }

    public static String dump(String string, byte[] byArray, int n) {
        if (byArray == null) {
            return TdgssUtil.buildMsg(string + '\n' + "*** Nothing to dump: The data to dump is null");
        }
        return TdgssUtil.dump(string, byArray, n, byArray.length - n);
    }

    public static String dump(String string, byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0) {
            return TdgssUtil.buildMsg(string + '\n' + "*** Nothing to dump: The data to dump is either null or zero length");
        }
        if (n < 0 || n >= byArray.length) {
            return TdgssUtil.buildMsg(string + '\n' + "*** Can't dump: offset (" + n + ") must be greater than zero and less than the length of the data (" + byArray.length + ")");
        }
        if (n2 <= 0) {
            return TdgssUtil.buildMsg(string + '\n' + "*** Can't dump: the length (" + n2 + ") must not be less than or equal to 0");
        }
        if (n + n2 > byArray.length) {
            return TdgssUtil.buildMsg(string + '\n' + "*** Can't dump: the sum of the offset (" + n + ") and length (" + n2 + ") must not be greater than the length of the data (" + byArray.length + ")");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n >> 4 << 4;
        int n4 = n + n2;
        for (int i = n3; i < n4; i += 16) {
            int n5;
            int n6;
            if (i != n3) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(i == n3 ? TdgssUtil.toHex(n) : TdgssUtil.toHex(i));
            stringBuffer.append(": ");
            for (n6 = i; n6 < i + 16; ++n6) {
                if (n6 != i && n6 % 8 == 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(' ');
                stringBuffer.append(n6 < n4 && n6 >= n ? TdgssUtil.toHex(byArray[n6]) : "  ");
            }
            stringBuffer.append("  ");
            n6 = 0;
            if (i == n3) {
                n6 = n;
                for (n5 = i; n5 < n; ++n5) {
                    stringBuffer.append(' ');
                }
            } else {
                n6 = i;
            }
            stringBuffer.append("|");
            for (n5 = n6; n5 < i + 16; ++n5) {
                if (n5 >= n4) continue;
                stringBuffer.append(byArray[n5] < 32 || byArray[n5] > 126 ? (char)'.' : (char)byArray[n5]);
            }
            stringBuffer.append("|");
        }
        return TdgssUtil.buildMsg(string + '\n' + stringBuffer.toString());
    }

    public static String buildMsg(String string) {
        return TdgssUtil.buildMsg(string, new Object[0]);
    }

    public static String buildMsg(String string, Object[] objectArray) {
        Date date = new Date();
        String string2 = objectArray == null || objectArray.length == 0 ? string : MessageFormat.format(string, objectArray);
        return string2;
    }

    public static String toHex(byte by) {
        return TdgssUtil.toHex(by, 2);
    }

    public static String toHex(int n) {
        return TdgssUtil.toHex(n, 8);
    }

    public static String toHex(int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = cArray.length - 1; i >= 0; --i) {
            int n3 = n & 0xF;
            cArray[i] = HEXMAP[n3];
            n >>= 4;
        }
        return new String(cArray);
    }

    public static StackTraceElement getCaller() {
        Throwable throwable = new Throwable("");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length <= 2) {
            throw new IllegalStateException();
        }
        String string = stackTraceElementArray[1].getClassName();
        for (int i = 2; i < stackTraceElementArray.length; ++i) {
            if (stackTraceElementArray[i].getClassName().equals(string)) continue;
            return stackTraceElementArray[i];
        }
        throw new IllegalStateException();
    }
}

