import { Project, ProjectOptions } from "projen";
import { DocumentationFormatConfig } from "../client-config";
import { DocumentationFormat } from "../languages";
import { GeneratedHtml2Docs } from "./components/docs/generated-html2-docs";
import { GeneratedMarkdownDocs } from "./components/docs/generated-markdown-docs";
import { GeneratedPlantUmlDocs } from "./components/docs/generated-plantuml-docs";
/**
 * Configuration for the OpenAPI docs project
 */
export interface DocsProjectOptions extends ProjectOptions {
    /**
     * The absolute path to the OpenAPI specification (spec.yaml) from which to generate docs
     */
    readonly specPath: string;
    /**
     * The formats to generate documentation in
     */
    readonly formatConfigs: DocumentationFormatConfig[];
}
/**
 * Project containing generated OpenApi docs
 */
export declare class DocsProject extends Project {
    constructor(options: DocsProjectOptions);
    /**
     * Generates the docs in the given format
     */
    generateDocs(format: DocumentationFormat, specPath: string): GeneratedHtml2Docs | GeneratedMarkdownDocs | GeneratedPlantUmlDocs;
}
