/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { PythonProjectOptions } from "projen/lib/python";
import { OpenApiGatewayPythonProject, OpenApiGatewayPythonProjectOptions } from "./open-api-gateway-python-project";
import { SmithyApiGatewayProjectOptions } from "./types";
/**
 * Configuration for the SmithyApiGatewayPythonProject
 */
export interface SmithyApiGatewayPythonProjectOptions extends PythonProjectOptions, SmithyApiGatewayProjectOptions {
}
/**
 * Synthesizes a Python Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-py
 */
export declare class SmithyApiGatewayPythonProject extends OpenApiGatewayPythonProject {
    /**
     * The directory in which the smithy model files reside
     */
    readonly modelDir: string;
    constructor(options: SmithyApiGatewayPythonProjectOptions);
    protected preConstruct(options: OpenApiGatewayPythonProjectOptions): OpenApiGatewayPythonProjectOptions;
}
