"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParsedSpec = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const util_1 = require("projen/lib/util");
/**
 * Component for parsing the yaml OpenAPI spec as a single json object, resolving references etc.
 */
class ParsedSpec extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    static parse(specPath, outputPath) {
        // Parse the spec and write to the target output path
        util_1.exec(`./parse-openapi-spec --specPath=${specPath} --outputPath=${outputPath}`, {
            cwd: path.resolve(__dirname, "..", "..", "..", "..", "scripts", "parser"),
        });
    }
    synthesize() {
        super.synthesize();
        ParsedSpec.parse(this.options.specPath, this.options.outputPath);
    }
}
exports.ParsedSpec = ParsedSpec;
//# sourceMappingURL=data:application/json;base64,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