"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckProps = void 0;
function CheckProps(propsObject) {
    let errorMessages = '';
    let errorFound = false;
    if (propsObject.dynamoTableProps && propsObject.existingTableObj) {
        errorMessages += 'Error - Either provide existingTableObj or dynamoTableProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingStreamObj && propsObject.kinesisStreamProps) {
        errorMessages += 'Error - Either provide existingStreamObj or kinesisStreamProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingLambdaObj && propsObject.lambdaFunctionProps) {
        errorMessages += 'Error - Either provide lambdaFunctionProps or existingLambdaObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingQueueObj && propsObject.queueProps) {
        errorMessages += 'Error - Either provide queueProps or existingQueueObj, but not both.\n';
        errorFound = true;
    }
    if (((propsObject === null || propsObject === void 0 ? void 0 : propsObject.deployDeadLetterQueue) === false) && propsObject.deadLetterQueueProps) {
        errorMessages += 'Error - If deployDeadLetterQueue is false then deadLetterQueueProps cannot be specified.\n';
        errorFound = true;
    }
    if (propsObject.existingMediaStoreContainerObj && propsObject.mediaStoreContainerProps) {
        errorMessages += 'Error - Either provide mediaStoreContainerProps or existingMediaStoreContainerObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingBucketObj && propsObject.bucketProps) {
        errorMessages += 'Error - Either provide bucketProps or existingBucketObj, but not both.\n';
        errorFound = true;
    }
    if ((propsObject.topicProps || propsObject.topicsProps) && propsObject.existingTopicObj) {
        errorMessages += 'Error - Either provide topicProps or existingTopicObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.glueJobProps && propsObject.existingGlueJob) {
        errorMessages += 'Error - Either provide glueJobProps or existingGlueJob, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingSagemakerEndpointObj && propsObject.endpointProps) {
        errorMessages += 'Error - Either provide endpointProps or existingSagemakerEndpointObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingSecretObj && propsObject.secretProps) {
        errorMessages += 'Error - Either provide secretProps or existingSecretObj, but not both.\n';
        errorFound = true;
    }
    // if (deployVpc || vpcProp) and existingVpc
    if ((propsObject.deployVpc || propsObject.vpcProps) && propsObject.existingVpc) {
        errorMessages += 'Error - Either provide an existingVpc or some combination of deployVpc and vpcProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.encryptionKey && propsObject.encryptionKeyProps) {
        errorMessages += 'Error - Either provide encryptionKey or encryptionKeyProps, but not both.\n';
        errorFound = true;
    }
    if (errorFound) {
        throw new Error(errorMessages);
    }
}
exports.CheckProps = CheckProps;
//# sourceMappingURL=data:application/json;base64,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