"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultSagemakerEndpointProps = exports.DefaultSagemakerEndpointConfigProps = exports.DefaultSagemakerModelProps = exports.DefaultSagemakerNotebookProps = void 0;
function DefaultSagemakerNotebookProps(roleArn, kmsKeyId, subnetId, securityGroupIds) {
    return {
        instanceType: 'ml.t2.medium',
        roleArn,
        kmsKeyId,
        ...(subnetId && { subnetId, directInternetAccess: 'Disabled' }),
        ...(securityGroupIds && { securityGroupIds }),
    };
}
exports.DefaultSagemakerNotebookProps = DefaultSagemakerNotebookProps;
function DefaultSagemakerModelProps(executionRoleArn, primaryContainer, vpcConfig) {
    return {
        executionRoleArn,
        primaryContainer,
        ...(vpcConfig && { vpcConfig }),
    };
}
exports.DefaultSagemakerModelProps = DefaultSagemakerModelProps;
function DefaultSagemakerEndpointConfigProps(modelName, kmsKeyId) {
    return {
        productionVariants: [
            {
                modelName,
                initialInstanceCount: 1,
                initialVariantWeight: 1.0,
                instanceType: 'ml.m4.xlarge',
                variantName: 'AllTraffic',
            },
        ],
        ...(kmsKeyId && { kmsKeyId }),
    };
}
exports.DefaultSagemakerEndpointConfigProps = DefaultSagemakerEndpointConfigProps;
function DefaultSagemakerEndpointProps(endpointConfigName) {
    return {
        endpointConfigName,
    };
}
exports.DefaultSagemakerEndpointProps = DefaultSagemakerEndpointProps;
//# sourceMappingURL=data:application/json;base64,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