"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildSecurityGroup = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
function buildSecurityGroup(scope, name, props, ingressRules, egressRules) {
    const newSecurityGroup = new ec2.SecurityGroup(scope, `${name}-security-group`, props);
    ingressRules.forEach(rule => {
        newSecurityGroup.addIngressRule(rule.peer, rule.connection, rule.description, rule.remoteRule);
    });
    egressRules.forEach(rule => {
        newSecurityGroup.addEgressRule(rule.peer, rule.connection, rule.description, rule.remoteRule);
    });
    const cfnSecurityGroup = newSecurityGroup.node.findChild("Resource");
    cfnSecurityGroup.cfnOptions.metadata = {
        cfn_nag: {
            rules_to_suppress: [
                {
                    id: "W5",
                    reason: "Egress of 0.0.0.0/0 is default and generally considered OK",
                },
                {
                    id: "W40",
                    reason: "Egress IPProtocol of -1 is default and generally considered OK",
                },
            ],
        },
    };
    return newSecurityGroup;
}
exports.buildSecurityGroup = buildSecurityGroup;
//# sourceMappingURL=data:application/json;base64,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