"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const kinesisanalytics = require("@aws-cdk/aws-kinesisanalytics");
const defaults = require("../index");
const utils_1 = require("../lib/utils");
require("@aws-cdk/assert/jest");
test('snapshot test kinesisanalytics default params', () => {
    const stack = new core_1.Stack();
    new kinesisanalytics.CfnApplication(stack, 'KinesisAnalytics', defaults.DefaultCfnApplicationProps);
    expect(assert_1.SynthUtils.toCloudFormation(stack)).toMatchSnapshot();
});
test('test kinesisanalytics override inputProperty', () => {
    const stack = new core_1.Stack();
    const inputProperty = {
        inputSchema: {
            recordColumns: [{ name: 'x', sqlType: 'y' }],
            recordFormat: { recordFormatType: 'csv' }
        },
        namePrefix: 'zzz'
    };
    const defaultProps = defaults.DefaultCfnApplicationProps;
    const inProps = {
        inputs: [inputProperty]
    };
    const outProps = utils_1.overrideProps(defaultProps, inProps);
    new kinesisanalytics.CfnApplication(stack, 'KinesisAnalytics', outProps);
    expect(stack).toHaveResource("AWS::KinesisAnalytics::Application", {
        Inputs: [
            {
                InputSchema: {
                    RecordColumns: [
                        {
                            Name: "x",
                            SqlType: "y"
                        }
                    ],
                    RecordFormat: {
                        RecordFormatType: "csv"
                    }
                },
                NamePrefix: "zzz"
            }
        ]
    });
});
//# sourceMappingURL=data:application/json;base64,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