#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pytools',
 'pytools.api',
 'pytools.api.doc',
 'pytools.data',
 'pytools.expression',
 'pytools.expression.atomic',
 'pytools.expression.base',
 'pytools.expression.composite',
 'pytools.expression.composite.base',
 'pytools.expression.formatter',
 'pytools.expression.operator',
 'pytools.fit',
 'pytools.meta',
 'pytools.parallelization',
 'pytools.sphinx',
 'pytools.text',
 'pytools.viz',
 'pytools.viz.color',
 'pytools.viz.dendrogram',
 'pytools.viz.dendrogram.base',
 'pytools.viz.distribution',
 'pytools.viz.distribution.base',
 'pytools.viz.matrix',
 'pytools.viz.matrix.base',
 'pytools.viz.util']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['joblib         ~=0.14,<1.1a',
 'matplotlib     ==3.*',
 'numpy          >=1.16,<1.21a',
 'pandas         >=0.24,<2a',
 'scipy          ~=1.2',
 'typing_inspect >=0.4,<0.8a']

extras_require = \
{'docs': ['sphinx == 3.4.*',
          'sphinx-autodoc-typehints == 1.11.*',
          'pydata-sphinx-theme == 0.4.*',
          'jinja2 ~= 2.11',
          'nbsphinx == 0.7.*',
          'jupyter == 1.*',
          'docutils == 0.16.*',
          'xlrd ~= 1.2',
          'm2r == 0.2.*'],
 'testing': ['pytest ~= 5.2',
             'pytest-cov ~= 2.8',
             'flake8 ~= 3.8',
             'flake8-comprehensions ~= 3.2',
             'isort ~= 5.5']}

setup(name='gamma-pytools',
      version='1.2.0',
      description="A collection of Python extensions and tools used in BCG GAMMA's open-source libraries.",
      author='Boston Consulting Group (BCG)',
      author_email=None,
      url='https://github.com/BCG-Gamma/pytools',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='~=3.6',
     )
