import cdk = require('@aws-cdk/core');
import lambda = require('@aws-cdk/aws-lambda');
export interface LambdaPowerTunerConfig {
    readonly lambdaResource: string;
    readonly powerValues?: number[];
    readonly visualizationURL?: string;
}
export declare class LambdaPowerTuner extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, config: LambdaPowerTunerConfig);
    /**
     * All the lambdas have the same config, so this method saves typing
     * @param scope
     * @param id
     * @param handler
     * @param env
     * @param timeout
     */
    createLambda(scope: cdk.Construct, id: string, handler: string, env: any, timeout?: number): lambda.Function;
}
