# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytwitter', 'pytwitter.models', 'pytwitter.utils']

package_data = \
{'': ['*']}

install_requires = \
['dataclasses-json>=0.5.2,<0.6.0',
 'requests-oauthlib>=1.3.0,<2.0.0',
 'requests>=2.24.0,<3.0.0']

setup_kwargs = {
    'name': 'python-twitter-v2',
    'version': '0.0.2',
    'description': 'A simple Python wrapper for Twitter API v2 ✨ 🍰 ✨',
    'long_description': 'python-twitter\n\nA simple Python wrapper around for Twitter API v2 :sparkles: :cake: :sparkles:.\n\n.. image:: https://img.shields.io/endpoint?url=https%3A%2F%2Ftwbadges.glitch.me%2Fbadges%2Fv2\n   :target: https://developer.twitter.com/en/docs/twitter-api\n   :alt: v2\n\n.. image:: https://github.com/sns-sdks/python-twitter/workflows/Test/badge.svg\n    :target: https://github.com/sns-sdks/python-facebook/actions\n    :alt: Build Status\n\n.. image:: https://codecov.io/gh/sns-sdks/python-twitter/branch/master/graph/badge.svg\n    :target: https://codecov.io/gh/sns-sdks/python-facebook\n    :alt: Codecov\n\n============\nIntroduction\n============\n\nTwitter has published new version `Twitter API V2 <https://twitter.com/TwitterDev/status/1293593516040269825>`_ for developer at Aug 13, 2020.\n\nThis library provides a service to easily use this new version Twitter API.\n\n=============\nDocumentation\n=============\n\nYou can get all api description and update at `Twitter API v2: Early Access <https://developer.twitter.com/en/docs/twitter-api/early-access>`_.\n\n\n==========\nInstalling\n==========\n\nCode is hosted at `https://github.com/sns-sdks/python-twitter <https://github.com/sns-sdks/python-twitter>`_.\n\nCheckout latest development version with:\n\n.. code-block:: shell\n\n    $ git clone https://github.com/sns-sdks/python-twitter.git\n    $ cd python-twitter\n\nInstall dependencies with:\n\n.. code-block:: shell\n\n    $ make env\n\n\nRun tests with:\n\n.. code-block:: shell\n\n    $ make test\n\nRun tests with coverage:\n\n.. code-block:: shell\n\n    $ make cov-term\n    $ make cov-html\n\n\nTODO pypi not published will come soon.\n\n=====\nUsing\n=====\n\nThe API is exposed via the ``pytwitter.Api`` class.\n\n-----------\nINSTANTIATE\n-----------\n\nYou can initialize with an bearer token:\n\n.. code-block:: python\n\n    >>> from pytwitter import Api\n    >>> api = Api(bearer_token="You bearer token")\n\nWith user context token:\n\n.. code-block:: python\n\n    >>> api = Api(\n            consumer_key="consumer key",\n            consumer_secret="consumer secret",\n            access_token="access token",\n            access_secret="access secret"\n        )\n\nOr with authorize by user:\n\n.. code-block:: python\n\n    >>> api = Api(consumer_key="consumer key",consumer_secret="consumer secret",oauth_flow=True)\n    # get url for user to authorize\n    >>> api.get_authorize_url()\n    # copy the response url\n    >>> api.generate_access_token("https://localhost/?oauth_token=oauth_token&oauth_verifier=oauth_verifier")\n    >>> {\'oauth_token\': \'oauth_token\',\n     \'oauth_token_secret\': \'oauth_token_secret\',\n     \'user_id\': \'123456\',\n     \'screen_name\': \'screen name\'}\n\n------------\nUsers-lookup\n------------\n\nYou can get information about a user or group of users, specified by a user ID or a username.\n\nGet group of users:\n\n.. code-block:: python\n\n    # By ids\n    >>> api.get_users(ids=["783214", "2244994945"])\n    >>> Response(data=[User(id=\'2244994945\', name=\'Twitter Dev\', username=\'TwitterDev\'), User(id=\'783214\', name=\'Twitter\', username=\'Twitter\')])\n\n    # By username\n    >>> api.get_users(usernames="Twitter,TwitterDev")\n    >>> Response(data=[User(id=\'2244994945\', name=\'Twitter Dev\', username=\'TwitterDev\'), User(id=\'783214\', name=\'Twitter\', username=\'Twitter\')])\n\nGet single user:\n\n.. code-block:: python\n\n    # By id\n    >>> api.get_user(user_id="783214")\n    >>> Response(data=User(id=\'783214\', name=\'Twitter\', username=\'Twitter\'))\n\n    # By username\n    >>> api.get_user(username="Twitter")\n    >>> Response(data=User(id=\'783214\', name=\'Twitter\', username=\'Twitter\'))\n\nGet user following:\n\n.. code-block:: python\n\n    >>> api.get_following(user_id="2244994945", max_results=5)\n    >>> Response(data=[User(id=\'459860328\', name=\'julie✨\', username=\'JulieMendoza206\'), User(id=\'273830767\', name=\'🄿🅄🅂🄷\', username=\'rahul_pushkarna\')...])\n\nGet user followers:\n\n.. code-block:: python\n\n    >>> api.get_followers(user_id="2244994945", max_results=5)\n    >>> Response(data=[User(id=\'715131097332518912\', name=\'Daniel\', username=\'RGIDaniel\'), User(id=\'1176323137757048832\', name=\'Joyce Wang\', username=\'joycew67\')...])\n\n\nYou can follow or unfollow user if you have OAuth 1.0a User context.\n\nfollow user:\n\n.. code-block:: python\n\n    >>> api.follow_user(user_id="123456", target_user_id="654321")\n    {\'data\': {\'following\': True, \'pending_follow\': False}}\n\n\nunfollow user:\n\n.. code-block:: python\n\n    >>> api.unfollow_user(user_id="123456", target_user_id="654321")\n    {\'data\': {\'following\': False}}\n\n-------------\nTweets-lookup\n-------------\n\nYou can get information about a tweet or group of tweets by tweet id(s).\n\nGet single tweet:\n\n.. code-block:: python\n\n    >>> api.get_tweet("1354143047324299264", expansions=["attachments.media_keys"], media_fields=["type","duration_ms"])\n    >>> Response(data=Tweet(id=1354143047324299264, text=Academics are one of the biggest groups using...))\n\nGet group of tweets:\n\n.. code-block:: python\n\n    >>> api.get_tweets(["1261326399320715264","1278347468690915330"],expansions="author_id",tweet_fields=["created_at"], user_fields=["username","verified"])\n    >>> Response(data=[Tweet(id=1261326399320715264, text=Tune in to the @MongoDB @Twitch stream...), Tweet(id=1278347468690915330, text=Good news and bad news: 2020 is half over)])\n\n---------\nTimelines\n---------\n\nYou can get target user timeline tweets by user id.\n\nGet timelines:\n\n.. code-block:: python\n\n    >>> api.get_timelines(user_id="2244994945")\n    >>> Response(data=[Tweet(id=1364275610764201984, text=If you\'re newly approved for the Academic...), Tweet(id=1362876655061073928, text=From our living rooms to yours 🐱\u200d💻🛋️Our...), Tweet(id=1362439338978467841, text=“To quote my creator Jerome Gangneux, I always...), Tweet(id=1362439338169016324, text=“In the 20th century, managers managed humans,...), Tweet(id=1362439336910675970, text=Meet one of the useful Twitter bots out there:...), Tweet(id=1359912509940011010, text=Valentine’s Day is approaching! 💙 Over the...), Tweet(id=1359554366051504129, text=Go ahead, follow another puppy account. We...), Tweet(id=1357371424487268354, text=Learn how academics can get historical Tweets...), Tweet(id=1356991771553583106, text=Who knew an API could be delicious?...), Tweet(id=1354215875998437376, text=RT @TwitterOSS: Today we’re happy to share...)])\n\nYou can get tweets which mention target user by user id.\n\nGet mention tweets:\n\n.. code-block:: python\n\n    >>> api.get_mentions(user_id="2244994945")\n    >>> Response(data=[Tweet(id=1364407587207213056, text=@scottmathson @TwitterDev What would you want...), Tweet(id=1364398068313903104, text=@Twitter should consider supporting...), Tweet(id=1364377794327633925, text=@sugan2424 @TwitterDev @threadreaderapp You...), Tweet(id=1364377404156772352, text=@TwitterDev What kind of tweet / attachment is...), Tweet(id=1364373969852366849, text=• Thirdly, that @Twitter, @Twittersafety,...), Tweet(id=1364367885582352386, text=@Twitter @TwitterSafety @TwitterDev @jack...), Tweet(id=1364366114998870016, text=I have mixed feelings about @Twitter /...), Tweet(id=1364364744916951040, text=@Casanovacane @jack @TwitterDev can we get a...), Tweet(id=1364359199795240961, text=@TwitterDev @suhemparack A Blue app going to...), Tweet(id=1364338409494503425, text=@FairyMaitre @TwitterDev tkt)])\n\n-------------\nSearch Tweets\n-------------\n\nSearch tweets has two type. For standard project, you can use recent api to search tweets from the last seven days.\nIf you have `Academic Research Project <https://developer.twitter.com/en/docs/projects/overview>`_, you can use full-archive\napi with query type all.\n\nSearch by recent tweets:\n\n.. code-block:: python\n\n    >>> api.search_tweets(query="python")\n    >>> Response(data=[Tweet(id=1364512148865564675, text=RT @jesss_codes: Your resume: Git SSL Vue CSS...), Tweet(id=1364512106385702914, text=RT @theweeflea: Sturgeon goes on TV to declare...), Tweet(id=1364512102606467074, text=RT @tkEzaki:...), Tweet(id=1364512092343070721, text=RT @ore57436902: #Python #pyxel #ドルアーガの塔...), Tweet(id=1364512076601856007, text=RT @shosen_bt_pc:...), Tweet(id=1364512071866605568, text=RT @CatherineAdenle: 6 ways learning coding can...), Tweet(id=1364512071614889987, text=RT @giswqs: #geemap v0.8.11 has been released....), Tweet(id=1364512066770509824, text=RT @Akpanannang: Today when coming out from the...), Tweet(id=1364512053252284419, text=RT @HarbRimah: New Off-the-Shelf (OTS) Datasets...), Tweet(id=1364512030800171011, text=RT @gzadkowski: Day 5 - #100DaysOfCode...)])\n\n\nSearch by full-archive tweets:\n\n.. code-block:: python\n\n    >>> api.search_tweets(query="python", query_type="all")\n    >>> Response(data=[Tweet(id=1364512148865564675, text=RT @jesss_codes: Your resume: Git SSL Vue CSS...), Tweet(id=1364512106385702914, text=RT @theweeflea: Sturgeon goes on TV to declare...), Tweet(id=1364512102606467074, text=RT @tkEzaki:...), Tweet(id=1364512092343070721, text=RT @ore57436902: #Python #pyxel #ドルアーガの塔...), Tweet(id=1364512076601856007, text=RT @shosen_bt_pc:...), Tweet(id=1364512071866605568, text=RT @CatherineAdenle: 6 ways learning coding can...), Tweet(id=1364512071614889987, text=RT @giswqs: #geemap v0.8.11 has been released....), Tweet(id=1364512066770509824, text=RT @Akpanannang: Today when coming out from the...), Tweet(id=1364512053252284419, text=RT @HarbRimah: New Off-the-Shelf (OTS) Datasets...), Tweet(id=1364512030800171011, text=RT @gzadkowski: Day 5 - #100DaysOfCode...)])\n\n----------\nHide reply\n----------\n\nThis api need user OAuth 1.0a User context.\n\nYou can hide reply tweet which belong to a conversation initiated by you.\n\n.. code-block:: python\n\n    >>> api.hidden_reply(tweet_id="tweet id")\n\nYou can unhide a reply tweet by api:\n\n.. code-block:: python\n\n    >>> api.hidden_reply(tweet_id="tweet id", hidden=False)\n\n====\nTODO\n====\n\n- Stream Api\n- Pypi\n',
    'author': 'ikaroskun',
    'author_email': 'merle.liukun@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sns-sdks/python-twitter',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
