import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IApi } from './api';
import { IDomainName } from './domain-name';
import { IStage } from './stage';
/**
 * (experimental) Represents an ApiGatewayV2 ApiMapping resource.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-apimapping.html
 * @experimental
 */
export interface IApiMapping extends IResource {
    /**
     * (experimental) ID of the api mapping.
     *
     * @experimental
     * @attribute true
     */
    readonly apiMappingId: string;
}
/**
 * (experimental) Properties used to create the ApiMapping resource.
 *
 * @experimental
 */
export interface ApiMappingProps {
    /**
     * (experimental) Api mapping key.
     *
     * The path where this stage should be mapped to on the domain
     *
     * @default - undefined for the root path mapping.
     * @experimental
     */
    readonly apiMappingKey?: string;
    /**
     * (experimental) The Api to which this mapping is applied.
     *
     * @experimental
     */
    readonly api: IApi;
    /**
     * (experimental) custom domain name of the mapping target.
     *
     * @experimental
     */
    readonly domainName: IDomainName;
    /**
     * (experimental) stage for the ApiMapping resource required for WebSocket API defaults to default stage of an HTTP API.
     *
     * @default - Default stage of the passed API for HTTP API, required for WebSocket API
     * @experimental
     */
    readonly stage?: IStage;
}
/**
 * (experimental) The attributes used to import existing ApiMapping.
 *
 * @experimental
 */
export interface ApiMappingAttributes {
    /**
     * (experimental) The API mapping ID.
     *
     * @experimental
     */
    readonly apiMappingId: string;
}
/**
 * (experimental) Create a new API mapping for API Gateway API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
export declare class ApiMapping extends Resource implements IApiMapping {
    /**
     * (experimental) import from API ID.
     *
     * @experimental
     */
    static fromApiMappingAttributes(scope: Construct, id: string, attrs: ApiMappingAttributes): IApiMapping;
    /**
     * (experimental) ID of the API Mapping.
     *
     * @experimental
     */
    readonly apiMappingId: string;
    /**
     * (experimental) API Mapping key.
     *
     * @experimental
     */
    readonly mappingKey?: string;
    /**
     * (experimental) API domain name.
     *
     * @experimental
     */
    readonly domainName: IDomainName;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ApiMappingProps);
}
