import { ICertificate } from '@aws-cdk/aws-certificatemanager';
import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) Represents an APIGatewayV2 DomainName.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 * @experimental
 */
export interface IDomainName extends IResource {
    /**
     * (experimental) The custom domain name.
     *
     * @experimental
     * @attribute true
     */
    readonly name: string;
    /**
     * (experimental) The domain name associated with the regional endpoint for this custom domain name.
     *
     * @experimental
     * @attribute true
     */
    readonly regionalDomainName: string;
    /**
     * (experimental) The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     *
     * @experimental
     * @attribute true
     */
    readonly regionalHostedZoneId: string;
}
/**
 * (experimental) custom domain name attributes.
 *
 * @experimental
 */
export interface DomainNameAttributes {
    /**
     * (experimental) domain name string.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The domain name associated with the regional endpoint for this custom domain name.
     *
     * @experimental
     */
    readonly regionalDomainName: string;
    /**
     * (experimental) The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     *
     * @experimental
     */
    readonly regionalHostedZoneId: string;
}
/**
 * (experimental) properties used for creating the DomainName.
 *
 * @experimental
 */
export interface DomainNameProps {
    /**
     * (experimental) The custom domain name.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) The ACM certificate for this domain name.
     *
     * @experimental
     */
    readonly certificate: ICertificate;
}
/**
 * (experimental) Custom domain resource for the API.
 *
 * @experimental
 */
export declare class DomainName extends Resource implements IDomainName {
    /**
     * (experimental) Import from attributes.
     *
     * @experimental
     */
    static fromDomainNameAttributes(scope: Construct, id: string, attrs: DomainNameAttributes): IDomainName;
    /**
     * (experimental) The custom domain name.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The domain name associated with the regional endpoint for this custom domain name.
     *
     * @experimental
     */
    readonly regionalDomainName: string;
    /**
     * (experimental) The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     *
     * @experimental
     */
    readonly regionalHostedZoneId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DomainNameProps);
}
