import { RetentionDays } from '@aws-cdk/aws-logs';
import { Bucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
export interface CatalogBuilderProps {
    /**
     * The package store bucket.
     */
    readonly bucket: Bucket;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
}
export declare class CatalogBuilder extends Construct {
    constructor(scope: Construct, id: string, props: CatalogBuilderProps);
}
