import { IGrantable, IPrincipal } from '@aws-cdk/aws-iam';
import { IBucket } from '@aws-cdk/aws-s3';
import { IQueue } from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
export interface IngestionProps {
    /**
     * The bucket in which ingested objects are due to be inserted.
     */
    readonly bucket: IBucket;
}
/**
 * The ingestion function receives messages from discovery integrations and
 * processes their payloads into the provided S3 Bucket.
 *
 * This function is also an `IGrantable`, so that it can be granted permissions
 * to read from the source S3 buckets.
 */
export declare class Ingestion extends Construct implements IGrantable {
    readonly grantPrincipal: IPrincipal;
    /**
     * The SQS queue that triggers the ingestion function.
     */
    readonly queue: IQueue;
    constructor(scope: Construct, id: string, props: IngestionProps);
}
