"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.integrity = void 0;
const crypto_1 = require("crypto");
/**
 * Computes an integrity checksum for the provided `IngestionInput`.
 *
 * @param input   the `IngestionInput` for which to make a checksum.
 * @param tarball the content of the `.tgz` npm package
 * @param alg     the hash algorithm to use (e.g: 'sha384')
 *
 * @returns the computed checksum.
 */
function integrity(input, tarball, alg) {
    var _a, _b, _c;
    if (alg === void 0) { alg = (_b = (_a = input.integrity) === null || _a === void 0 ? void 0 : _a.split('-')[0]) !== null && _b !== void 0 ? _b : 'sha384'; }
    const hash = crypto_1.createHash(alg);
    const addField = (name, data) => 
    //           <SOH>        $name          <STX>        $data          <ETX>
    hash.update('\x01').update(name).update('\x02').update(data).update('\x03');
    for (const [name, value] of Object.entries((_c = input.metadata) !== null && _c !== void 0 ? _c : {}).sort(([l], [r]) => l.localeCompare(r))) {
        addField(`metadata/${name}`, value);
    }
    addField('tarball', tarball);
    addField('time', input.time);
    return `${alg}-${hash.digest('base64')}`;
}
exports.integrity = integrity;
//# sourceMappingURL=data:application/json;base64,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