"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transliterator = void 0;
const aws_lambda_event_sources_1 = require("@aws-cdk/aws-lambda-event-sources");
const aws_logs_1 = require("@aws-cdk/aws-logs");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const shared_1 = require("../shared");
const transliterator_1 = require("./transliterator");
class Transliterator extends core_1.Construct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const lambda = new transliterator_1.Transliterator(this, 'Default', {
            deadLetterQueueEnabled: true,
            description: 'Creates transliterated assemblies from jsii-enabled npm packages',
            logRetention: (_a = props.logRetention) !== null && _a !== void 0 ? _a : aws_logs_1.RetentionDays.TEN_YEARS,
            memorySize: 10240,
            retryAttempts: 2,
            timeout: core_1.Duration.minutes(15),
        });
        // The handler reads & writes to this bucket.
        props.bucket.grantReadWrite(lambda);
        // Creating the event chaining
        lambda.addEventSource(new aws_lambda_event_sources_1.S3EventSource(props.bucket, {
            events: [aws_s3_1.EventType.OBJECT_CREATED],
            filters: [{ prefix: shared_1.constants.STORAGE_KEY_PREFIX, suffix: shared_1.constants.PACKAGE_KEY_SUFFIX }],
        }));
    }
}
exports.Transliterator = Transliterator;
//# sourceMappingURL=data:application/json;base64,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