import * as iam from '@aws-cdk/aws-iam';
import * as sqs from '@aws-cdk/aws-sqs';
import { Construct as CoreConstruct } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { AlarmActions, Domain } from './api';
/**
 * (experimental) Props for `ConstructHub`.
 *
 * @experimental
 */
export interface ConstructHubProps {
    /**
     * (experimental) Connect the hub to a domain (requires a hosted zone and a certificate).
     *
     * @experimental
     */
    readonly domain?: Domain;
    /**
     * (experimental) The name of the CloudWatch Dashboard created to observe this application.
     *
     * Must only contain alphanumerics, dash (-) and underscore (_).
     *
     * @default "construct-hub"
     * @experimental
     */
    readonly dashboardName?: string;
    /**
     * (experimental) Actions to perform when alarms are set.
     *
     * @experimental
     */
    readonly alarmActions: AlarmActions;
}
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
export declare class ConstructHub extends CoreConstruct implements iam.IGrantable {
    private readonly ingestion;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ConstructHubProps);
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * @experimental
     */
    get ingestionQueue(): sqs.IQueue;
}
