"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Image = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const _shell_1 = require("./_shell");
const PARSE_DIGEST = /digest:\ (sha256:[0-9a-f]+)/;
/**
 * Represents a docker image built during synthesis from a context directory
 * (`dir`) with a `Dockerfile`.
 *
 * The image will be built using `docker build` and then pushed through `docker
 * push`. The URL of the pushed image can be accessed through `image.url`.
 *
 * If you push to a registry other then docker hub, you can specify the registry
 * URL through the `registry` option.
 */
class Image extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const registry = (_b = props.registry) !== null && _b !== void 0 ? _b : 'docker.io/library';
        const tag = `${registry}/${cdk8s_1.Names.toDnsLabel(this)}`;
        const allBuildArgs = [];
        (_c = props.buildArgs) === null || _c === void 0 ? void 0 : _c.forEach((arg) => {
            allBuildArgs.push('--build-arg');
            allBuildArgs.push(`${arg.name}=${arg.value}`);
        });
        if (props.file) {
            allBuildArgs.push('-f');
            allBuildArgs.push(props.file);
        }
        console.error(`building docker image ${tag} from ${props.file ? props.file : props.dir}`);
        _shell_1.shell('docker', 'build', '-t', tag, props.dir, ...allBuildArgs);
        console.error(`pushing docker image ${tag} to ${registry}`);
        const push = _shell_1.shell('docker', 'push', tag);
        const result = PARSE_DIGEST.exec(push);
        if (!result) {
            throw new Error(`unable to read image digest after push: ${push}`);
        }
        this.url = `${tag}@${result[1]}`;
    }
}
exports.Image = Image;
_a = JSII_RTTI_SYMBOL_1;
Image[_a] = { fqn: "cdk8s-image.Image", version: "0.2.139" };
//# sourceMappingURL=data:application/json;base64,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