# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
import CyberSource.logging.log_factory as LogFactory


class CustomerApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
	
    def __init__(self, merchant_config, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_configuration(merchant_config)
        self.logger = LogFactory.setup_logger(self.__class__.__name__, self.api_client.mconfig.log_config)



    def delete_customer(self, customer_token_id, **kwargs):
        """
        Delete a Customer
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_customer(customer_token_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_token_id: The TokenId of a customer. (required)
        :param str profile_id: The id of a profile containing user specific TMS configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `delete_customer` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_customer_with_http_info(customer_token_id, **kwargs)
        else:
            (data) = self.delete_customer_with_http_info(customer_token_id, **kwargs)
            return data

    def delete_customer_with_http_info(self, customer_token_id, **kwargs):
        """
        Delete a Customer
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_customer_with_http_info(customer_token_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_token_id: The TokenId of a customer. (required)
        :param str profile_id: The id of a profile containing user specific TMS configuration.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_token_id', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_token_id' is set
        if ('customer_token_id' not in params) or (params['customer_token_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `customer_token_id` when calling `delete_customer`")
            raise ValueError("Missing the required parameter `customer_token_id` when calling `delete_customer`")

        if 'customer_token_id' in params and len(params['customer_token_id']) > 32:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `customer_token_id` when calling `delete_customer`, length must be less than or equal to `32`")
            raise ValueError("Invalid value for parameter `customer_token_id` when calling `delete_customer`, length must be less than or equal to `32`")
        if 'customer_token_id' in params and len(params['customer_token_id']) < 1:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `customer_token_id` when calling `delete_customer`, length must be greater than or equal to `1`")
            raise ValueError("Invalid value for parameter `customer_token_id` when calling `delete_customer`, length must be greater than or equal to `1`")
        if 'profile_id' in params and len(params['profile_id']) > 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `delete_customer`, length must be less than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `delete_customer`, length must be less than or equal to `36`")
        if 'profile_id' in params and len(params['profile_id']) < 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `delete_customer`, length must be greater than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `delete_customer`, length must be greater than or equal to `36`")

        collection_formats = {}

        path_params = {}
        if 'customer_token_id' in params:
            path_params['customerTokenId'] = params['customer_token_id']

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/customers/{customer_token_id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_customer(self, customer_token_id, **kwargs):
        """
        Retrieve a Customer
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_customer(customer_token_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_token_id: The TokenId of a customer. (required)
        :param str profile_id: The id of a profile containing user specific TMS configuration.
        :return: TmsV2CustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `get_customer` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_customer_with_http_info(customer_token_id, **kwargs)
        else:
            (data) = self.get_customer_with_http_info(customer_token_id, **kwargs)
            return data

    def get_customer_with_http_info(self, customer_token_id, **kwargs):
        """
        Retrieve a Customer
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_customer_with_http_info(customer_token_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_token_id: The TokenId of a customer. (required)
        :param str profile_id: The id of a profile containing user specific TMS configuration.
        :return: TmsV2CustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_token_id', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_token_id' is set
        if ('customer_token_id' not in params) or (params['customer_token_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `customer_token_id` when calling `get_customer`")
            raise ValueError("Missing the required parameter `customer_token_id` when calling `get_customer`")

        if 'customer_token_id' in params and len(params['customer_token_id']) > 32:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `customer_token_id` when calling `get_customer`, length must be less than or equal to `32`")
            raise ValueError("Invalid value for parameter `customer_token_id` when calling `get_customer`, length must be less than or equal to `32`")
        if 'customer_token_id' in params and len(params['customer_token_id']) < 1:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `customer_token_id` when calling `get_customer`, length must be greater than or equal to `1`")
            raise ValueError("Invalid value for parameter `customer_token_id` when calling `get_customer`, length must be greater than or equal to `1`")
        if 'profile_id' in params and len(params['profile_id']) > 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `get_customer`, length must be less than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `get_customer`, length must be less than or equal to `36`")
        if 'profile_id' in params and len(params['profile_id']) < 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `get_customer`, length must be greater than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `get_customer`, length must be greater than or equal to `36`")

        collection_formats = {}

        path_params = {}
        if 'customer_token_id' in params:
            path_params['customerTokenId'] = params['customer_token_id']

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/customers/{customer_token_id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TmsV2CustomersResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_customer(self, customer_token_id, patch_customer_request, **kwargs):
        """
        Update a Customer
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_customer(customer_token_id, patch_customer_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_token_id: The TokenId of a customer. (required)
        :param PatchCustomerRequest patch_customer_request: (required)
        :param str profile_id: The id of a profile containing user specific TMS configuration.
        :param str if_match: Contains an ETag value from a GET request to make the request conditional.
        :return: TmsV2CustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `patch_customer` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_customer_with_http_info(customer_token_id, patch_customer_request, **kwargs)
        else:
            (data) = self.patch_customer_with_http_info(customer_token_id, patch_customer_request, **kwargs)
            return data

    def patch_customer_with_http_info(self, customer_token_id, patch_customer_request, **kwargs):
        """
        Update a Customer
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_customer_with_http_info(customer_token_id, patch_customer_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_token_id: The TokenId of a customer. (required)
        :param PatchCustomerRequest patch_customer_request: (required)
        :param str profile_id: The id of a profile containing user specific TMS configuration.
        :param str if_match: Contains an ETag value from a GET request to make the request conditional.
        :return: TmsV2CustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_token_id', 'patch_customer_request', 'profile_id', 'if_match']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_token_id' is set
        if ('customer_token_id' not in params) or (params['customer_token_id'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `customer_token_id` when calling `patch_customer`")
            raise ValueError("Missing the required parameter `customer_token_id` when calling `patch_customer`")
        # verify the required parameter 'patch_customer_request' is set
        if ('patch_customer_request' not in params) or (params['patch_customer_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `patch_customer_request` when calling `patch_customer`")
            raise ValueError("Missing the required parameter `patch_customer_request` when calling `patch_customer`")

        if 'customer_token_id' in params and len(params['customer_token_id']) > 32:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `customer_token_id` when calling `patch_customer`, length must be less than or equal to `32`")
            raise ValueError("Invalid value for parameter `customer_token_id` when calling `patch_customer`, length must be less than or equal to `32`")
        if 'customer_token_id' in params and len(params['customer_token_id']) < 1:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `customer_token_id` when calling `patch_customer`, length must be greater than or equal to `1`")
            raise ValueError("Invalid value for parameter `customer_token_id` when calling `patch_customer`, length must be greater than or equal to `1`")
        if 'profile_id' in params and len(params['profile_id']) > 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `patch_customer`, length must be less than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `patch_customer`, length must be less than or equal to `36`")
        if 'profile_id' in params and len(params['profile_id']) < 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `patch_customer`, length must be greater than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `patch_customer`, length must be greater than or equal to `36`")
        if 'if_match' in params and len(params['if_match']) > 32:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `if_match` when calling `patch_customer`, length must be less than or equal to `32`")
            raise ValueError("Invalid value for parameter `if_match` when calling `patch_customer`, length must be less than or equal to `32`")
        if 'if_match' in params and len(params['if_match']) < 1:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `if_match` when calling `patch_customer`, length must be greater than or equal to `1`")
            raise ValueError("Invalid value for parameter `if_match` when calling `patch_customer`, length must be greater than or equal to `1`")

        collection_formats = {}

        path_params = {}
        if 'customer_token_id' in params:
            path_params['customerTokenId'] = params['customer_token_id']

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']
        if 'if_match' in params:
            header_params['if-match'] = params['if_match']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_customer_request' in params:
            body_params = params['patch_customer_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/customers/{customer_token_id}', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TmsV2CustomersResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_customer(self, post_customer_request, **kwargs):
        """
        Create a Customer
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_customer(post_customer_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PostCustomerRequest post_customer_request: (required)
        :param str profile_id: The id of a profile containing user specific TMS configuration.
        :return: TmsV2CustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        if self.api_client.mconfig.log_config.enable_log:
            self.logger.info("CALL TO METHOD `post_customer` STARTED")

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_customer_with_http_info(post_customer_request, **kwargs)
        else:
            (data) = self.post_customer_with_http_info(post_customer_request, **kwargs)
            return data

    def post_customer_with_http_info(self, post_customer_request, **kwargs):
        """
        Create a Customer
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_customer_with_http_info(post_customer_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PostCustomerRequest post_customer_request: (required)
        :param str profile_id: The id of a profile containing user specific TMS configuration.
        :return: TmsV2CustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['post_customer_request', 'profile_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'post_customer_request' is set
        if ('post_customer_request' not in params) or (params['post_customer_request'] is None):
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Missing the required parameter `post_customer_request` when calling `post_customer`")
            raise ValueError("Missing the required parameter `post_customer_request` when calling `post_customer`")

        if 'profile_id' in params and len(params['profile_id']) > 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `post_customer`, length must be less than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `post_customer`, length must be less than or equal to `36`")
        if 'profile_id' in params and len(params['profile_id']) < 36:
            if self.api_client.mconfig.log_config.enable_log:
                self.logger.error("InvalidArgumentException : Invalid value for parameter `profile_id` when calling `post_customer`, length must be greater than or equal to `36`")
            raise ValueError("Invalid value for parameter `profile_id` when calling `post_customer`, length must be greater than or equal to `36`")

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'profile_id' in params:
            header_params['profile-id'] = params['profile_id']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_customer_request' in params:
            body_params = params['post_customer_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(f'/tms/v2/customers', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TmsV2CustomersResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
