var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toModule = (module2) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};

// src/monitored-certificate/certificate-monitor.lambda.ts
__export(exports, {
  handler: () => handler
});
var process = __toModule(require("process"));
var tls = __toModule(require("tls"));
var AWS = __toModule(require("aws-sdk"));
async function handler(_event, _context) {
  const endpoint = requireEnv("HTTPS_ENDPOINT");
  const metricNamespace = requireEnv("METRIC_NAMESPACE");
  const metricName = requireEnv("METRIC_NAME");
  const now = new Date();
  const daysRemaining = await tlsValidDaysRemaining(endpoint, now);
  console.log(`The certificate has ${daysRemaining} remaining validity days`);
  return new AWS.CloudWatch().putMetricData({
    Namespace: metricNamespace,
    MetricData: [
      {
        Dimensions: [{ Name: "DomainName", Value: endpoint }],
        MetricName: metricName,
        Timestamp: now,
        Unit: "Count",
        Value: daysRemaining
      }
    ]
  }).promise();
}
function requireEnv(name) {
  const result = process.env[name];
  if (!result) {
    throw new Error(`Missing required environment variable "${name}"`);
  }
  return result;
}
function tlsValidDaysRemaining(endpoint, now) {
  console.log(`Checking remaining validity time for certificate on ${endpoint}:443`);
  const sock = tls.connect({
    host: endpoint,
    port: 443,
    servername: endpoint
  });
  const closeThen = (cb) => sock.end(() => {
    sock.destroy();
    sock.unref();
    cb();
  });
  return new Promise((resolve, reject) => {
    const ok = (val) => closeThen(() => resolve(val));
    const ko = (reason) => closeThen(() => reject(reason));
    try {
      sock.once("error", (err) => err.code === "CERT_HAS_EXPIRED" ? ok(0) : ko(err));
      sock.once("secureConnect", () => {
        const cert = sock.getPeerCertificate();
        console.log(`Secure connection established: ${cert.fingerprint256} is valid from ${cert.valid_from} until ${cert.valid_to}`);
        const remainingMillis = new Date(cert.valid_to).getTime() - now.getTime();
        if (remainingMillis < 0) {
          console.error(`The certificate expired ${remainingMillis}ms ago!`);
          return ok(0);
        }
        ok(remainingMillis / 864e5);
      });
    } catch (e) {
      ko(e);
    }
  });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
