"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_embedded_metrics_1 = require("aws-embedded-metrics");
const AWS = require("aws-sdk");
const env_lambda_shared_1 = require("../../backend/shared/env.lambda-shared");
const constants_1 = require("./constants");
const DISTRIBUTION_ID = env_lambda_shared_1.requireEnv('DISTRIBUTION_ID');
const PATH_PREFIX = env_lambda_shared_1.requireEnv('PATH_PREFIX');
async function handler(event, _context) {
    console.log(`Event: ${JSON.stringify(event, null, 2)}`);
    if (event.Records.length === 0) {
        return;
    }
    await aws_embedded_metrics_1.metricScope((metrics) => () => {
        // Clear default dimensions, we don't need those.
        metrics.setDimensions();
        metrics.setNamespace(constants_1.METRICS_NAMESPACE);
        const now = Date.now();
        for (const record of event.Records) {
            const age = now - new Date(record.eventTime).getTime();
            metrics.putMetric("S3EventAge" /* S3_EVENT_AGE */, age, aws_embedded_metrics_1.Unit.Milliseconds);
        }
    })();
    const cf = new AWS.CloudFront();
    return cf.createInvalidation({
        DistributionId: DISTRIBUTION_ID,
        InvalidationBatch: {
            Paths: {
                Quantity: event.Records.length,
                Items: event.Records.map((record) => `${PATH_PREFIX}${record.s3.object.key}`),
            },
            CallerReference: event.Records.map((record) => record.s3.object.eTag).join(', '),
        },
    }).promise();
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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