# test_utilities
import numpy as np
import os
import pytest

from deepforest import get_data
from deepforest import utilities

#import general model fixture
from .conftest import download_release


@pytest.fixture()
def config():
    config = utilities.read_config(get_data("deepforest_config.yml"))
    return config


def test_xml_to_annotations():
    annotations = utilities.xml_to_annotations(
        xml_path=get_data("OSBS_029.xml"))
    print(annotations.shape)
    assert annotations.shape == (61, 6)

    # bounding box extents should be int
    assert annotations["xmin"].dtype == np.int64


#def test_use_release():
    ## Download latest model from github release
    #release_tag, weights = utilities.use_release()
    #assert os.path.exists(get_data("NEON.h5"))

def test_float_warning(config):
    """Users should get a rounding warning when adding annotations with floats"""
    float_annotations = "tests/data/float_annotations.txt"
    annotations = utilities.xml_to_annotations(float_annotations)
    assert annotations.xmin.dtype is np.dtype('int64')
