<h1 align="center">
  Software-Driven RDM
</h1>
<p align="center"> 
Software-driven Research Data Management (sdRDM) is a concept and library that builds upon abstract data models in readable formats. Data Models generated by sdRDM are able to be exported into all common formats such as JSON/XML and towards standards defined by the community.</p>

### 🏎 Features

- Generate and maintain RDM APIs via readable specifications in __Markdown__
- Data Models defined in sdRDM can be exported to __any format__
- Link your data model to any other data model and setup __workflows__

## ⚡️ Quick start
Get started with PyEnzyme by running the following command 

```
# Using PIP
python -m pip install git+https://github.com/JR-1991/software-driven-rdm.git
```

Or build by source
```
git clone https://github.com/JR-1991/software-driven-rdm.git
cd software-driven-rdm
python3 setup.py install
```

## ⚙️ Example code

This example will demonstrate how to set up an sdRDM Data Model in Python. By inheriting ```sdRDM.DataModel``` classes will posses all benefits such as export and import from and to various data formats.

```python

from sdRDM import DataModel, Field
from typing import 

class Person(DataModel):

    name: str = Field(
        ...,
        description="Name of a person"
    )
    age: int = Field(
        ...,
        description="Age of a person"
    )

class Group(DataModel):

    name: str = Field(
        ...,
        description="Name of this group"
    )

    persons: List[Person] = Field(
        description="Persons from this group",
        default_factory=list
    )

# Apply data model
person1 = Person(name="Max", age=43)
person2 = Person(name="Hannah", age=38)

group = Group(
    name="sdRDM Group",
    persons=[person1, person2]
)

print(group.yaml())

```
<sub>(Code should run as it is)</sup>

### 🧬 Code Generation

Software-driven RDM is also capable of generating Python APIs from __Markdown__ specifications. For this, please inspect the example found [here](https://github.com/JR-1991/software-driven-rdm/tree/master/Examples/Generation). In this example, a Python API for a *Biocatalyst* will be generated from its corresponding [specification](https://github.com/JR-1991/software-driven-rdm/blob/master/Examples/Generation/specifications/biocatalyst.md). Aside from a functional [API](https://github.com/JR-1991/software-driven-rdm/tree/master/Examples/Generation/pyBioCat) this will also result in a [class diagram](https://github.com/JR-1991/software-driven-rdm/blob/master/Examples/Generation/pyBioCat/schemes/Biocatalyst.md) to understand the workings of the data model.

## 📖 Documentation and more examples

In the making! 🐛

## ⚠️ License

`sdRDM` is free and open-source software licensed under the MIT License. 
