""" Unit tests for the configman api controller """
# NOTE: These tests require that configman be set up locally, or the tests be pointed at production

from unittest import TestCase
from utils_package.api_controller.configman import ConfigmanController
from utils_package.data_controller.json_config import JSONConfig


class TestConfigman(TestCase):
    """ Unit tests for the configman api controller """

    def setUp(self):
        """ Set up class variables """
        self.configman = ConfigmanController()
        self.json_conf = JSONConfig()

    def test_get_and_validate_token(self):
        """ Test to validate a token generated by the controller
        1. Set up test variables
        2. Create token for test
        3. Validate token against configman
        # """
        # 1. Set up test variables
        user = 'jb_utils'
        password = 'jb_utils'
        app = 'jb_tech_utils'

        # 2. Create token for test
        response_code, response = self.configman.generate_auth_token(password, user, app)
        self.assertEqual(202, response_code)
        token = response['response']['token']

        # 3. Validate token against configman
        response_code, response = self.configman.validate_auth_token(token, user)
        self.assertEqual(200, response_code)
        self.assertEqual(user, response['response']['user'])

    def test_load_application_credentials(self):
        """ Test to validate a user is able to get the application credentials
        1. Set up test variables
        2. Create token for test
        3. Validate token against configman
        4. Build request to get the application configurations
        5. Validate the response is correct
        """
        # 1. Set up test variables
        user = 'jb_utils'
        password = 'jb_utils'
        app = 'jb_tech_utils'
        config_type = 'vars'

        # 2. Create token for test
        response_code, response = self.configman.generate_auth_token(password, user, app)
        self.assertEqual(202, response_code)
        token = response['response']['token']

        # 3. Validate token against configman
        response_code, response = self.configman.validate_auth_token(token, user)
        self.assertEqual(200, response_code)
        self.assertEqual(user, response['response']['user'])

        # 4. Build request to get the application configurations
        response_code, response = self.configman.load_application_configs(token, user, app, config_type)
        self.assertEqual(200, response_code)
        response = response['response']

        # 5. Validate the response is correct
        self.assertEqual('app_reader', response['postgres.local.cred.app_reader'])
        self.assertEqual(5432, response['postgres.local.port'])
