import {Request} from '../lib/request';
import {Response} from '../lib/response';
import {AWSError} from '../lib/error';
import {Service} from '../lib/service';
import {ServiceConfigurationOptions} from '../lib/service';
import {ConfigBase as Config} from '../lib/config';
interface Blob {}
declare class NetworkManager extends Service {
  /**
   * Constructs a service object. This object has one method for each API operation.
   */
  constructor(options?: NetworkManager.Types.ClientConfiguration)
  config: Config & NetworkManager.Types.ClientConfiguration;
  /**
   * Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be associated with the specified device.  You can only associate customer gateways that are connected to a VPN attachment on a transit gateway. The transit gateway must be registered in your global network. When you register a transit gateway, customer gateways that are connected to the transit gateway are automatically included in the global network. To list customer gateways that are connected to a transit gateway, use the DescribeVpnConnections EC2 API and filter by transit-gateway-id. You cannot associate a customer gateway with more than one device and link. 
   */
  associateCustomerGateway(params: NetworkManager.Types.AssociateCustomerGatewayRequest, callback?: (err: AWSError, data: NetworkManager.Types.AssociateCustomerGatewayResponse) => void): Request<NetworkManager.Types.AssociateCustomerGatewayResponse, AWSError>;
  /**
   * Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be associated with the specified device.  You can only associate customer gateways that are connected to a VPN attachment on a transit gateway. The transit gateway must be registered in your global network. When you register a transit gateway, customer gateways that are connected to the transit gateway are automatically included in the global network. To list customer gateways that are connected to a transit gateway, use the DescribeVpnConnections EC2 API and filter by transit-gateway-id. You cannot associate a customer gateway with more than one device and link. 
   */
  associateCustomerGateway(callback?: (err: AWSError, data: NetworkManager.Types.AssociateCustomerGatewayResponse) => void): Request<NetworkManager.Types.AssociateCustomerGatewayResponse, AWSError>;
  /**
   * Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.
   */
  associateLink(params: NetworkManager.Types.AssociateLinkRequest, callback?: (err: AWSError, data: NetworkManager.Types.AssociateLinkResponse) => void): Request<NetworkManager.Types.AssociateLinkResponse, AWSError>;
  /**
   * Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.
   */
  associateLink(callback?: (err: AWSError, data: NetworkManager.Types.AssociateLinkResponse) => void): Request<NetworkManager.Types.AssociateLinkResponse, AWSError>;
  /**
   * Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.
   */
  createDevice(params: NetworkManager.Types.CreateDeviceRequest, callback?: (err: AWSError, data: NetworkManager.Types.CreateDeviceResponse) => void): Request<NetworkManager.Types.CreateDeviceResponse, AWSError>;
  /**
   * Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.
   */
  createDevice(callback?: (err: AWSError, data: NetworkManager.Types.CreateDeviceResponse) => void): Request<NetworkManager.Types.CreateDeviceResponse, AWSError>;
  /**
   * Creates a new, empty global network.
   */
  createGlobalNetwork(params: NetworkManager.Types.CreateGlobalNetworkRequest, callback?: (err: AWSError, data: NetworkManager.Types.CreateGlobalNetworkResponse) => void): Request<NetworkManager.Types.CreateGlobalNetworkResponse, AWSError>;
  /**
   * Creates a new, empty global network.
   */
  createGlobalNetwork(callback?: (err: AWSError, data: NetworkManager.Types.CreateGlobalNetworkResponse) => void): Request<NetworkManager.Types.CreateGlobalNetworkResponse, AWSError>;
  /**
   * Creates a new link for a specified site.
   */
  createLink(params: NetworkManager.Types.CreateLinkRequest, callback?: (err: AWSError, data: NetworkManager.Types.CreateLinkResponse) => void): Request<NetworkManager.Types.CreateLinkResponse, AWSError>;
  /**
   * Creates a new link for a specified site.
   */
  createLink(callback?: (err: AWSError, data: NetworkManager.Types.CreateLinkResponse) => void): Request<NetworkManager.Types.CreateLinkResponse, AWSError>;
  /**
   * Creates a new site in a global network.
   */
  createSite(params: NetworkManager.Types.CreateSiteRequest, callback?: (err: AWSError, data: NetworkManager.Types.CreateSiteResponse) => void): Request<NetworkManager.Types.CreateSiteResponse, AWSError>;
  /**
   * Creates a new site in a global network.
   */
  createSite(callback?: (err: AWSError, data: NetworkManager.Types.CreateSiteResponse) => void): Request<NetworkManager.Types.CreateSiteResponse, AWSError>;
  /**
   * Deletes an existing device. You must first disassociate the device from any links and customer gateways.
   */
  deleteDevice(params: NetworkManager.Types.DeleteDeviceRequest, callback?: (err: AWSError, data: NetworkManager.Types.DeleteDeviceResponse) => void): Request<NetworkManager.Types.DeleteDeviceResponse, AWSError>;
  /**
   * Deletes an existing device. You must first disassociate the device from any links and customer gateways.
   */
  deleteDevice(callback?: (err: AWSError, data: NetworkManager.Types.DeleteDeviceResponse) => void): Request<NetworkManager.Types.DeleteDeviceResponse, AWSError>;
  /**
   * Deletes an existing global network. You must first delete all global network objects (devices, links, and sites) and deregister all transit gateways.
   */
  deleteGlobalNetwork(params: NetworkManager.Types.DeleteGlobalNetworkRequest, callback?: (err: AWSError, data: NetworkManager.Types.DeleteGlobalNetworkResponse) => void): Request<NetworkManager.Types.DeleteGlobalNetworkResponse, AWSError>;
  /**
   * Deletes an existing global network. You must first delete all global network objects (devices, links, and sites) and deregister all transit gateways.
   */
  deleteGlobalNetwork(callback?: (err: AWSError, data: NetworkManager.Types.DeleteGlobalNetworkResponse) => void): Request<NetworkManager.Types.DeleteGlobalNetworkResponse, AWSError>;
  /**
   * Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
   */
  deleteLink(params: NetworkManager.Types.DeleteLinkRequest, callback?: (err: AWSError, data: NetworkManager.Types.DeleteLinkResponse) => void): Request<NetworkManager.Types.DeleteLinkResponse, AWSError>;
  /**
   * Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
   */
  deleteLink(callback?: (err: AWSError, data: NetworkManager.Types.DeleteLinkResponse) => void): Request<NetworkManager.Types.DeleteLinkResponse, AWSError>;
  /**
   * Deletes an existing site. The site cannot be associated with any device or link.
   */
  deleteSite(params: NetworkManager.Types.DeleteSiteRequest, callback?: (err: AWSError, data: NetworkManager.Types.DeleteSiteResponse) => void): Request<NetworkManager.Types.DeleteSiteResponse, AWSError>;
  /**
   * Deletes an existing site. The site cannot be associated with any device or link.
   */
  deleteSite(callback?: (err: AWSError, data: NetworkManager.Types.DeleteSiteResponse) => void): Request<NetworkManager.Types.DeleteSiteResponse, AWSError>;
  /**
   * Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.
   */
  deregisterTransitGateway(params: NetworkManager.Types.DeregisterTransitGatewayRequest, callback?: (err: AWSError, data: NetworkManager.Types.DeregisterTransitGatewayResponse) => void): Request<NetworkManager.Types.DeregisterTransitGatewayResponse, AWSError>;
  /**
   * Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.
   */
  deregisterTransitGateway(callback?: (err: AWSError, data: NetworkManager.Types.DeregisterTransitGatewayResponse) => void): Request<NetworkManager.Types.DeregisterTransitGatewayResponse, AWSError>;
  /**
   * Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate Get* action. For example, to list the transit gateways in your global network, use GetTransitGatewayRegistrations.
   */
  describeGlobalNetworks(params: NetworkManager.Types.DescribeGlobalNetworksRequest, callback?: (err: AWSError, data: NetworkManager.Types.DescribeGlobalNetworksResponse) => void): Request<NetworkManager.Types.DescribeGlobalNetworksResponse, AWSError>;
  /**
   * Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate Get* action. For example, to list the transit gateways in your global network, use GetTransitGatewayRegistrations.
   */
  describeGlobalNetworks(callback?: (err: AWSError, data: NetworkManager.Types.DescribeGlobalNetworksResponse) => void): Request<NetworkManager.Types.DescribeGlobalNetworksResponse, AWSError>;
  /**
   * Disassociates a customer gateway from a device and a link.
   */
  disassociateCustomerGateway(params: NetworkManager.Types.DisassociateCustomerGatewayRequest, callback?: (err: AWSError, data: NetworkManager.Types.DisassociateCustomerGatewayResponse) => void): Request<NetworkManager.Types.DisassociateCustomerGatewayResponse, AWSError>;
  /**
   * Disassociates a customer gateway from a device and a link.
   */
  disassociateCustomerGateway(callback?: (err: AWSError, data: NetworkManager.Types.DisassociateCustomerGatewayResponse) => void): Request<NetworkManager.Types.DisassociateCustomerGatewayResponse, AWSError>;
  /**
   * Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.
   */
  disassociateLink(params: NetworkManager.Types.DisassociateLinkRequest, callback?: (err: AWSError, data: NetworkManager.Types.DisassociateLinkResponse) => void): Request<NetworkManager.Types.DisassociateLinkResponse, AWSError>;
  /**
   * Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.
   */
  disassociateLink(callback?: (err: AWSError, data: NetworkManager.Types.DisassociateLinkResponse) => void): Request<NetworkManager.Types.DisassociateLinkResponse, AWSError>;
  /**
   * Gets the association information for customer gateways that are associated with devices and links in your global network.
   */
  getCustomerGatewayAssociations(params: NetworkManager.Types.GetCustomerGatewayAssociationsRequest, callback?: (err: AWSError, data: NetworkManager.Types.GetCustomerGatewayAssociationsResponse) => void): Request<NetworkManager.Types.GetCustomerGatewayAssociationsResponse, AWSError>;
  /**
   * Gets the association information for customer gateways that are associated with devices and links in your global network.
   */
  getCustomerGatewayAssociations(callback?: (err: AWSError, data: NetworkManager.Types.GetCustomerGatewayAssociationsResponse) => void): Request<NetworkManager.Types.GetCustomerGatewayAssociationsResponse, AWSError>;
  /**
   * Gets information about one or more of your devices in a global network.
   */
  getDevices(params: NetworkManager.Types.GetDevicesRequest, callback?: (err: AWSError, data: NetworkManager.Types.GetDevicesResponse) => void): Request<NetworkManager.Types.GetDevicesResponse, AWSError>;
  /**
   * Gets information about one or more of your devices in a global network.
   */
  getDevices(callback?: (err: AWSError, data: NetworkManager.Types.GetDevicesResponse) => void): Request<NetworkManager.Types.GetDevicesResponse, AWSError>;
  /**
   * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
   */
  getLinkAssociations(params: NetworkManager.Types.GetLinkAssociationsRequest, callback?: (err: AWSError, data: NetworkManager.Types.GetLinkAssociationsResponse) => void): Request<NetworkManager.Types.GetLinkAssociationsResponse, AWSError>;
  /**
   * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
   */
  getLinkAssociations(callback?: (err: AWSError, data: NetworkManager.Types.GetLinkAssociationsResponse) => void): Request<NetworkManager.Types.GetLinkAssociationsResponse, AWSError>;
  /**
   * Gets information about one or more links in a specified global network. If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type and provider in the same request.
   */
  getLinks(params: NetworkManager.Types.GetLinksRequest, callback?: (err: AWSError, data: NetworkManager.Types.GetLinksResponse) => void): Request<NetworkManager.Types.GetLinksResponse, AWSError>;
  /**
   * Gets information about one or more links in a specified global network. If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type and provider in the same request.
   */
  getLinks(callback?: (err: AWSError, data: NetworkManager.Types.GetLinksResponse) => void): Request<NetworkManager.Types.GetLinksResponse, AWSError>;
  /**
   * Gets information about one or more of your sites in a global network.
   */
  getSites(params: NetworkManager.Types.GetSitesRequest, callback?: (err: AWSError, data: NetworkManager.Types.GetSitesResponse) => void): Request<NetworkManager.Types.GetSitesResponse, AWSError>;
  /**
   * Gets information about one or more of your sites in a global network.
   */
  getSites(callback?: (err: AWSError, data: NetworkManager.Types.GetSitesResponse) => void): Request<NetworkManager.Types.GetSitesResponse, AWSError>;
  /**
   * Gets information about the transit gateway registrations in a specified global network.
   */
  getTransitGatewayRegistrations(params: NetworkManager.Types.GetTransitGatewayRegistrationsRequest, callback?: (err: AWSError, data: NetworkManager.Types.GetTransitGatewayRegistrationsResponse) => void): Request<NetworkManager.Types.GetTransitGatewayRegistrationsResponse, AWSError>;
  /**
   * Gets information about the transit gateway registrations in a specified global network.
   */
  getTransitGatewayRegistrations(callback?: (err: AWSError, data: NetworkManager.Types.GetTransitGatewayRegistrationsResponse) => void): Request<NetworkManager.Types.GetTransitGatewayRegistrationsResponse, AWSError>;
  /**
   * Lists the tags for a specified resource.
   */
  listTagsForResource(params: NetworkManager.Types.ListTagsForResourceRequest, callback?: (err: AWSError, data: NetworkManager.Types.ListTagsForResourceResponse) => void): Request<NetworkManager.Types.ListTagsForResourceResponse, AWSError>;
  /**
   * Lists the tags for a specified resource.
   */
  listTagsForResource(callback?: (err: AWSError, data: NetworkManager.Types.ListTagsForResourceResponse) => void): Request<NetworkManager.Types.ListTagsForResourceResponse, AWSError>;
  /**
   * Registers a transit gateway in your global network. The transit gateway can be in any AWS Region, but it must be owned by the same AWS account that owns the global network. You cannot register a transit gateway in more than one global network.
   */
  registerTransitGateway(params: NetworkManager.Types.RegisterTransitGatewayRequest, callback?: (err: AWSError, data: NetworkManager.Types.RegisterTransitGatewayResponse) => void): Request<NetworkManager.Types.RegisterTransitGatewayResponse, AWSError>;
  /**
   * Registers a transit gateway in your global network. The transit gateway can be in any AWS Region, but it must be owned by the same AWS account that owns the global network. You cannot register a transit gateway in more than one global network.
   */
  registerTransitGateway(callback?: (err: AWSError, data: NetworkManager.Types.RegisterTransitGatewayResponse) => void): Request<NetworkManager.Types.RegisterTransitGatewayResponse, AWSError>;
  /**
   * Tags a specified resource.
   */
  tagResource(params: NetworkManager.Types.TagResourceRequest, callback?: (err: AWSError, data: NetworkManager.Types.TagResourceResponse) => void): Request<NetworkManager.Types.TagResourceResponse, AWSError>;
  /**
   * Tags a specified resource.
   */
  tagResource(callback?: (err: AWSError, data: NetworkManager.Types.TagResourceResponse) => void): Request<NetworkManager.Types.TagResourceResponse, AWSError>;
  /**
   * Removes tags from a specified resource.
   */
  untagResource(params: NetworkManager.Types.UntagResourceRequest, callback?: (err: AWSError, data: NetworkManager.Types.UntagResourceResponse) => void): Request<NetworkManager.Types.UntagResourceResponse, AWSError>;
  /**
   * Removes tags from a specified resource.
   */
  untagResource(callback?: (err: AWSError, data: NetworkManager.Types.UntagResourceResponse) => void): Request<NetworkManager.Types.UntagResourceResponse, AWSError>;
  /**
   * Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.
   */
  updateDevice(params: NetworkManager.Types.UpdateDeviceRequest, callback?: (err: AWSError, data: NetworkManager.Types.UpdateDeviceResponse) => void): Request<NetworkManager.Types.UpdateDeviceResponse, AWSError>;
  /**
   * Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.
   */
  updateDevice(callback?: (err: AWSError, data: NetworkManager.Types.UpdateDeviceResponse) => void): Request<NetworkManager.Types.UpdateDeviceResponse, AWSError>;
  /**
   * Updates an existing global network. To remove information for any of the parameters, specify an empty string.
   */
  updateGlobalNetwork(params: NetworkManager.Types.UpdateGlobalNetworkRequest, callback?: (err: AWSError, data: NetworkManager.Types.UpdateGlobalNetworkResponse) => void): Request<NetworkManager.Types.UpdateGlobalNetworkResponse, AWSError>;
  /**
   * Updates an existing global network. To remove information for any of the parameters, specify an empty string.
   */
  updateGlobalNetwork(callback?: (err: AWSError, data: NetworkManager.Types.UpdateGlobalNetworkResponse) => void): Request<NetworkManager.Types.UpdateGlobalNetworkResponse, AWSError>;
  /**
   * Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.
   */
  updateLink(params: NetworkManager.Types.UpdateLinkRequest, callback?: (err: AWSError, data: NetworkManager.Types.UpdateLinkResponse) => void): Request<NetworkManager.Types.UpdateLinkResponse, AWSError>;
  /**
   * Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.
   */
  updateLink(callback?: (err: AWSError, data: NetworkManager.Types.UpdateLinkResponse) => void): Request<NetworkManager.Types.UpdateLinkResponse, AWSError>;
  /**
   * Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.
   */
  updateSite(params: NetworkManager.Types.UpdateSiteRequest, callback?: (err: AWSError, data: NetworkManager.Types.UpdateSiteResponse) => void): Request<NetworkManager.Types.UpdateSiteResponse, AWSError>;
  /**
   * Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.
   */
  updateSite(callback?: (err: AWSError, data: NetworkManager.Types.UpdateSiteResponse) => void): Request<NetworkManager.Types.UpdateSiteResponse, AWSError>;
}
declare namespace NetworkManager {
  export interface AssociateCustomerGatewayRequest {
    /**
     * The Amazon Resource Name (ARN) of the customer gateway. For more information, see Resources Defined by Amazon EC2.
     */
    CustomerGatewayArn: String;
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The ID of the device.
     */
    DeviceId: String;
    /**
     * The ID of the link.
     */
    LinkId?: String;
  }
  export interface AssociateCustomerGatewayResponse {
    /**
     * The customer gateway association.
     */
    CustomerGatewayAssociation?: CustomerGatewayAssociation;
  }
  export interface AssociateLinkRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The ID of the device.
     */
    DeviceId: String;
    /**
     * The ID of the link.
     */
    LinkId: String;
  }
  export interface AssociateLinkResponse {
    /**
     * The link association.
     */
    LinkAssociation?: LinkAssociation;
  }
  export interface Bandwidth {
    /**
     * Upload speed in Mbps.
     */
    UploadSpeed?: Integer;
    /**
     * Download speed in Mbps.
     */
    DownloadSpeed?: Integer;
  }
  export interface CreateDeviceRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * A description of the device. Length Constraints: Maximum length of 256 characters.
     */
    Description?: String;
    /**
     * The type of the device.
     */
    Type?: String;
    /**
     * The vendor of the device. Length Constraints: Maximum length of 128 characters.
     */
    Vendor?: String;
    /**
     * The model of the device. Length Constraints: Maximum length of 128 characters.
     */
    Model?: String;
    /**
     * The serial number of the device. Length Constraints: Maximum length of 128 characters.
     */
    SerialNumber?: String;
    /**
     * The location of the device.
     */
    Location?: Location;
    /**
     * The ID of the site.
     */
    SiteId?: String;
    /**
     * The tags to apply to the resource during creation.
     */
    Tags?: TagList;
  }
  export interface CreateDeviceResponse {
    /**
     * Information about the device.
     */
    Device?: Device;
  }
  export interface CreateGlobalNetworkRequest {
    /**
     * A description of the global network. Length Constraints: Maximum length of 256 characters.
     */
    Description?: String;
    /**
     * The tags to apply to the resource during creation.
     */
    Tags?: TagList;
  }
  export interface CreateGlobalNetworkResponse {
    /**
     * Information about the global network object.
     */
    GlobalNetwork?: GlobalNetwork;
  }
  export interface CreateLinkRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * A description of the link. Length Constraints: Maximum length of 256 characters.
     */
    Description?: String;
    /**
     * The type of the link. Constraints: Cannot include the following characters: | \ ^ Length Constraints: Maximum length of 128 characters.
     */
    Type?: String;
    /**
     *  The upload speed and download speed in Mbps. 
     */
    Bandwidth: Bandwidth;
    /**
     * The provider of the link. Constraints: Cannot include the following characters: | \ ^ Length Constraints: Maximum length of 128 characters.
     */
    Provider?: String;
    /**
     * The ID of the site.
     */
    SiteId: String;
    /**
     * The tags to apply to the resource during creation.
     */
    Tags?: TagList;
  }
  export interface CreateLinkResponse {
    /**
     * Information about the link.
     */
    Link?: Link;
  }
  export interface CreateSiteRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * A description of your site. Length Constraints: Maximum length of 256 characters.
     */
    Description?: String;
    /**
     * The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.    Address: The physical address of the site.    Latitude: The latitude of the site.     Longitude: The longitude of the site.  
     */
    Location?: Location;
    /**
     * The tags to apply to the resource during creation.
     */
    Tags?: TagList;
  }
  export interface CreateSiteResponse {
    /**
     * Information about the site.
     */
    Site?: Site;
  }
  export interface CustomerGatewayAssociation {
    /**
     * The Amazon Resource Name (ARN) of the customer gateway.
     */
    CustomerGatewayArn?: String;
    /**
     * The ID of the global network.
     */
    GlobalNetworkId?: String;
    /**
     * The ID of the device.
     */
    DeviceId?: String;
    /**
     * The ID of the link.
     */
    LinkId?: String;
    /**
     * The association state.
     */
    State?: CustomerGatewayAssociationState;
  }
  export type CustomerGatewayAssociationList = CustomerGatewayAssociation[];
  export type CustomerGatewayAssociationState = "PENDING"|"AVAILABLE"|"DELETING"|"DELETED"|string;
  export type DateTime = Date;
  export interface DeleteDeviceRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The ID of the device.
     */
    DeviceId: String;
  }
  export interface DeleteDeviceResponse {
    /**
     * Information about the device.
     */
    Device?: Device;
  }
  export interface DeleteGlobalNetworkRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
  }
  export interface DeleteGlobalNetworkResponse {
    /**
     * Information about the global network.
     */
    GlobalNetwork?: GlobalNetwork;
  }
  export interface DeleteLinkRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The ID of the link.
     */
    LinkId: String;
  }
  export interface DeleteLinkResponse {
    /**
     * Information about the link.
     */
    Link?: Link;
  }
  export interface DeleteSiteRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The ID of the site.
     */
    SiteId: String;
  }
  export interface DeleteSiteResponse {
    /**
     * Information about the site.
     */
    Site?: Site;
  }
  export interface DeregisterTransitGatewayRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The Amazon Resource Name (ARN) of the transit gateway.
     */
    TransitGatewayArn: String;
  }
  export interface DeregisterTransitGatewayResponse {
    /**
     * The transit gateway registration information.
     */
    TransitGatewayRegistration?: TransitGatewayRegistration;
  }
  export interface DescribeGlobalNetworksRequest {
    /**
     * The IDs of one or more global networks. The maximum is 10.
     */
    GlobalNetworkIds?: StringList;
    /**
     * The maximum number of results to return.
     */
    MaxResults?: MaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface DescribeGlobalNetworksResponse {
    /**
     * Information about the global networks.
     */
    GlobalNetworks?: GlobalNetworkList;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface Device {
    /**
     * The ID of the device.
     */
    DeviceId?: String;
    /**
     * The Amazon Resource Name (ARN) of the device.
     */
    DeviceArn?: String;
    /**
     * The ID of the global network.
     */
    GlobalNetworkId?: String;
    /**
     * The description of the device.
     */
    Description?: String;
    /**
     * The device type.
     */
    Type?: String;
    /**
     * The device vendor.
     */
    Vendor?: String;
    /**
     * The device model.
     */
    Model?: String;
    /**
     * The device serial number.
     */
    SerialNumber?: String;
    /**
     * The site location.
     */
    Location?: Location;
    /**
     * The site ID.
     */
    SiteId?: String;
    /**
     * The date and time that the site was created.
     */
    CreatedAt?: DateTime;
    /**
     * The device state.
     */
    State?: DeviceState;
    /**
     * The tags for the device.
     */
    Tags?: TagList;
  }
  export type DeviceList = Device[];
  export type DeviceState = "PENDING"|"AVAILABLE"|"DELETING"|"UPDATING"|string;
  export interface DisassociateCustomerGatewayRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The Amazon Resource Name (ARN) of the customer gateway. For more information, see Resources Defined by Amazon EC2.
     */
    CustomerGatewayArn: String;
  }
  export interface DisassociateCustomerGatewayResponse {
    /**
     * Information about the customer gateway association.
     */
    CustomerGatewayAssociation?: CustomerGatewayAssociation;
  }
  export interface DisassociateLinkRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The ID of the device.
     */
    DeviceId: String;
    /**
     * The ID of the link.
     */
    LinkId: String;
  }
  export interface DisassociateLinkResponse {
    /**
     * Information about the link association.
     */
    LinkAssociation?: LinkAssociation;
  }
  export interface GetCustomerGatewayAssociationsRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * One or more customer gateway Amazon Resource Names (ARNs). For more information, see Resources Defined by Amazon EC2. The maximum is 10.
     */
    CustomerGatewayArns?: StringList;
    /**
     * The maximum number of results to return.
     */
    MaxResults?: MaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetCustomerGatewayAssociationsResponse {
    /**
     * The customer gateway associations.
     */
    CustomerGatewayAssociations?: CustomerGatewayAssociationList;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetDevicesRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * One or more device IDs. The maximum is 10.
     */
    DeviceIds?: StringList;
    /**
     * The ID of the site.
     */
    SiteId?: String;
    /**
     * The maximum number of results to return.
     */
    MaxResults?: MaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetDevicesResponse {
    /**
     * The devices.
     */
    Devices?: DeviceList;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetLinkAssociationsRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The ID of the device.
     */
    DeviceId?: String;
    /**
     * The ID of the link.
     */
    LinkId?: String;
    /**
     * The maximum number of results to return.
     */
    MaxResults?: MaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetLinkAssociationsResponse {
    /**
     * The link associations.
     */
    LinkAssociations?: LinkAssociationList;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetLinksRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * One or more link IDs. The maximum is 10.
     */
    LinkIds?: StringList;
    /**
     * The ID of the site.
     */
    SiteId?: String;
    /**
     * The link type.
     */
    Type?: String;
    /**
     * The link provider.
     */
    Provider?: String;
    /**
     * The maximum number of results to return.
     */
    MaxResults?: MaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetLinksResponse {
    /**
     * The links.
     */
    Links?: LinkList;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetSitesRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * One or more site IDs. The maximum is 10.
     */
    SiteIds?: StringList;
    /**
     * The maximum number of results to return.
     */
    MaxResults?: MaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetSitesResponse {
    /**
     * The sites.
     */
    Sites?: SiteList;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetTransitGatewayRegistrationsRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is 10.
     */
    TransitGatewayArns?: StringList;
    /**
     * The maximum number of results to return.
     */
    MaxResults?: MaxResults;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GetTransitGatewayRegistrationsResponse {
    /**
     * The transit gateway registrations.
     */
    TransitGatewayRegistrations?: TransitGatewayRegistrationList;
    /**
     * The token for the next page of results.
     */
    NextToken?: String;
  }
  export interface GlobalNetwork {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId?: String;
    /**
     * The Amazon Resource Name (ARN) of the global network.
     */
    GlobalNetworkArn?: String;
    /**
     * The description of the global network.
     */
    Description?: String;
    /**
     * The date and time that the global network was created.
     */
    CreatedAt?: DateTime;
    /**
     * The state of the global network.
     */
    State?: GlobalNetworkState;
    /**
     * The tags for the global network.
     */
    Tags?: TagList;
  }
  export type GlobalNetworkList = GlobalNetwork[];
  export type GlobalNetworkState = "PENDING"|"AVAILABLE"|"DELETING"|"UPDATING"|string;
  export type Integer = number;
  export interface Link {
    /**
     * The ID of the link.
     */
    LinkId?: String;
    /**
     * The Amazon Resource Name (ARN) of the link.
     */
    LinkArn?: String;
    /**
     * The ID of the global network.
     */
    GlobalNetworkId?: String;
    /**
     * The ID of the site.
     */
    SiteId?: String;
    /**
     * The description of the link.
     */
    Description?: String;
    /**
     * The type of the link.
     */
    Type?: String;
    /**
     * The bandwidth for the link.
     */
    Bandwidth?: Bandwidth;
    /**
     * The provider of the link.
     */
    Provider?: String;
    /**
     * The date and time that the link was created.
     */
    CreatedAt?: DateTime;
    /**
     * The state of the link.
     */
    State?: LinkState;
    /**
     * The tags for the link.
     */
    Tags?: TagList;
  }
  export interface LinkAssociation {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId?: String;
    /**
     * The device ID for the link association.
     */
    DeviceId?: String;
    /**
     * The ID of the link.
     */
    LinkId?: String;
    /**
     * The state of the association.
     */
    LinkAssociationState?: LinkAssociationState;
  }
  export type LinkAssociationList = LinkAssociation[];
  export type LinkAssociationState = "PENDING"|"AVAILABLE"|"DELETING"|"DELETED"|string;
  export type LinkList = Link[];
  export type LinkState = "PENDING"|"AVAILABLE"|"DELETING"|"UPDATING"|string;
  export interface ListTagsForResourceRequest {
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    ResourceArn: ResourceARN;
  }
  export interface ListTagsForResourceResponse {
    /**
     * The list of tags.
     */
    TagList?: TagList;
  }
  export interface Location {
    /**
     * The physical address.
     */
    Address?: String;
    /**
     * The latitude.
     */
    Latitude?: String;
    /**
     * The longitude.
     */
    Longitude?: String;
  }
  export type MaxResults = number;
  export interface RegisterTransitGatewayRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The Amazon Resource Name (ARN) of the transit gateway. For more information, see Resources Defined by Amazon EC2.
     */
    TransitGatewayArn: String;
  }
  export interface RegisterTransitGatewayResponse {
    /**
     * Information about the transit gateway registration.
     */
    TransitGatewayRegistration?: TransitGatewayRegistration;
  }
  export type ResourceARN = string;
  export interface Site {
    /**
     * The ID of the site.
     */
    SiteId?: String;
    /**
     * The Amazon Resource Name (ARN) of the site.
     */
    SiteArn?: String;
    /**
     * The ID of the global network.
     */
    GlobalNetworkId?: String;
    /**
     * The description of the site.
     */
    Description?: String;
    /**
     * The location of the site.
     */
    Location?: Location;
    /**
     * The date and time that the site was created.
     */
    CreatedAt?: DateTime;
    /**
     * The state of the site.
     */
    State?: SiteState;
    /**
     * The tags for the site.
     */
    Tags?: TagList;
  }
  export type SiteList = Site[];
  export type SiteState = "PENDING"|"AVAILABLE"|"DELETING"|"UPDATING"|string;
  export type String = string;
  export type StringList = String[];
  export interface Tag {
    /**
     * The tag key. Length Constraints: Maximum length of 128 characters.
     */
    Key?: TagKey;
    /**
     * The tag value. Length Constraints: Maximum length of 256 characters.
     */
    Value?: TagValue;
  }
  export type TagKey = string;
  export type TagKeyList = TagKey[];
  export type TagList = Tag[];
  export interface TagResourceRequest {
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    ResourceArn: ResourceARN;
    /**
     * The tags to apply to the specified resource.
     */
    Tags: TagList;
  }
  export interface TagResourceResponse {
  }
  export type TagValue = string;
  export interface TransitGatewayRegistration {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId?: String;
    /**
     * The Amazon Resource Name (ARN) of the transit gateway.
     */
    TransitGatewayArn?: String;
    /**
     * The state of the transit gateway registration.
     */
    State?: TransitGatewayRegistrationStateReason;
  }
  export type TransitGatewayRegistrationList = TransitGatewayRegistration[];
  export type TransitGatewayRegistrationState = "PENDING"|"AVAILABLE"|"DELETING"|"DELETED"|"FAILED"|string;
  export interface TransitGatewayRegistrationStateReason {
    /**
     * The code for the state reason.
     */
    Code?: TransitGatewayRegistrationState;
    /**
     * The message for the state reason.
     */
    Message?: String;
  }
  export interface UntagResourceRequest {
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    ResourceArn: ResourceARN;
    /**
     * The tag keys to remove from the specified resource.
     */
    TagKeys: TagKeyList;
  }
  export interface UntagResourceResponse {
  }
  export interface UpdateDeviceRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The ID of the device.
     */
    DeviceId: String;
    /**
     * A description of the device. Length Constraints: Maximum length of 256 characters.
     */
    Description?: String;
    /**
     * The type of the device.
     */
    Type?: String;
    /**
     * The vendor of the device. Length Constraints: Maximum length of 128 characters.
     */
    Vendor?: String;
    /**
     * The model of the device. Length Constraints: Maximum length of 128 characters.
     */
    Model?: String;
    /**
     * The serial number of the device. Length Constraints: Maximum length of 128 characters.
     */
    SerialNumber?: String;
    Location?: Location;
    /**
     * The ID of the site.
     */
    SiteId?: String;
  }
  export interface UpdateDeviceResponse {
    /**
     * Information about the device.
     */
    Device?: Device;
  }
  export interface UpdateGlobalNetworkRequest {
    /**
     * The ID of your global network.
     */
    GlobalNetworkId: String;
    /**
     * A description of the global network. Length Constraints: Maximum length of 256 characters.
     */
    Description?: String;
  }
  export interface UpdateGlobalNetworkResponse {
    /**
     * Information about the global network object.
     */
    GlobalNetwork?: GlobalNetwork;
  }
  export interface UpdateLinkRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The ID of the link.
     */
    LinkId: String;
    /**
     * A description of the link. Length Constraints: Maximum length of 256 characters.
     */
    Description?: String;
    /**
     * The type of the link. Length Constraints: Maximum length of 128 characters.
     */
    Type?: String;
    /**
     * The upload and download speed in Mbps. 
     */
    Bandwidth?: Bandwidth;
    /**
     * The provider of the link. Length Constraints: Maximum length of 128 characters.
     */
    Provider?: String;
  }
  export interface UpdateLinkResponse {
    /**
     * Information about the link.
     */
    Link?: Link;
  }
  export interface UpdateSiteRequest {
    /**
     * The ID of the global network.
     */
    GlobalNetworkId: String;
    /**
     * The ID of your site.
     */
    SiteId: String;
    /**
     * A description of your site. Length Constraints: Maximum length of 256 characters.
     */
    Description?: String;
    /**
     * The site location:    Address: The physical address of the site.    Latitude: The latitude of the site.     Longitude: The longitude of the site.  
     */
    Location?: Location;
  }
  export interface UpdateSiteResponse {
    /**
     * Information about the site.
     */
    Site?: Site;
  }
  /**
   * A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service. Specify 'latest' to use the latest possible version.
   */
  export type apiVersion = "2019-07-05"|"latest"|string;
  export interface ClientApiVersions {
    /**
     * A string in YYYY-MM-DD format that represents the latest possible API version that can be used in this service. Specify 'latest' to use the latest possible version.
     */
    apiVersion?: apiVersion;
  }
  export type ClientConfiguration = ServiceConfigurationOptions & ClientApiVersions;
  /**
   * Contains interfaces for use with the NetworkManager client.
   */
  export import Types = NetworkManager;
}
export = NetworkManager;
