# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2019-01-24 17:03
from __future__ import unicode_literals

import colorfield.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import filer.fields.image
import parler.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='Accessibility',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('accessKey', models.CharField(blank=True, help_text='Remaps the accesskey that the module is assigned to', max_length=512, null=True)),
                ('highlightFocus', models.NullBooleanField(help_text='Determines if the module should use more accentuated styling to highlight elements in focus')),
            ],
        ),
        migrations.CreateModel(
            name='Branding',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='A Unique identifier for this branding', max_length=255)),
                ('fontFamily', models.CharField(blank=True, help_text='CSS font-family for the entire module e.g. Arial, sans-serif', max_length=255, null=True)),
                ('fontSizeTitle', models.CharField(blank=True, help_text='CSS font-size for the main (h2) title e.g. 1.2em', max_length=255, null=True)),
                ('fontSizeHeaders', models.CharField(blank=True, help_text='CSS font-size for the sub (h3) titles e.g. 1em', max_length=255, null=True)),
                ('fontSize', models.CharField(blank=True, help_text='CSS font-size throughout the module e.g. 0.8em', max_length=255, null=True)),
                ('fontColor', colorfield.fields.ColorField(blank=True, help_text='CSS color for all text and icons within the module.', max_length=18, null=True)),
                ('backgroundColor', colorfield.fields.ColorField(blank=True, help_text='CSS background-color within the module.', max_length=18, null=True)),
                ('acceptText', colorfield.fields.ColorField(blank=True, help_text="CSS color for text of the module's primary 'accept' buttons", max_length=18, null=True)),
                ('acceptBackground', colorfield.fields.ColorField(blank=True, help_text="CSS background-color for the module's primary 'accept' buttons", max_length=18, null=True)),
                ('toggleText', colorfield.fields.ColorField(blank=True, help_text="CSS color for the toggle button's text", max_length=18, null=True)),
                ('toggleColor', colorfield.fields.ColorField(blank=True, help_text='CSS background-color for the movable part of the toggle slider', max_length=18, null=True)),
                ('toggleBackground', colorfield.fields.ColorField(blank=True, help_text='CSS background-color for the toggle background.', max_length=18, null=True)),
                ('alertText', colorfield.fields.ColorField(blank=True, help_text='CSS color within the alert areas', max_length=18, null=True)),
                ('alertBackground', colorfield.fields.ColorField(blank=True, help_text='CSS background-color to highlight the alert areas', max_length=18, null=True)),
                ('buttonIconWidth', models.CharField(blank=True, help_text='If buttonIcon exists, the css width', max_length=255, null=True)),
                ('buttonIconHeight', models.CharField(blank=True, help_text='If buttonIcon exists, the css height', max_length=255, null=True)),
                ('removeIcon', models.NullBooleanField(help_text="Whether or not to remove the button icon entirely. Please note, if you do this, you will need to present an alternative trigger to run the module's open() function.")),
                ('removeAbout', models.NullBooleanField(help_text="Whether or not to remove the 'About this tool' link")),
                ('buttonIcon', filer.fields.image.FilerImageField(blank=True, help_text='Icon in the bottom corner', null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.FILER_IMAGE_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='CallbackFunction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('automated_prefix', models.CharField(blank=True, max_length=512, null=True)),
                ('function_text', models.TextField(blank=True, help_text='JavaScript function, e.g. "function () {...}" ', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Cookie',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=512, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='CookieControl',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('apiKey', models.CharField(max_length=255)),
                ('product', models.CharField(choices=[(b'COMMUNITY', b'COMMUNITY'), (b'PRO', b'PRO'), (b'PRO_MULTISITE', b'PRO_MULTISITE')], max_length=255)),
                ('position', models.CharField(blank=True, choices=[(b'LEFT', b'LEFT'), (b'RIGHT', b'RIGHT')], max_length=255, null=True)),
                ('theme', models.CharField(blank=True, choices=[(b'LIGHT', b'LIGHT'), (b'DARK', b'DARK')], max_length=255, null=True)),
                ('toggleType', models.CharField(blank=True, choices=[(b'slider', b'slider'), (b'checkbox', b'checkbox')], max_length=255, null=True)),
                ('closeStyle', models.CharField(blank=True, choices=[(b'icon', b'icon'), (b'labelled', b'labelled'), (b'button', b'button')], max_length=255, null=True)),
                ('consentCookieExpiry', models.PositiveIntegerField(blank=True, default=90, null=True)),
                ('logConsent', models.NullBooleanField()),
                ('notifyOnce', models.NullBooleanField()),
                ('initialState', models.CharField(blank=True, choices=[(b'open', b'open'), (b'closed', b'closed'), (b'notify', b'notify')], max_length=255, null=True)),
                ('layout', models.CharField(blank=True, choices=[(b'slideout', b'slideout'), (b'popup', b'popup')], max_length=255, null=True)),
                ('excludedCountries', django_countries.fields.CountryField(blank=True, max_length=746, multiple=True)),
                ('accessibility', models.ForeignKey(blank=True, help_text='Determines the accessibility helpers available.', null=True, on_delete=django.db.models.deletion.CASCADE, to='django_cookie_control.Accessibility')),
                ('branding', models.ForeignKey(blank=True, help_text="Set all aspects of the module's styling, and remove any back links to CIVIC.", null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_cookie_control.Branding')),
                ('necessaryCookies', models.ManyToManyField(blank=True, help_text="List of cookie names necessary for your website's core functionality,", to='django_cookie_control.Cookie')),
                ('onLoad', models.ForeignKey(blank=True, help_text='Defines a function to be triggered after the module initiates.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_cookie_control.CallbackFunction')),
            ],
            options={
                'verbose_name': 'Cookie Control',
                'verbose_name_plural': 'Cookie Controls',
            },
        ),
        migrations.CreateModel(
            name='PurposeObject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('recommendedState', models.NullBooleanField(help_text='Should category be accepted (opted in)')),
                ('lawfulBasis', models.CharField(blank=True, choices=[(b'consent', b'Consent'), (b'legitimate interest', b'Legitimate Interest')], help_text='requires explicit user consent', max_length=255, null=True)),
                ('cookies', models.ManyToManyField(blank=True, to='django_cookie_control.Cookie')),
                ('onAccept', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='accept_function', to='django_cookie_control.CallbackFunction')),
                ('onRevoke', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='revoke_function', to='django_cookie_control.CallbackFunction')),
            ],
            options={
                'verbose_name': 'Optional Cookie Control',
                'verbose_name_plural': 'Optional Cookie Controls',
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='PurposeObjectTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('name', models.CharField(max_length=255, verbose_name='A Unique identifier for the category')),
                ('label', models.CharField(blank=True, help_text='Descriptive Title', max_length=512, null=True)),
                ('description', models.TextField(blank=True, help_text='Text introducing the privacy statement', null=True)),
                ('master', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='django_cookie_control.PurposeObject')),
            ],
            options={
                'managed': True,
                'db_table': 'django_cookie_control_purposeobject_translation',
                'db_tablespace': '',
                'default_permissions': (),
                'verbose_name': 'Optional Cookie Control Translation',
            },
        ),
        migrations.CreateModel(
            name='Statement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(blank=True, help_text='URL where your terms may be accessed', max_length=512, null=True)),
                ('updated', models.DateField(blank=True, help_text='Terms updated date', null=True)),
            ],
            options={
                'abstract': False,
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='StatementTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, help_text='Text introducing the privacy statement', null=True)),
                ('master', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='django_cookie_control.Statement')),
            ],
            options={
                'managed': True,
                'db_table': 'django_cookie_control_statement_translation',
                'db_tablespace': '',
                'default_permissions': (),
                'verbose_name': 'statement Translation',
            },
        ),
        migrations.CreateModel(
            name='TextValue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'abstract': False,
            },
            bases=(parler.models.TranslatableModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='TextValueTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('title', models.TextField(blank=True, null=True)),
                ('intro', models.TextField(blank=True, null=True)),
                ('acceptRecommended', models.TextField(blank=True, null=True)),
                ('necessaryTitle', models.TextField(blank=True, null=True)),
                ('necessaryDescription', models.TextField(blank=True, null=True)),
                ('thirdPartyTitle', models.TextField(blank=True, null=True)),
                ('thirdPartyDescription', models.TextField(blank=True, null=True)),
                ('on', models.TextField(blank=True, null=True)),
                ('off', models.TextField(blank=True, null=True)),
                ('notifyTitle', models.TextField(blank=True, null=True)),
                ('notifyDescription', models.TextField(blank=True, null=True)),
                ('accept', models.TextField(blank=True, null=True)),
                ('settings', models.TextField(blank=True, null=True)),
                ('closeLabel', models.TextField(blank=True, null=True)),
                ('accessibilityAlert', models.TextField(blank=True, null=True)),
                ('master', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='django_cookie_control.TextValue')),
            ],
            options={
                'managed': True,
                'db_table': 'django_cookie_control_textvalue_translation',
                'db_tablespace': '',
                'default_permissions': (),
                'verbose_name': 'text value Translation',
            },
        ),
        migrations.CreateModel(
            name='ThirdPartyCookie',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=512)),
                ('optOutLink', models.URLField(help_text='Opt-out Link for third-party cookies')),
            ],
        ),
        migrations.AddField(
            model_name='purposeobject',
            name='thirdPartyCookies',
            field=models.ManyToManyField(blank=True, to='django_cookie_control.ThirdPartyCookie'),
        ),
        migrations.AddField(
            model_name='cookiecontrol',
            name='optionalCookies',
            field=models.ManyToManyField(blank=True, help_text='List of Optional Cookie Groups that your website may use.', to='django_cookie_control.PurposeObject'),
        ),
        migrations.AddField(
            model_name='cookiecontrol',
            name='site',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='sites.Site'),
        ),
        migrations.AddField(
            model_name='cookiecontrol',
            name='statement',
            field=models.ForeignKey(blank=True, help_text='Cookie Control will respect user given consent until either the cookie expires, or there is a change in your privacy statement.', null=True, on_delete=django.db.models.deletion.CASCADE, to='django_cookie_control.Statement'),
        ),
        migrations.AddField(
            model_name='cookiecontrol',
            name='text',
            field=models.ForeignKey(blank=True, help_text='Determines the text used by Cookie Control.', null=True, on_delete=django.db.models.deletion.CASCADE, to='django_cookie_control.TextValue'),
        ),
        migrations.AlterUniqueTogether(
            name='textvaluetranslation',
            unique_together=set([('language_code', 'master')]),
        ),
        migrations.AlterUniqueTogether(
            name='statementtranslation',
            unique_together=set([('language_code', 'master')]),
        ),
        migrations.AlterUniqueTogether(
            name='purposeobjecttranslation',
            unique_together=set([('language_code', 'master')]),
        ),
    ]
