# Generated by Django 2.2.14 on 2020-08-21 01:18

from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields


class Migration(migrations.Migration):

    dependencies = [
        ('django_cookie_control', '0008_auto_20200820_1651'),
    ]

    operations = [
        migrations.AddField(
            model_name='cookiecontrol',
            name='acceptBehaviour',
            field=models.CharField(blank=True, choices=[('all', 'all'), ('recommended', 'recommended')], help_text="This property is used to control what will happen when the user clicks on either of the 'Accept' or 'Accept recommended settings' buttons. ", max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='cookiecontrol',
            name='subDomains',
            field=models.NullBooleanField(help_text="Determines whether Cookie Control's own cookie is saved to the top level domain, and therefore accessible on all sub domains, or disabled and saved only to the request host."),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='branding',
            field=models.ForeignKey(blank=True, help_text="[Pro version only] Set all aspects of the module's styling, and remove any back links to CIVIC.", null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_cookie_control.Branding'),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='closeStyle',
            field=models.CharField(blank=True, choices=[('icon', 'icon'), ('labelled', 'labelled'), ('button', 'button')], help_text='Determines the closing behaviour of the module.', max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='consentCookieExpiry',
            field=models.PositiveIntegerField(blank=True, default=90, help_text='Determines how many days the consent of the user will be remembered for.', null=True),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='excludedCountries',
            field=django_countries.fields.CountryField(blank=True, help_text='[Pro version only] able the module entirely for visitors outside of the EU. Either add the value all, or a list of 2 letter ISO codes for the countries you wish to disable the module', max_length=746, multiple=True),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='iabCMP',
            field=models.BooleanField(default=False, help_text='Determines whether or not Cookie Control runs as and the IAB TCF v2.0 compliant CMP. Please note that when using Cookie Control as an IAB CMP, you cannot use any of the more subtle interfaces like notify or box. IAB requires certain view and text so Cookie Control will render in open state.'),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='initialState',
            field=models.CharField(blank=True, choices=[('All Versions', (('open', 'open'), ('closed', 'closed'))), ('[Pro Version Only]', (('notify', 'notify'), ('top', 'top'), ('box', 'box')))], help_text='Possible values are either open, closed, notify (pro licenses only), top (pro licenses only) or box (pro licenses only).', max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='logConsent',
            field=models.NullBooleanField(help_text='Determines how many days the consent of the user will be remembered for.'),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='notifyOnce',
            field=models.NullBooleanField(help_text='Determines whether the module only shows its initialState once, or if it continues to replay on subsequent page loads until the user has directly interacted with it '),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='position',
            field=models.CharField(blank=True, choices=[('left', 'LEFT'), ('right', 'RIGHT')], help_text='Determines the side of the display Cookie Control will occupy.', max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='theme',
            field=models.CharField(blank=True, choices=[('light', 'LIGHT'), ('dark', 'DARK')], help_text='Determines the appearance of Cookie Control', max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='cookiecontrol',
            name='toggleType',
            field=models.CharField(blank=True, choices=[('slider', 'slider'), ('checkbox', 'checkbox')], help_text='Determines the control toggle for each item within optionalCookies', max_length=255, null=True),
        ),
    ]
