# lodgea-python
LODGEA SDK for Python. Check out https://docs.lodgea.io for more information.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.0
- Package version: 
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import lodgea-python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lodgea-python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import lodgea-python
from pprint import pprint
from com.lodgea.controllers import default_api
from lodgea-python.model.availability_search_post200_response import AvailabilitySearchPost200Response
from lodgea-python.model.availability_search_post_request import AvailabilitySearchPostRequest
from lodgea-python.model.location_search_post200_response import LocationSearchPost200Response
from lodgea-python.model.location_search_post400_response import LocationSearchPost400Response
from lodgea-python.model.location_search_post_request import LocationSearchPostRequest
from lodgea-python.model.properties_get200_response import PropertiesGet200Response
from lodgea-python.model.properties_property_id_availability_get200_response import PropertiesPropertyIdAvailabilityGet200Response
from lodgea-python.model.properties_property_id_get200_response import PropertiesPropertyIdGet200Response
# Defining the host is optional and defaults to https://api.eu.lodgea.io/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = lodgea-python.Configuration(
    host = "https://api.eu.lodgea.io/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with lodgea-python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    availability_search_post_request = AvailabilitySearchPostRequest(
        adult_count=2,
        child_count=2,
        child_age_list=[4,7],
        currency_code="EUR",
        language_code="en",
        unit_system="metric",
        min_length_of_stay=1,
        max_length_of_stay=27,
        location_name="Oberbayern",
        location_type="locality",
        earliest_arrival="2022-09-01",
        latest_return="2022-09-08",
        sort="price",
        service_list=[1,2],
        type_list=[3,4],
        unit_type_list=[5,6],
        unit_amenity_list=[7,8],
        meal_plan_list=[9,10],
    ) # AvailabilitySearchPostRequest |  (optional)

    try:
        # Search for availability
        api_response = api_instance.availability_search_post(availability_search_post_request=availability_search_post_request)
        pprint(api_response)
    except lodgea-python.ApiException as e:
        print("Exception when calling DefaultApi->availability_search_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.eu.lodgea.io/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**availability_search_post**](docs/DefaultApi.md#availability_search_post) | **POST** /availability/search | Search for availability
*DefaultApi* | [**location_search_post**](docs/DefaultApi.md#location_search_post) | **POST** /location/search | Search for location
*DefaultApi* | [**properties_get**](docs/DefaultApi.md#properties_get) | **GET** /properties | List (filtered) properties
*DefaultApi* | [**properties_property_id_availability_get**](docs/DefaultApi.md#properties_property_id_availability_get) | **GET** /properties/{propertyId}/availability | Get a properties availability
*DefaultApi* | [**properties_property_id_get**](docs/DefaultApi.md#properties_property_id_get) | **GET** /properties/{propertyId} | Get a properties details


## Documentation For Models

 - [AvailabilitySearchPost200Response](docs/AvailabilitySearchPost200Response.md)
 - [AvailabilitySearchPostRequest](docs/AvailabilitySearchPostRequest.md)
 - [AvailablePropertiesInner](docs/AvailablePropertiesInner.md)
 - [AvailablePropertiesInner1](docs/AvailablePropertiesInner1.md)
 - [AvailablePropertiesInner1AttractionListInner](docs/AvailablePropertiesInner1AttractionListInner.md)
 - [AvailablePropertiesInner1AttractionListInnerDistance](docs/AvailablePropertiesInner1AttractionListInnerDistance.md)
 - [AvailablePropertiesInner1Geo](docs/AvailablePropertiesInner1Geo.md)
 - [AvailablePropertiesInner1GeoLocation](docs/AvailablePropertiesInner1GeoLocation.md)
 - [AvailablePropertiesInner1LowestPrice](docs/AvailablePropertiesInner1LowestPrice.md)
 - [AvailablePropertiesInner1MediaListInner](docs/AvailablePropertiesInner1MediaListInner.md)
 - [LocationSearchPost200Response](docs/LocationSearchPost200Response.md)
 - [LocationSearchPost400Response](docs/LocationSearchPost400Response.md)
 - [LocationSearchPost400ResponseValidationErrorsInner](docs/LocationSearchPost400ResponseValidationErrorsInner.md)
 - [LocationSearchPostRequest](docs/LocationSearchPostRequest.md)
 - [PropertiesGet200Response](docs/PropertiesGet200Response.md)
 - [PropertiesGet200ResponseListInner](docs/PropertiesGet200ResponseListInner.md)
 - [PropertiesPropertyIdAvailabilityGet200Response](docs/PropertiesPropertyIdAvailabilityGet200Response.md)
 - [PropertiesPropertyIdAvailabilityGet200ResponseAvailabilityListInner](docs/PropertiesPropertyIdAvailabilityGet200ResponseAvailabilityListInner.md)
 - [PropertiesPropertyIdGet200Response](docs/PropertiesPropertyIdGet200Response.md)
 - [PropertiesPropertyIdGet200ResponseProductListInner](docs/PropertiesPropertyIdGet200ResponseProductListInner.md)
 - [PropertiesPropertyIdGet200ResponseProductListInnerPolicyInfo](docs/PropertiesPropertyIdGet200ResponseProductListInnerPolicyInfo.md)
 - [PropertiesPropertyIdGet200ResponseProductListInnerRatePlanListInner](docs/PropertiesPropertyIdGet200ResponseProductListInnerRatePlanListInner.md)
 - [PropertiesPropertyIdGet200ResponseProductListInnerRatePlanListInnerPricingListInner](docs/PropertiesPropertyIdGet200ResponseProductListInnerRatePlanListInnerPricingListInner.md)
 - [PropertiesPropertyIdGet200ResponseProperty](docs/PropertiesPropertyIdGet200ResponseProperty.md)
 - [PropertiesPropertyIdGet200ResponsePropertyAwardListInner](docs/PropertiesPropertyIdGet200ResponsePropertyAwardListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyCancellationGracePeriod](docs/PropertiesPropertyIdGet200ResponsePropertyCancellationGracePeriod.md)
 - [PropertiesPropertyIdGet200ResponsePropertyContactListInner](docs/PropertiesPropertyIdGet200ResponsePropertyContactListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyContactListInnerAddressListInner](docs/PropertiesPropertyIdGet200ResponsePropertyContactListInnerAddressListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyFacilityInfo](docs/PropertiesPropertyIdGet200ResponsePropertyFacilityInfo.md)
 - [PropertiesPropertyIdGet200ResponsePropertyFacilityInfoGuestRoomListInner](docs/PropertiesPropertyIdGet200ResponsePropertyFacilityInfoGuestRoomListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyFacilityInfoGuestRoomListInnerAmenityListInner](docs/PropertiesPropertyIdGet200ResponsePropertyFacilityInfoGuestRoomListInnerAmenityListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyFacilityInfoGuestRoomListInnerMediaListInner](docs/PropertiesPropertyIdGet200ResponsePropertyFacilityInfoGuestRoomListInnerMediaListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyFacilityInfoGuestRoomListInnerMessageListInner](docs/PropertiesPropertyIdGet200ResponsePropertyFacilityInfoGuestRoomListInnerMessageListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyGuestInfo](docs/PropertiesPropertyIdGet200ResponsePropertyGuestInfo.md)
 - [PropertiesPropertyIdGet200ResponsePropertyPolicyListInner](docs/PropertiesPropertyIdGet200ResponsePropertyPolicyListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyPolicyListInnerCancellationPolicyListInner](docs/PropertiesPropertyIdGet200ResponsePropertyPolicyListInnerCancellationPolicyListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyPolicyListInnerFeePolicyListInner](docs/PropertiesPropertyIdGet200ResponsePropertyPolicyListInnerFeePolicyListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyPolicyListInnerGuaranteePolicy](docs/PropertiesPropertyIdGet200ResponsePropertyPolicyListInnerGuaranteePolicy.md)
 - [PropertiesPropertyIdGet200ResponsePropertyPolicyListInnerPetsPolicy](docs/PropertiesPropertyIdGet200ResponsePropertyPolicyListInnerPetsPolicy.md)
 - [PropertiesPropertyIdGet200ResponsePropertyPolicyListInnerTaxPolicyListInner](docs/PropertiesPropertyIdGet200ResponsePropertyPolicyListInnerTaxPolicyListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyPropertyInfo](docs/PropertiesPropertyIdGet200ResponsePropertyPropertyInfo.md)
 - [PropertiesPropertyIdGet200ResponsePropertyPropertyInfoAcceptedPaymentListInner](docs/PropertiesPropertyIdGet200ResponsePropertyPropertyInfoAcceptedPaymentListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyPropertyInfoMessageListInner](docs/PropertiesPropertyIdGet200ResponsePropertyPropertyInfoMessageListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyRecordCreated](docs/PropertiesPropertyIdGet200ResponsePropertyRecordCreated.md)
 - [PropertiesPropertyIdGet200ResponsePropertyRecordModified](docs/PropertiesPropertyIdGet200ResponsePropertyRecordModified.md)
 - [PropertiesPropertyIdGet200ResponsePropertyServiceListInner](docs/PropertiesPropertyIdGet200ResponsePropertyServiceListInner.md)
 - [PropertiesPropertyIdGet200ResponsePropertyServiceListInnerOperationTimeListInner](docs/PropertiesPropertyIdGet200ResponsePropertyServiceListInnerOperationTimeListInner.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: apiKey
- **Location**: HTTP header


## Author

support@lodgea.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in lodgea-python.apis and lodgea-python.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from lodgea-python.api.default_api import DefaultApi`
- `from lodgea-python.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import lodgea-python
from lodgea-python.apis import *
from lodgea-python.models import *
```

